/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenPattern;
import oracle.javatools.db.token.TokenPattern;

public class PlSqlSearch {
    private final TokenPattern m_pattern;
    private TokenPattern.PatternResult m_matchResult;

    public PlSqlSearch(String expression) {
        this.m_pattern = new PlSqlTokenPattern(expression);
    }

    public final boolean matches(String source) {
        this.m_matchResult = this.m_pattern.getResult(source);
        return this.m_matchResult != null;
    }

    public final boolean matches(PlSqlToken startToken) {
        this.m_matchResult = this.m_pattern.getResult(startToken);
        return this.m_matchResult != null;
    }

    public final boolean matches(PlSqlToken startToken, PlSqlToken endToken) {
        this.m_matchResult = this.m_pattern.getResult(startToken, endToken);
        return this.m_matchResult != null;
    }

    public final boolean isWithin(String source) {
        this.m_matchResult = this.m_pattern.getResult(source, false);
        return this.m_matchResult != null;
    }

    public final boolean isWithin(PlSqlToken startToken) {
        this.m_matchResult = this.m_pattern.getResult(startToken, false);
        return this.m_matchResult != null;
    }

    public final boolean isWithin(PlSqlToken startToken, PlSqlToken endToken) {
        this.m_matchResult = this.m_pattern.getResult(startToken, endToken, false);
        return this.m_matchResult != null;
    }

    public final String getNamedMatch(String name) {
        return this.m_matchResult == null ? null : this.m_matchResult.getNamedMatch(name);
    }

    public final String getNamedMatch(String name, boolean format) {
        return this.m_matchResult == null ? null : this.m_matchResult.getNamedMatch(name, format);
    }

    public final PlSqlToken getNamedMatchStartToken(String name) {
        return this.m_matchResult == null ? null : this.m_matchResult.getNamedMatchStartToken(name);
    }

    public final PlSqlToken getNamedMatchEndToken(String name) {
        return this.m_matchResult == null ? null : this.m_matchResult.getNamedMatchEndToken(name);
    }

    public PlSqlToken getStartToken() {
        return this.m_matchResult == null ? null : this.m_matchResult.getStartToken();
    }

    public PlSqlToken getEndToken() {
        return this.m_matchResult == null ? null : this.m_matchResult.getEndToken();
    }

    public String[] getNames() {
        return this.m_pattern.getNames();
    }

    public int getTokenCount() {
        return this.m_matchResult == null ? 0 : this.m_matchResult.getTokenCount();
    }
}

