/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.resource.PlSqlBundle;
import oracle.javatools.db.token.Token;
import oracle.javatools.parser.plsql.data.PlsqlError;
import oracle.javatools.parser.plsql.data.PlsqlNode;
import oracle.javatools.parser.plsql.data.PlsqlRoot;

@Deprecated
public class PlSqlFragment
implements PlsqlRoot {
    private Type m_type;
    private AlterSubType m_alterSubType;
    private PlSqlToken m_firstToken;
    private PlSqlToken m_lastToken;
    private ArrayList<PlSqlFragment> m_subFragments;
    private PlSqlFragment m_parent;
    private WeakReference<PlSqlInterrogator> m_plsInt;
    private static final Type m_packageSpec = Type.PACKAGE_SPEC;
    public static final int TYPE_PACKAGE_SPEC = m_packageSpec.ordinal();
    private static final Type m_packageBody = Type.PACKAGE_BODY;
    public static final int TYPE_PACKAGE_BODY = m_packageBody.ordinal();

    PlSqlFragment(PlSqlInterrogator plsInt, PlSqlFragment parent) {
        this.initialise(plsInt, parent);
    }

    PlSqlFragment(PlSqlInterrogator plsInt) {
        this.initialise(plsInt, null);
    }

    private void initialise(PlSqlInterrogator plsInt, PlSqlFragment parent) {
        this.m_plsInt = new WeakReference<PlSqlInterrogator>(plsInt);
        this.m_type = Type.UNKNOWN;
        this.m_firstToken = null;
        this.m_lastToken = null;
        this.m_subFragments = new ArrayList();
        this.m_parent = parent;
        if (parent != null) {
            parent.m_subFragments.add(this);
        }
    }

    public PlSqlFragment getParent() {
        return this.m_parent;
    }

    @Deprecated
    public int getType() {
        return this.m_type.ordinal();
    }

    @Deprecated
    public Type getFramentType() {
        return this.getFragmentType();
    }

    public Type getFragmentType() {
        return this.m_type;
    }

    public void setFragmentType(Type type) {
        this.m_type = type;
    }

    public PlSqlToken getFirstToken() {
        return this.m_firstToken;
    }

    public void setAlterSubType(AlterSubType alterSubType) {
        this.m_alterSubType = alterSubType;
    }

    public AlterSubType getAlterSubType() {
        return this.m_alterSubType;
    }

    public void setFirstToken(PlSqlToken firstToken) {
        this.m_firstToken = firstToken;
    }

    public PlSqlToken getLastToken() {
        if (this.m_lastToken == null && this.m_firstToken != null) {
            this.m_lastToken = this.m_firstToken;
            while (this.m_lastToken.getNextCodeToken() != null && ((PlSqlToken)this.m_lastToken.getNextCodeToken()).getType() != Token.Type.END_MARKER) {
                this.m_lastToken = (PlSqlToken)this.m_lastToken.getNextCodeToken();
            }
        }
        return this.m_lastToken;
    }

    public void setLastToken(PlSqlToken lastToken) {
        this.m_lastToken = lastToken;
    }

    @Deprecated
    public final ArrayList getSubFragments() {
        return this.m_subFragments;
    }

    public PlSqlFragment[] getChildren() {
        return this.m_subFragments.toArray(new PlSqlFragment[this.m_subFragments.size()]);
    }

    public String getSource() {
        PlSqlToken lastTk = this.m_lastToken;
        if (lastTk == null) {
            lastTk = this.m_firstToken;
            while (lastTk.getType() != Token.Type.END_MARKER) {
                lastTk = (PlSqlToken)lastTk.getNextToken();
            }
            lastTk = (PlSqlToken)lastTk.getPrevCodeToken();
        }
        return this.m_firstToken.getSource(false, lastTk);
    }

    public String getSourceSnippet(int maxChars) {
        PlSqlToken tk = this.m_firstToken;
        PlSqlToken lastTk = this.m_lastToken;
        boolean lastWasCode = true;
        if (lastTk == null) {
            lastTk = this.m_firstToken;
            while (lastTk.getType() != Token.Type.END_MARKER) {
                lastTk = (PlSqlToken)lastTk.getNextToken();
            }
            lastTk = (PlSqlToken)lastTk.getPrevCodeToken();
        }
        String retval = "";
        while (tk.getType() != Token.Type.END_MARKER && tk.getStart() <= lastTk.getStart()) {
            if (retval.length() + tk.getSource().length() < maxChars - 4) {
                if (tk.isCode()) {
                    if (!lastWasCode) {
                        retval = retval + " ";
                    }
                    lastWasCode = true;
                    retval = retval + tk.getSource();
                } else {
                    lastWasCode = false;
                }
            } else {
                retval = retval + "...";
                break;
            }
            tk = (PlSqlToken)tk.getNextToken();
        }
        return retval;
    }

    @Deprecated
    public PlsqlError[] getErrors() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public PlsqlNode[] getUnits() {
        throw new UnsupportedOperationException();
    }

    public int getTreeKind() {
        return this.m_type.ordinal();
    }

    public int getStartOffset() {
        return this.m_firstToken.getStart();
    }

    public int getEndOffset() {
        if (this.m_lastToken == null) {
            PlSqlToken tk = this.m_firstToken;
            if (tk.getType() != Token.Type.END_MARKER) {
                while (((PlSqlToken)tk.getNextToken()).getType() != Token.Type.END_MARKER) {
                    tk = (PlSqlToken)tk.getNextToken();
                }
            }
            this.m_lastToken = tk;
        }
        return this.m_lastToken.getEnd();
    }

    public String getTypeString() {
        return PlSqlFragment.getTypeString(this.m_type);
    }

    public static String getTypeString(Type type) {
        if (type == Type.PROCEDURE_FD) {
            type = Type.PROCEDURE;
        } else if (type == Type.FUNCTION_FD) {
            type = Type.FUNCTION;
        }
        String str = null;
        try {
            str = PlSqlBundle.get(type.toString());
        }
        catch (MissingResourceException mre) {
            str = PlSqlBundle.get("UNKNOWN");
        }
        return str;
    }

    @Deprecated
    public String getDescriptionString() {
        return this.getDescriptionImpl(true, null);
    }

    public String getDescription(Integer maxSize) {
        return this.getDescriptionImpl(false, maxSize);
    }

    private String getDescriptionImpl(boolean forStructurePane, Integer maxSize) {
        String retval = null;
        if (forStructurePane) {
            retval = PlSqlFragment.getTypeString(this.m_type);
        } else {
            retval = this.m_type.toString().toLowerCase();
            int pos = retval.indexOf("_");
            if (pos > 0) {
                retval = retval.substring(0, pos);
            }
        }
        switch (this.m_type) {
            case PARAMETER: {
                retval = this.getFirstToken().getSource();
                break;
            }
            case DECLARATION: {
                if (this.getFirstToken().matches("TYPE") || this.getFirstToken().matches("SUBTYPE")) {
                    retval = ((PlSqlToken)this.getFirstToken().getNextCodeToken()).getSource();
                    break;
                }
                if (this.getAlterSubType() != null && this.getFirstToken().matches("(")) {
                    retval = ((PlSqlToken)this.getFirstToken().getNextCodeToken()).getSource() + "...";
                    break;
                }
                retval = this.getFirstToken().getSource();
                break;
            }
            case CURSOR: {
                retval = ((PlSqlToken)this.getFirstToken().getNextCodeToken()).getSource();
                break;
            }
            case TRIGGER_TIMING: 
            case TRIGGER_TABLE: {
                retval = retval + ": " + this.getSource();
                break;
            }
            case PACKAGE_SPEC: 
            case TYPE_SPEC: 
            case TRIGGER: {
                PlSqlToken tk = (PlSqlToken)this.getFirstToken().getNextCodeToken();
                retval = retval + ": " + this.getSourceToWS(tk);
                break;
            }
            case PACKAGE_BODY: 
            case TYPE_BODY: {
                PlSqlToken tk = (PlSqlToken)((PlSqlToken)this.getFirstToken().getNextCodeToken()).getNextCodeToken();
                retval = retval + ": " + this.getSourceToWS(tk);
                break;
            }
            case PROCEDURE: 
            case PROCEDURE_FD: 
            case FUNCTION: 
            case FUNCTION_FD: {
                try {
                    PlSqlToken tk = this.getFirstToken();
                    while (!tk.matches("PROCEDURE") && !tk.matches("FUNCTION")) {
                        tk = (PlSqlToken)tk.getNextCodeToken();
                    }
                    tk = (PlSqlToken)tk.getNextCodeToken();
                    retval = tk.getSource();
                    if ((tk = (PlSqlToken)tk.getNextCodeToken()).matches(".")) {
                        retval = retval + tk.getSource();
                        tk = (PlSqlToken)tk.getNextCodeToken();
                        retval = retval + tk.getSource();
                        tk = (PlSqlToken)tk.getNextCodeToken();
                    }
                    if (tk.matches("(")) {
                        retval = retval + tk.getSource();
                        tk = (PlSqlToken)tk.getNextCodeToken();
                        while (!(tk.matches(")") || tk.matches("IS") || tk.matches("AS") || tk.matches("RETURN") || tk.matches(";"))) {
                            tk = (PlSqlToken)tk.getNextCodeToken();
                            while (tk.matches("IN") || tk.matches("OUT") || tk.matches("NOCOPY")) {
                                tk = (PlSqlToken)tk.getNextCodeToken();
                            }
                            while (!(tk.matches(")") || tk.matches("DEFAULT") || tk.matches(":=") || tk.matches(","))) {
                                retval = retval + tk.getSource();
                                tk = (PlSqlToken)tk.getNextCodeToken();
                            }
                            while (!tk.matches(")") && !tk.matches(",")) {
                                tk = (PlSqlToken)tk.getNextCodeToken();
                            }
                            retval = retval + tk.getSource() + " ";
                            if (tk.matches(")")) continue;
                            tk = (PlSqlToken)tk.getNextCodeToken();
                        }
                        tk = (PlSqlToken)tk.getNextCodeToken();
                    } else {
                        retval = retval + " ";
                    }
                    if (!tk.matches("RETURN")) break;
                    retval = retval + ": ";
                    tk = (PlSqlToken)tk.getNextCodeToken();
                    while (tk.isCode() && !tk.matches(";")) {
                        retval = retval + tk.getSource();
                        tk = (PlSqlToken)tk.getNextToken();
                    }
                    break;
                }
                catch (NullPointerException nullPointerException) {
                    break;
                }
            }
            case EX_WHEN: {
                PlSqlToken tk = (PlSqlToken)this.getFirstToken().getNextCodeToken();
                retval = retval + ": " + this.getSourceToWS(tk);
                break;
            }
            case LABEL: {
                retval = this.getSource();
                break;
            }
            case PLSQL_BLOCK: 
            case IF: 
            case ELSIF: 
            case ELSE: 
            case LOOP: 
            case FOR_LOOP: 
            case WHILE_LOOP: 
            case STATEMENT: 
            case PRAGMA: 
            case CASE: 
            case CASE_ELSE: 
            case CASE_WHEN: 
            case TYPE_ALTER_STATEMENT: {
                if (!forStructurePane) break;
                String suffix = "";
                int numOfThisType = 0;
                int posWithinType = 0;
                for (int j = 0; j < this.m_parent.getChildren().length; ++j) {
                    PlSqlFragment sibling = this.m_parent.getChildren()[j];
                    if (sibling.getFragmentType() == this.m_type) {
                        ++numOfThisType;
                    }
                    if (sibling != this) continue;
                    posWithinType = numOfThisType;
                }
                if (numOfThisType <= true) break;
                retval = retval + ": #" + String.valueOf(posWithinType);
            }
        }
        if (maxSize != null && maxSize < 3) {
            maxSize = 3;
        }
        if (maxSize != null && retval.length() > maxSize) {
            retval = retval.substring(0, maxSize - 3) + "...";
        }
        return retval;
    }

    private String getSourceToWS(PlSqlToken tk) {
        String retval = "";
        while (tk.isCode()) {
            retval = retval + tk.getSource();
            tk = (PlSqlToken)tk.getNextToken();
        }
        return retval;
    }

    public PlSqlFragment findChild(Type type, boolean deep) {
        if (this.getFragmentType() == type) {
            return this;
        }
        for (PlSqlFragment frag : this.getChildren()) {
            PlSqlFragment frag2;
            if (frag.getFragmentType() == type) {
                return frag;
            }
            if (!deep || (frag2 = frag.findChild(type, true)) == null) continue;
            return frag2;
        }
        return null;
    }

    final void replaceChildWithGrandChildren(PlSqlFragment child) {
        ArrayList<PlSqlFragment> grandkids = child.m_subFragments;
        this.m_subFragments.remove(child);
        this.m_subFragments.addAll(grandkids);
        for (PlSqlFragment grandChild : grandkids) {
            grandChild.m_parent = this;
        }
    }

    List<String> getLocalDeclarations() {
        ArrayList<String> ret = new ArrayList<String>();
        this.getLocalDeclarations(ret);
        return ret;
    }

    private void getLocalDeclarations(List<String> decls) {
        PlSqlFragment parent;
        if (this.getFragmentType() == Type.PLSQL_BLOCK) {
            for (PlSqlFragment child : this.m_subFragments) {
                if (child.getFragmentType() != Type.DECLARE) continue;
                for (PlSqlFragment f : child.getChildren()) {
                    if (f.getFragmentType() != Type.DECLARATION) continue;
                    decls.add(f.getFirstToken().getSource(true));
                }
            }
        } else if (this.getFragmentType() == Type.PACKAGE_SPEC || this.getFragmentType() == Type.PACKAGE_BODY || this.getFragmentType() == Type.TYPE_BODY) {
            for (PlSqlFragment child : this.m_subFragments) {
                if (child.getFragmentType() != Type.DECLARATION) continue;
                decls.add(child.getFirstToken().getSource(true));
            }
        }
        if ((parent = this.getParent()) != null) {
            parent.getLocalDeclarations(decls);
        }
    }

    public static enum AlterSubType {
        ADD_ATTRIBUTE,
        DROP_ATTRIBUTE,
        MODIFY_ATTRIBUTE,
        ADD_METHOD,
        DROP_METHOD;

    }

    public static enum Type {
        UNKNOWN,
        ROOT,
        LABEL,
        DECLARE,
        BEGIN,
        EXCEPTION,
        PACKAGE_SPEC,
        PACKAGE_BODY,
        PRAGMA,
        PROCEDURE,
        FUNCTION,
        TRIGGER,
        PLSQL_BLOCK,
        IF,
        ELSIF,
        ELSE,
        LOOP,
        FOR_LOOP,
        WHILE_LOOP,
        CASE,
        CASE_WHEN,
        CASE_ELSE,
        STATEMENT,
        DECLARATION,
        EX_WHEN,
        PARAMETER_LIST,
        PARAMETER,
        TRIGGER_TIMING,
        TRIGGER_EVENTS,
        TRIGGER_COLUMNS,
        TRIGGER_TABLE,
        TRIGGER_REFERENCING,
        TRIGGER_ROW_LEVEL,
        TRIGGER_WHEN,
        PROCEDURE_FD,
        FUNCTION_FD,
        TYPE_SPEC,
        TYPE_BODY,
        TYPE_ALTER_STATEMENT,
        CURSOR;

    }
}

