/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.util.Comparator;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.token.Token;

public class PlSqlComparator
implements Comparator<String> {
    private boolean m_ignoreComments = true;
    private boolean m_ignoreWhitespace = true;

    public PlSqlComparator() {
    }

    public PlSqlComparator(boolean ignoreComments, boolean ignoreWhitespace) {
        this.m_ignoreComments = ignoreComments;
        this.m_ignoreWhitespace = ignoreWhitespace;
    }

    @Override
    public int compare(String o1, String o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return 1;
        }
        if (o2 == null) {
            return -1;
        }
        PlSqlToken tk1 = PlSqlTokenizer.tokenize(o1, new String[0]);
        PlSqlToken tk2 = PlSqlTokenizer.tokenize(o2, new String[0]);
        while (true) {
            tk1 = this.getNextTokenToCompare(tk1);
            tk2 = this.getNextTokenToCompare(tk2);
            if (tk1.getType() != tk2.getType()) {
                return tk1.getType().toString().compareTo(tk2.getType().toString());
            }
            if (tk1.getType() == Token.Type.END_MARKER) break;
            boolean useFormatted = tk1.getType() == Token.Type.ALPHANUMERIC;
            int comp = tk1.getSource(useFormatted).compareTo(tk2.getSource(useFormatted));
            if (comp != 0) {
                return comp;
            }
            tk1 = (PlSqlToken)tk1.getNextToken();
            tk2 = (PlSqlToken)tk2.getNextToken();
        }
        return 0;
    }

    private PlSqlToken getNextTokenToCompare(PlSqlToken startTk) {
        PlSqlToken tk = startTk;
        while (tk.getType() != Token.Type.END_MARKER) {
            if (this.m_ignoreWhitespace && tk.getType() == Token.Type.WHITESPACE) {
                tk = (PlSqlToken)tk.getNextToken();
                continue;
            }
            if (!this.m_ignoreComments || tk.getType() != Token.Type.SINGLE_LINE_COMMENT && tk.getType() != Token.Type.MULTI_LINE_COMMENT) break;
            tk = (PlSqlToken)tk.getNextToken();
        }
        return tk;
    }
}

