/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text.converter;

import java.io.CharConversionException;
import java.io.IOException;
import java.sql.SQLException;
import oracle.i18n.text.converter.CharacterConverterLC;
import oracle.i18n.text.converter.GDKMessage;
import oracle.i18n.util.GDKOracleMetaData;

public class CharacterConverterLCFixed
extends CharacterConverterLC {
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();
    static final int ORACHARBYTECNT = 4;
    public int m_4ByteOraCharReplacement = 0;

    public CharacterConverterLCFixed() {
        this.m_groupId = 3;
        this.averageCharsPerByte = 0.25f;
        this.maxCharsPerByte = 1.0f;
        this.maxBytesPerChar = 4.0f;
    }

    int toOracleCharacter(char c, char c2) throws SQLException {
        int n = -1;
        if (c2 != '\u0000') {
            int n2 = c >>> 8 & 0xFF;
            int n3 = c & 0xFF;
            int n4 = c2 >>> 8 & 0xFF;
            int n5 = c2 & 0xFF;
            if (this.m_oraCharLevel1[n2] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] + n5] != -1) {
                n = this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] + n5];
            }
        } else {
            int n6 = c >>> 8 & 0xFF;
            int n7 = c & 0xFF;
            if (this.m_oraCharLevel1[n6] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharLevel1[n6] + n7] != -1) {
                n = this.m_oraCharLevel2[this.m_oraCharLevel1[n6] + n7];
            }
        }
        if (n == -1) {
            throw new SQLException(GDKMessage.getORAMessage(17155), null, 17155);
        }
        return n;
    }

    int toOracleCharacterWithReplacement(char c, char c2) {
        int n = -1;
        if (c2 != '\u0000') {
            int n2 = c >>> 8 & 0xFF;
            int n3 = c & 0xFF;
            int n4 = c2 >>> 8 & 0xFF;
            int n5 = c2 & 0xFF;
            if (this.m_oraCharLevel1[n2] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] + n5] != -1) {
                n = this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] + n5];
            }
        } else {
            int n6 = c >>> 8 & 0xFF;
            int n7 = c & 0xFF;
            if (this.m_oraCharLevel1[n6] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharLevel1[n6] + n7] != -1) {
                n = this.m_oraCharLevel2[this.m_oraCharLevel1[n6] + n7];
            }
        }
        if (n == -1) {
            return this.m_4ByteOraCharReplacement;
        }
        return n;
    }

    public String toUnicodeString(byte[] byArray, int n, int n2) throws SQLException {
        char[] cArray = new char[n2 * 2];
        int n3 = 0;
        if (n2 >= 4) {
            int n4 = byArray[n] << 8 & 0xFF00 | byArray[n + 1] & 0xFF;
            for (int i = 0; i < this.m_ucsCharLeadingCode.length; ++i) {
                if (n4 != this.m_ucsCharLeadingCode[i][0]) continue;
                char c = this.m_ucsCharLeadingCode[i][1];
                int n5 = byArray[n + 2] << 8 & 0xFF00 | byArray[n + 3] & 0xFF;
                int n6 = (n5 >> 8 & 0xFF) + c;
                int n7 = n5 & 0xFF;
                if (this.m_ucsCharLevel1[n6] == '\uffff' || this.m_ucsCharLevel2[this.m_ucsCharLevel1[n6] + n7] == -1) {
                    throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
                }
                int n8 = this.m_ucsCharLevel2[this.m_ucsCharLevel1[n6] + n7];
                if (((long)n8 & 0xFFFFFFFFL) > 65535L) {
                    cArray[n3++] = (char)(n8 >>> 16);
                    cArray[n3++] = (char)(n8 & 0xFFFF);
                } else {
                    cArray[n3++] = (char)n8;
                }
                n2 -= 4;
                n += 4;
                break;
            }
            throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
        }
        if (n2 != 0) {
            throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
        }
        return new String(cArray, 0, n3);
    }

    public String toUnicodeStringWithReplacement(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2 * 2];
        int n3 = 0;
        while (n2 >= 4) {
            int n4 = byArray[n] << 8 & 0xFF00 | byArray[n + 1] & 0xFF;
            int n5 = this.m_ucsCharReplacement;
            for (int i = 0; i < this.m_ucsCharLeadingCode.length; ++i) {
                if (n4 != this.m_ucsCharLeadingCode[i][0]) continue;
                char c = this.m_ucsCharLeadingCode[i][1];
                int n6 = byArray[n + 2] << 8 & 0xFF00 | byArray[n + 3] & 0xFF;
                int n7 = (n6 >> 8 & 0xFF) + c;
                int n8 = n6 & 0xFF;
                if (this.m_ucsCharLevel1[n7] != '\uffff' && this.m_ucsCharLevel2[this.m_ucsCharLevel1[n7] + n8] != -1) {
                    n5 = this.m_ucsCharLevel2[this.m_ucsCharLevel1[n7] + n8];
                    break;
                }
                n5 = this.m_ucsCharReplacement;
                break;
            }
            if (((long)n5 & 0xFFFFFFFFL) > 65535L) {
                cArray[n3++] = (char)(n5 >>> 16);
                cArray[n3++] = (char)(n5 & 0xFFFF);
            } else {
                cArray[n3++] = (char)n5;
            }
            n2 -= 4;
            n += 4;
        }
        return new String(cArray, 0, n3);
    }

    public int ByteToCharConvert(byte[] byArray, int n, int n2, char[] cArray, int n3, int n4) throws IOException, CharConversionException, IndexOutOfBoundsException {
        return 0;
    }

    public int CharToByteConvert(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) throws IOException, CharConversionException, IndexOutOfBoundsException {
        return 0;
    }

    public int toUnicodeCharsWithReplacement(byte[] byArray, int n, char[] cArray, int n2, int n3) {
        return 0;
    }
}

