/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.wiz.import_;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.controls.FocusableLabel;
import oracle.ide.net.URLFactory;
import oracle.ide.util.Assert;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.checktree.TriStateNode;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.ui.table.GenericTable;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdeveloper.vcs.util.VCSNodeIconUtils;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.control.CVSHintContainer;
import oracle.jdevimpl.vcs.cvs.login.CVSLogin;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcess;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcessStreamMonitor;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerFactory;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardException;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardPage;
import oracle.jdevimpl.vcs.cvs.wiz.import_.CVSImportCommitter;
import oracle.jdevimpl.vcs.cvs.wiz.import_.CVSImportModelKey;

public class CVSImportPreviewPage
extends CVSWizardPage
implements CVSImportModelKey {
    private static final String GUI_BUSY = "busy";
    private static final String GUI_PREVIEW = "preview";
    private static final String GUI_MESSAGE = "message";
    private static final String ROOT_PATH = "/";
    private CardLayout _cardLayout;
    private JPanel _cardLayoutPanel;
    private JPanel _panel;
    private JTree _tree;
    private GenericTable _reportTable;
    private Map _storedProperties = Collections.emptyMap();
    private boolean _busy;
    private ExecutorService _executor;
    private JButton _getPreviewButton;
    private JButton _viewFullReportButton;

    public CVSImportPreviewPage() {
        JPanel panel = new JPanel(new BorderLayout());
        JLabel busyLabel = new JLabel(CVSArb.get("LOADING"), OracleIcons.getIcon((String)"throbber.gif"), 0);
        busyLabel.setBackground(UIManager.getColor("window"));
        busyLabel.setForeground(UIManager.getColor("textText"));
        busyLabel.setBorder(UIManager.getBorder("ScrollPane.border"));
        busyLabel.setOpaque(true);
        FocusableLabel messageLabel = new FocusableLabel(CVSArb.get("IMPORT_PREVIEW_FETCH_HINT"));
        messageLabel.setBackground(UIManager.getColor("window"));
        messageLabel.setForeground(UIManager.getColor("textText"));
        messageLabel.setBorder(UIManager.getBorder("ScrollPane.border"));
        messageLabel.setOpaque(true);
        this._tree = new JTree(new DefaultTreeModel((TreeNode)((Object)new PreviewFileNode(new ImportOutputData(ROOT_PATH)))));
        this._tree.setShowsRootHandles(true);
        this._tree.setRootVisible(false);
        this._tree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Component c = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (value instanceof TriStateNode) {
                    TriStateNode node = (TriStateNode)value;
                    this.setText(node.getLabel());
                    this.setIcon(node.getIcon());
                } else {
                    this.setText("");
                    this.setIcon(null);
                }
                return c;
            }
        });
        this._cardLayout = new CardLayout();
        this._cardLayoutPanel = new JPanel(this._cardLayout);
        this._cardLayoutPanel.add((Component)busyLabel, GUI_BUSY);
        this._cardLayoutPanel.add((Component)new JScrollPane(this._tree), GUI_PREVIEW);
        this._cardLayoutPanel.add((Component)messageLabel, GUI_MESSAGE);
        this._cardLayout.show(this._cardLayoutPanel, GUI_MESSAGE);
        this._reportTable = new GenericTable(){

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this._reportTable.setSelectionMode(0);
        this.initializeReportTable();
        this._getPreviewButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this._getPreviewButton, (String)CVSArb.get("IMPORT_PREVIEW_GET_PREVIEW"));
        this._viewFullReportButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this._viewFullReportButton, (String)CVSArb.get("IMPORT_PREVIEW_VIEW_FULL_REPORT"));
        this._viewFullReportButton.setEnabled(false);
        JPanel northButtonBox = new JPanel(new BorderLayout());
        northButtonBox.add(Box.createHorizontalGlue(), "Center");
        northButtonBox.add((Component)this._getPreviewButton, "West");
        JPanel southButtonBox = new JPanel(new BorderLayout());
        southButtonBox.add(Box.createHorizontalGlue(), "Center");
        southButtonBox.add((Component)this._viewFullReportButton, "East");
        JLabel previewLabel = new JLabel("");
        ResourceUtils.resLabel((JLabel)previewLabel, (Component)this._tree, (String)CVSArb.get("IMPORT_PREVIEW_TREE_LABEL"));
        Box northBox = Box.createVerticalBox();
        Box southBox = Box.createVerticalBox();
        northBox.add(northButtonBox);
        northBox.add(Box.createVerticalStrut(4));
        northBox.add(previewLabel);
        northBox.add(Box.createVerticalStrut(4));
        southBox.add(Box.createVerticalStrut(4));
        southBox.add(southButtonBox);
        JLabel reportLabel = new JLabel();
        reportLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        ResourceUtils.resLabel((JLabel)reportLabel, (Component)this._reportTable, (String)CVSArb.get("IMPORT_PREVIEW_TABLE_LABEL"));
        final Box reportPanel = Box.createVerticalBox();
        reportPanel.add(reportLabel);
        reportPanel.add(Box.createVerticalStrut(4));
        JScrollPane reportScrollPane = new JScrollPane((Component)this._reportTable);
        reportPanel.add(reportScrollPane);
        panel.add((Component)northBox, "North");
        panel.add((Component)this._cardLayoutPanel, "Center");
        panel.add((Component)southBox, "South");
        this.setAlignmentXRecursively(panel);
        this.setAlignmentXRecursively(reportPanel);
        this._getPreviewButton.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent ae) {
                CVSImportPreviewPage.this.refresh(CVSImportPreviewPage.this._storedProperties);
            }
        });
        this._viewFullReportButton.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent ae) {
                Window window = SwingUtilities.getWindowAncestor((Component)CVSImportPreviewPage.this.getWizard());
                JEWTDialog dialog = null;
                if (window instanceof Frame) {
                    dialog = new JEWTDialog((Frame)window);
                }
                if (window instanceof Dialog) {
                    dialog = new JEWTDialog((Dialog)window);
                }
                assert (dialog != null);
                dialog.setContent((Component)reportPanel);
                dialog.setButtonMask(16);
                dialog.setLocation(window.getLocation());
                Dimension size = window.getSize();
                dialog.setPreferredSize((int)((double)size.width * 0.75), (int)((double)size.height * 0.75));
                dialog.setTitle(CVSArb.get("IMPORT_PREVIEW_VIEW_FULL_REPORT_TITLE"));
                dialog.setResizable(true);
                dialog.runDialog();
            }
        });
        String hint = CVSArb.get("IMPORT_PREVIEW_PAGE_HINT");
        this._panel = new CVSHintContainer(hint, panel);
    }

    private final void setAlignmentXRecursively(Component c) {
        if (c instanceof JComponent) {
            ((JComponent)c).setAlignmentX(0.0f);
            for (Component child : ((JComponent)c).getComponents()) {
                this.setAlignmentXRecursively(child);
            }
        }
    }

    private final void initializeReportTable() {
        this._reportTable.setModel((TableModel)((Object)new ReportTableModel()));
        this._reportTable.getTableHeader().setReorderingAllowed(false);
        this._reportTable.setAutoResizeMode(3);
        this._reportTable.autoSizeColumnsToFit(new Object[]{"DummyStatus", "this/is/a/reasonably/long/pathname/for/display/in/the/preview.txt"});
    }

    private final boolean isDirectoryPath(String path) {
        return path.endsWith(ROOT_PATH);
    }

    private final String getParent(String path) {
        path = this.isDirectoryPath(path) ? path.substring(0, path.length() - 1) : path;
        int i = path.lastIndexOf(47);
        return i >= 0 ? path.substring(0, i + 1) : null;
    }

    private final String getFileName(String path) {
        path = this.isDirectoryPath(path) ? path.substring(0, path.length() - 1) : path;
        int i = path.lastIndexOf(47);
        return i >= 0 ? path.substring(i + 1) : path;
    }

    private final void refresh(Map props) {
        final HashMap final_props = new HashMap(props);
        if (this._executor == null) {
            this._executor = Executors.newSingleThreadExecutor();
        }
        CVSClient.getInstance().verifyClientState();
        CVSRootString root = new CVSRootString(CVSImportCommitter.getConnectionRoot(final_props.get(KEY_IMPORT_CONNECTION_NAME).toString()));
        if (!CVSLogin.getMethod(root).isLoggedIn(root)) {
            try {
                CVSLogin.getMethod(root).doLogin(root, (Component)this.getWizard(), null, null);
            }
            catch (VCSException vcse) {
                new VCSExceptionHandler().handleException((Exception)((Object)vcse));
            }
            if (!CVSLogin.getMethod(root).isLoggedIn(root)) {
                return;
            }
        }
        this.setBusy(true);
        this.initializeReportTable();
        SwingWorker<PreviewFileNode, ImportOutputData> refreshWorker = new SwingWorker<PreviewFileNode, ImportOutputData>(){

            @Override
            protected final PreviewFileNode doInBackground() throws Exception {
                final ArrayList outputDataList = new ArrayList();
                Collection<String> options = CVSImportCommitter.createRunnerOptions(final_props, false);
                CVSRunner runner = null;
                URL dirUrl = URLFactory.newDirURL((URL)URLFactory.newFileURL((String)final_props.get(CVSImportModelKey.KEY_IMPORT_SOURCES).toString()), (String)"");
                runner = CVSRunnerFactory.getInstance().createRunner();
                runner.getParameters().setRoot(CVSImportCommitter.getConnectionRoot(final_props.get(CVSImportModelKey.KEY_IMPORT_CONNECTION_NAME).toString()));
                runner.setCmdArray_(new String[]{"-n", "import"});
                runner.getParameters().setOptions(options);
                runner.setDirURL_(dirUrl);
                runner.getParameters().setQuiet(true);
                runner.addOutputMonitor(new CVSProcessStreamMonitor(){
                    private final Pattern _pattern = Pattern.compile("([UNCIL]) .+?/(.+)");

                    @Override
                    protected void streamLine(String line, CVSProcess process) throws Exception {
                        Matcher matcher = this._pattern.matcher(line = line.replace('\\', '/'));
                        if (!matcher.matches()) {
                            return;
                        }
                        String status = matcher.group(1);
                        ImportOutputData outputData = new ImportOutputData(matcher.group(2));
                        if (status.equals("U")) {
                            outputData._status = ImportStatus.UPDATED;
                        }
                        if (status.equals("N")) {
                            outputData._status = ImportStatus.NEW;
                        }
                        if (status.equals("C")) {
                            outputData._status = ImportStatus.CONFLICTS;
                        }
                        if (status.equals("I")) {
                            outputData._status = ImportStatus.IGNORED;
                        }
                        if (status.equals("L")) {
                            outputData._status = ImportStatus.LINK;
                        }
                        this.publish(new ImportOutputData[]{outputData});
                        outputDataList.add(outputData);
                    }
                });
                runner.exec_();
                Iterator itr = outputDataList.iterator();
                while (itr.hasNext()) {
                    if (!this.isIgnoredStatus(((ImportOutputData)itr.next())._status)) continue;
                    itr.remove();
                }
                HashMap<String, PreviewFileNode> nodesByPath = new HashMap<String, PreviewFileNode>();
                block1: for (ImportOutputData outputData : outputDataList) {
                    PreviewFileNode currentNode = new PreviewFileNode(outputData);
                    nodesByPath.put(outputData._path, new PreviewFileNode(outputData));
                    String parentPath = CVSImportPreviewPage.this.getParent(outputData._path);
                    while (parentPath != null) {
                        PreviewFileNode parentNode = (PreviewFileNode)nodesByPath.get(parentPath);
                        if (parentNode != null) {
                            parentNode.add((MutableTreeNode)((Object)currentNode));
                            continue block1;
                        }
                        parentNode = new PreviewFileNode(new ImportOutputData(parentPath));
                        nodesByPath.put(parentPath, parentNode);
                        parentNode.add((MutableTreeNode)((Object)currentNode));
                        parentPath = CVSImportPreviewPage.this.getParent(parentPath);
                        currentNode = parentNode;
                    }
                }
                PreviewFileNode rootNode = new PreviewFileNode(new ImportOutputData(CVSImportPreviewPage.ROOT_PATH));
                for (PreviewFileNode node : nodesByPath.values()) {
                    if (CVSImportPreviewPage.this.getParent(node.getFilePath()) != null) continue;
                    rootNode.add((MutableTreeNode)((Object)node));
                }
                rootNode.sort();
                rootNode.setNodeState(TriStateNode.NodeState.YES);
                return rootNode;
            }

            private final boolean isIgnoredStatus(ImportStatus status) {
                return status == ImportStatus.CONFLICTS || status == ImportStatus.IGNORED || status == ImportStatus.LINK;
            }

            @Override
            protected final void process(List<ImportOutputData> dataList) {
                for (ImportOutputData data : dataList) {
                    String status = "";
                    if (data._status == ImportStatus.CONFLICTS) {
                        status = CVSArb.get("IMPORT_PREVIEW_CHANGED");
                    }
                    if (data._status == ImportStatus.IGNORED) {
                        status = CVSArb.get("IMPORT_PREVIEW_IGNORED");
                    }
                    if (data._status == ImportStatus.LINK) {
                        status = CVSArb.get("IMPORT_PREVIEW_LINK");
                    }
                    if (data._status == ImportStatus.NEW) {
                        status = CVSArb.get("IMPORT_PREVIEW_NEW");
                    }
                    if (data._status == ImportStatus.UPDATED) {
                        status = CVSArb.get("IMPORT_PREVIEW_UPDATED");
                    }
                    ((DefaultTableModel)CVSImportPreviewPage.this._reportTable.getModel()).addRow(new String[]{status, data._path});
                }
            }

            @Override
            protected final void done() {
                try {
                    PreviewFileNode rootNode = (PreviewFileNode)this.get();
                    CVSImportPreviewPage.this._tree.setModel(new DefaultTreeModel((TreeNode)((Object)rootNode)));
                    this.expandAll(CVSImportPreviewPage.this._tree, true);
                }
                catch (Exception e) {
                    Assert.printStackTrace((Throwable)e);
                    CVSImportPreviewPage.this._tree.setModel(new DefaultTreeModel((TreeNode)((Object)new PreviewFileNode(new ImportOutputData(CVSImportPreviewPage.ROOT_PATH)))));
                }
                finally {
                    CVSImportPreviewPage.this.setBusy(false);
                }
            }

            private void expandAll(JTree tree, boolean expand) {
                TreeNode root = (TreeNode)tree.getModel().getRoot();
                this.expandAll(tree, new TreePath(root), expand);
            }

            private void expandAll(JTree tree, TreePath parent, boolean expand) {
                TreeNode node = (TreeNode)parent.getLastPathComponent();
                if (node.getChildCount() >= 0) {
                    Enumeration<? extends TreeNode> e = node.children();
                    while (e.hasMoreElements()) {
                        TreeNode n = e.nextElement();
                        TreePath path = parent.pathByAddingChild(n);
                        this.expandAll(tree, path, expand);
                    }
                }
                if (expand) {
                    tree.expandPath(parent);
                } else {
                    tree.collapsePath(parent);
                }
            }
        };
        this._executor.submit(refreshWorker);
    }

    private final Map createStoredProperties(Map props) {
        HashMap copyProps = new HashMap(props);
        copyProps.remove(KEY_IMPORT_USE_TIMESTAMP);
        copyProps.remove(KEY_IMPORT_DO_CHECKOUT);
        copyProps.remove(KEY_IMPORT_COMMENTS);
        copyProps.remove(KEY_IMPORT_VENDOR_TAG);
        copyProps.remove(KEY_IMPORT_RELEASE_TAG);
        return copyProps;
    }

    private final void setBusy(boolean busy) {
        this.getWizardPage().setCanAdvance(!busy);
        this.getWizardPage().setCanGoBack(!busy);
        this.getWizard().setAllLinksEnabled(!busy);
        if (busy) {
            this.getWizard().disable();
        } else {
            this.getWizard().enable();
        }
        this._getPreviewButton.setEnabled(!busy);
        this._viewFullReportButton.setEnabled(!busy);
        this._cardLayout.show(this._cardLayoutPanel, busy ? GUI_BUSY : GUI_PREVIEW);
        this._busy = busy;
    }

    @Override
    public final String getAccessibleDescription() {
        return CVSArb.get("IMPORT_PREVIEW_PAGE_HINT");
    }

    @Override
    public final Component getFocusComponent() {
        return this._reportTable;
    }

    @Override
    public final String getHelpTopic() {
        return null;
    }

    @Override
    public final JComponent getPanel() {
        return this._panel;
    }

    @Override
    public final String getLabel() {
        return CVSArb.get("IMPORT_PREVIEW_PAGE_LABEL");
    }

    @Override
    public final Object[] getPropertyKeys() {
        return new Object[0];
    }

    @Override
    public final void populatePage(Map props) {
        this._storedProperties = props;
    }

    @Override
    public final void validatePage() throws CVSWizardException {
    }

    @Override
    public final void applyPage(Map props) {
    }

    private class PreviewFileNode
    extends TriStateNode
    implements Comparable {
        PreviewFileNode(ImportOutputData data) {
            super((Object)data);
        }

        private final String getFilePath() {
            return ((ImportOutputData)this.getUserObject())._path;
        }

        private final ImportStatus getFileStatus() {
            return ((ImportOutputData)this.getUserObject())._status;
        }

        public final Icon getIcon() {
            if (this.isDirectory()) {
                return OracleIcons.getIcon((String)"folder.png");
            }
            return VCSNodeIconUtils.getIconForSuffix((String)this.getFileSuffix());
        }

        private final String getFileSuffix() {
            String path = this.getFilePath();
            int lastDot = path.lastIndexOf(46);
            int lastSlash = path.lastIndexOf(47);
            return lastDot >= 0 && lastDot > lastSlash ? path.substring(lastDot) : "";
        }

        public final String getLabel() {
            return CVSImportPreviewPage.this.getFileName(this.getFilePath());
        }

        private final boolean isDirectory() {
            return CVSImportPreviewPage.this.isDirectoryPath(this.getFilePath());
        }

        public final int compareTo(Object o) {
            PreviewFileNode otherFileNode = (PreviewFileNode)o;
            if (this.isDirectory() && !otherFileNode.isDirectory()) {
                return -1;
            }
            if (!this.isDirectory() && otherFileNode.isDirectory()) {
                return 1;
            }
            return this.getFilePath().compareTo(otherFileNode.getFilePath());
        }
    }

    private static enum ImportStatus {
        UPDATED,
        NEW,
        CONFLICTS,
        IGNORED,
        LINK;

    }

    private class ImportOutputData {
        private final String _path;
        private ImportStatus _status;

        ImportOutputData(String path) {
            this._path = path;
        }
    }

    private class ReportTableModel
    extends GenericBaseTableModel {
        private ReportTableModel() {
            this.addColumn(CVSArb.get("IMPORT_PREVIEW_STATUS"));
            this.addColumn(CVSArb.get("IMPORT_PREVIEW_FILE"));
        }

        public int getColumnAlignment(int column) {
            return 2;
        }

        public Comparator getColumnSortComparator(int column) {
            return Collator.getInstance();
        }
    }
}

