/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.wiz.import_;

import java.awt.Component;
import java.awt.Container;
import java.net.URL;
import java.util.Map;
import javax.swing.JComponent;
import oracle.ide.Context;
import oracle.ide.model.Locatable;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSResourcePicker;
import oracle.jdevimpl.vcs.cvs.control.CVSHintContainer;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListAPI;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodes;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.ui.CVSImportModulePageUI;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardException;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardPage;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardValidationException;
import oracle.jdevimpl.vcs.cvs.wiz.import_.CVSImportModelKey;
import oracle.jdevimpl.vcs.cvs.wiz.shared.CVSAbstractModulePage;

public final class CVSImportModulePage
extends CVSWizardPage
implements CVSImportModelKey {
    private JComponent _panel = null;
    private CVSImportModulePageUI _ui = new CVSImportModulePageUI();

    CVSImportModulePage() {
        this.createPanel();
    }

    protected void createPanel() {
        CVSResourcePicker.getPicker(this.getClass()).start((Container)this._ui);
        String hint = CVSArb.get("IMPORT_MODULE_PAGE_HINT");
        this._panel = new CVSHintContainer(hint, this._ui);
        CVSAbstractModulePage.Util.initializeConnectionComboBox(this._ui.getConnectionNameCombo());
    }

    @Override
    public String getAccessibleDescription() {
        return CVSArb.get("IMPORT_MODULE_PAGE_HINT");
    }

    @Override
    public Component getFocusComponent() {
        return this._ui.getConnectionNameCombo();
    }

    @Override
    public String getHelpTopic() {
        return "f1_cvsimpwmodule_html";
    }

    @Override
    public JComponent getPanel() {
        return this._panel;
    }

    @Override
    public String getLabel() {
        return CVSArb.get("IMPORT_MODULE_PAGE_LABEL");
    }

    @Override
    public Object[] getPropertyKeys() {
        return new Object[]{KEY_IMPORT_CONNECTION_NAME, KEY_IMPORT_MODULE_NAME, KEY_IMPORT_COMMENTS};
    }

    @Override
    public void populatePage(Map props) {
        Object value = props.get(KEY_IMPORT_CONNECTION_NAME);
        CVSConnectionListAPI list = CVSConnectionNodes.getConnectionListAPI();
        if (value != null && list != null && ((CVSConnectionListData)list).hasConnection(value.toString())) {
            CVSAbstractModulePage.Util.setComboItem(this._ui.getConnectionNameCombo(), value);
        }
        if ((value = props.get(KEY_IMPORT_COMMENTS)) != null) {
            this._ui.getCommentsField().setText(value.toString());
        }
        if ((value = props.get(KEY_IMPORT_MODULE_NAME)) == null || value.equals("")) {
            this.initModuleItemFromContext();
        } else {
            this._ui.getModuleField().setText((String)value);
        }
    }

    @Override
    public void validatePage() throws CVSWizardException {
        String o = this._ui.getModuleField().getText();
        if (o == null || !CVSAbstractModulePage.Util.isValidModuleName(o.toString())) {
            throw new CVSWizardValidationException(CVSArb.get("IMPORT_MODULE_PAGE_ERROR_1"));
        }
    }

    @Override
    public void applyPage(Map props) {
        props.put(KEY_IMPORT_CONNECTION_NAME, this._ui.getConnectionNameCombo().getSelectedItem());
        props.put(KEY_IMPORT_MODULE_NAME, this._ui.getModuleField().getText());
        props.put(KEY_IMPORT_COMMENTS, this._ui.getCommentsField().getText());
    }

    private void initModuleItemFromContext() {
        Context context = this.getContext();
        if (context == null) {
            return;
        }
        Locatable[] selection = VCSContextUtils.getContextLocatables((Context)context, (URLFilter)CVSClient.getInstance().getURLFilter());
        Locatable node = null;
        for (int i = 0; i < selection.length; ++i) {
            if (!(selection[i] instanceof Project) && !(selection[i] instanceof Workspace)) continue;
            node = selection[i];
            break;
        }
        if (node == null) {
            return;
        }
        String moduleName = URLFileSystem.getFileName((URL)((Locatable)node).getURL());
        int i = moduleName.lastIndexOf(46);
        this._ui.getModuleField().setText(i < 0 ? moduleName : moduleName.substring(0, i));
    }
}

