/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.wiz.connect;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import oracle.ide.util.Assert;
import oracle.jdeveloper.vcs.spi.VCSDetailException;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdevimpl.vcs.cvs.CVSActiveClient;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSRootContext;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionDetailsKey;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcess;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcessStreamMonitor;
import oracle.jdevimpl.vcs.cvs.wiz.connect.CVSConnectModelKey;
import oracle.jdevimpl.vcs.cvs.wiz.connect.CVSConnectRoot;
import oracle.jdevimpl.vcs.cvs.wiz.connect.CVSConnectTestListener;

class CVSConnectTester
implements CVSConnectModelKey {
    private static final Collection _ignorablePrefixes = CVSConnectTester.createIgnorablePrefixes();
    private Writer _writer = null;
    private CVSConnectTestListener _listener = null;
    private Component _component = null;
    private TesterThread _thread = null;

    CVSConnectTester() {
    }

    synchronized void initializeWriter(Writer writer) {
        this._writer = writer;
    }

    synchronized void initializeListener(CVSConnectTestListener listener) {
        this._listener = listener;
    }

    synchronized void initializeComponent(Component component) {
        this._component = component;
    }

    final synchronized void performTest(Map props) {
        if (this._thread != null) {
            return;
        }
        this._listener.testCommenced();
        CVSClient client = CVSClient.getInstance();
        client.verifyClientState();
        if (!client.isClientAvailable()) {
            new TesterResultsWriter(this._writer).writeln(CVSArb.get("CONNECT_TEST_OUTPUT_NO_CVS"));
            this.getListener().testTerminated();
            return;
        }
        this.setThread(new TesterThread(props){

            @Override
            protected final void testFinished() {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CVSConnectTester.this.getListener().testTerminated();
                    }
                });
                CVSConnectTester.this.setThread(null);
            }
        });
        this._thread.start();
    }

    final synchronized void destroyThread() {
        if (this._thread != null) {
            this._thread.kill();
        }
    }

    synchronized Writer getWriter() {
        return this._writer;
    }

    synchronized CVSConnectTestListener getListener() {
        return this._listener;
    }

    synchronized Component getComponent() {
        return this._component;
    }

    synchronized TesterThread getThread() {
        return this._thread;
    }

    private synchronized void setThread(TesterThread thread) {
        this._thread = thread;
    }

    private static final Collection createIgnorablePrefixes() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("cvs rtag:");
        c.add("cvs [rtag aborted]:");
        c.add("cvs [server aborted]:");
        return c;
    }

    private static final String formatOutputLine(String line) {
        if (line == null) {
            return null;
        }
        Iterator itr = _ignorablePrefixes.iterator();
        while (itr.hasNext()) {
            String prefix = itr.next().toString();
            int n = prefix.length();
            if (!line.startsWith(prefix) || line.length() <= n) continue;
            line = line.substring(n);
        }
        return (line = line.replaceAll("JSch", "SSH2")).equals("") ? null : line;
    }

    static /* synthetic */ Writer access$300(CVSConnectTester x0) {
        return x0._writer;
    }

    private final class TesterErrorMonitor
    extends CVSProcessStreamMonitor {
        private final TesterResultsWriter _resultsWriter;

        TesterErrorMonitor(TesterResultsWriter resultsWriter) {
            this._resultsWriter = resultsWriter;
        }

        @Override
        public void streamLine(String line, CVSProcess process) {
            Boolean success = CVSConnectTester.this.getThread().getSuccess();
            if (success == null && line.indexOf("authorization failed:") >= 0) {
                CVSConnectTester.this.getThread().setSuccess(Boolean.FALSE);
                return;
            }
            if (success == null && line.indexOf("cannot find module") >= 0) {
                CVSConnectTester.this.getThread().setSuccess(Boolean.TRUE);
                return;
            }
            if (success == null && line.indexOf("\"rtag\" requires write access to the repository") >= 0) {
                CVSConnectTester.this.getThread().setSuccess(Boolean.TRUE);
                return;
            }
            if (CVSClient.getInstance().isUsingInternalClient() && line.indexOf("exiting, server error") >= 0) {
                return;
            }
            if ((line = CVSConnectTester.formatOutputLine(line)) == null) {
                return;
            }
            this._resultsWriter.writeln(line);
        }
    }

    private final class TesterOutputMonitor
    extends CVSProcessStreamMonitor {
        private final TesterResultsWriter _resultsWriter;

        TesterOutputMonitor(TesterResultsWriter resultsWriter) {
            this._resultsWriter = resultsWriter;
        }

        @Override
        public void streamLine(String line, CVSProcess process) {
            if ((line = CVSConnectTester.formatOutputLine(line)) == null) {
                return;
            }
            this._resultsWriter.writeln(line);
        }
    }

    private class TesterExceptionHandler
    extends VCSExceptionHandler {
        private final TesterResultsWriter _resultsWriter;

        TesterExceptionHandler(TesterResultsWriter resultsWriter) {
            this._resultsWriter = resultsWriter;
        }

        protected void handleExceptionImpl(Exception e, Component parent) {
            this.reportException(e);
            super.handleExceptionImpl(e, parent);
        }

        void reportException(Exception e) {
            if (e instanceof RuntimeException) {
                Assert.printStackTrace((Throwable)e);
                return;
            }
            if (e instanceof VCSException) {
                String detail;
                this._resultsWriter.writeln(e.getMessage());
                String string = detail = e instanceof VCSDetailException ? ((VCSDetailException)e).getDetail() : null;
                if (detail != null) {
                    this._resultsWriter.writeln(detail);
                }
            } else {
                this._resultsWriter.writeln(CVSConnectTester.formatOutputLine(e.getMessage()));
            }
        }
    }

    private abstract class TesterThread
    extends Thread {
        private final int TIMEOUT_DURATION = 10000;
        private final Map _props;
        private final CVSRootContext _context;
        private Boolean _success = null;
        private CVSProcess _process = null;
        private boolean _killed = false;

        private TesterThread(Map props) {
            String root = (String)props.get(CVSConnectionDetailsKey.KEY_CONNECTION_ROOT);
            if (CVSActiveClient.isClientCVSNT()) {
                root = CVSConnectRoot.canonicalizeCVSNTRoot(root);
            }
            this._context = new CVSRootContext(root, (String)props.get(CVSConnectionDetailsKey.KEY_CONNECTION_CVS_RSH), (String)props.get(CVSConnectionDetailsKey.KEY_CONNECTION_CVS_SERVER));
            this._props = props;
        }

        /*
         * Exception decompiling
         */
        @Override
        public final void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private final synchronized void setProcess(CVSProcess process) {
            this._process = process;
        }

        private final synchronized CVSProcess getProcess() {
            return this._process;
        }

        private final synchronized void setSuccess(Boolean success) {
            this._success = success;
        }

        private final synchronized Boolean getSuccess() {
            return this._success;
        }

        private final synchronized void kill() {
            if (this._process != null) {
                Runnable r = new Runnable(){

                    @Override
                    public final void run() {
                        CVSProcess process = TesterThread.this._process;
                        if (process != null && process.getProcess() != null) {
                            process.getProcess().destroy();
                        }
                    }
                };
                new Thread(r, "CVSConnectTester").start();
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException ie) {
                    Assert.printStackTrace((Throwable)ie);
                }
            }
            this._killed = true;
        }

        private final synchronized boolean isKilled() {
            return this._killed;
        }

        protected abstract void testFinished();
    }

    private class TesterResultsWriter {
        private final BufferedWriter _bufferedWriter;
        private boolean _lineWritten;

        TesterResultsWriter(Writer writer) {
            this._bufferedWriter = new BufferedWriter(writer);
        }

        void writeln(String line) {
            this.writeln(line, false);
        }

        synchronized void writeln(String line, boolean append) {
            try {
                if (this._lineWritten && !append) {
                    this._bufferedWriter.newLine();
                } else {
                    this._lineWritten = true;
                }
                if (append) {
                    this._bufferedWriter.write(32);
                }
                this._bufferedWriter.write(line);
                this._bufferedWriter.flush();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

