/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.wiz.connect;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.ide.ProductInformation;
import oracle.jdevimpl.vcs.cvs.CVSResourcePicker;
import oracle.jdevimpl.vcs.cvs.control.CVSHintContainer;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.ui.CVSConnectTestPageUI;
import oracle.jdevimpl.vcs.cvs.wiz.connect.CVSConnectModelKey;
import oracle.jdevimpl.vcs.cvs.wiz.connect.CVSConnectTestListener;
import oracle.jdevimpl.vcs.cvs.wiz.connect.CVSConnectTester;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardException;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardPage;

public class CVSConnectTestPage
extends CVSWizardPage
implements CVSConnectModelKey {
    private final CVSConnectTester _tester;
    private Map _props = null;
    private JComponent _panel = null;
    private CVSConnectTestPageUI _ui = new CVSConnectTestPageUI();

    CVSConnectTestPage(CVSConnectTester tester) {
        this._tester = tester;
        this._tester.initializeWriter(new Writer(){

            @Override
            public void close() {
            }

            @Override
            public void flush() {
            }

            @Override
            public void write(final char[] cbuf, final int off, final int len) {
                if (len <= 0) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CVSConnectTestPage.this._ui.getStatusArea().append(new String(cbuf, off, len));
                    }
                });
            }
        });
        this._tester.initializeListener(new CVSConnectTestListener(){

            @Override
            public void testCommenced() {
                CVSConnectTestPage.this._ui.getStatusArea().setText("");
                CVSConnectTestPage.this._ui.getTestConnectionButton().setEnabled(false);
            }

            @Override
            public void testTerminated() {
                CVSConnectTestPage.this._ui.getTestConnectionButton().setEnabled(true);
            }
        });
        this._tester.initializeComponent(this._ui);
        this.createPanel();
    }

    private void createPanel() {
        CVSResourcePicker.getPicker(this.getClass()).start((Container)this._ui);
        this._ui.getStatusLabel().setLabelFor(this._ui.getStatusArea());
        this._ui.getStatusArea().setEditable(false);
        this._ui.getStatusArea().setLineWrap(true);
        this._ui.getStatusArea().setWrapStyleWord(true);
        this._ui.getTestConnectionButton().addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                if (CVSConnectTestPage.this.getProperties() == null) {
                    return;
                }
                CVSConnectTestPage.this.getTester().performTest(CVSConnectTestPage.this.getProperties());
            }
        });
        String hint = CVSArb.format("CONNECT_TEST_PAGE_HINT", ProductInformation.getProductInformation().getShortName());
        this._panel = new CVSHintContainer(hint, this._ui);
    }

    @Override
    public String getAccessibleDescription() {
        return CVSArb.format("CONNECT_TEST_PAGE_HINT", ProductInformation.getProductInformation().getShortName());
    }

    @Override
    public String getHelpTopic() {
        return "f1_cvsconwtest_html";
    }

    @Override
    public JComponent getPanel() {
        return this._panel;
    }

    @Override
    public Component getFocusComponent() {
        return this._ui.getTestConnectionButton();
    }

    @Override
    public String getLabel() {
        return CVSArb.get("CONNECT_TEST_PAGE_LABEL");
    }

    @Override
    public Object[] getPropertyKeys() {
        return new Object[]{CVSConnectModelKey.KEY_CONNECTION_AUTO_CONNECT};
    }

    @Override
    public void populatePage(Map props) {
        this._props = new HashMap(props);
        this._ui.getTestConnectionButton().requestFocus();
    }

    @Override
    public void validatePage() throws CVSWizardException {
    }

    @Override
    public void applyPage(Map props) {
        boolean autoConnect = false;
        if (this.getProperties() != null) {
            Object value = this.getProperties().get(CVSConnectModelKey.KEY_CONNECTION_AUTO_CONNECT);
            autoConnect = value != null && (Boolean)value != false;
        }
        props.put(CVSConnectModelKey.KEY_CONNECTION_AUTO_CONNECT, new Boolean(autoConnect));
    }

    private final CVSConnectTester getTester() {
        return this._tester;
    }

    private final Map getProperties() {
        return this._props;
    }
}

