/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.wiz.connect;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import oracle.jdevimpl.vcs.cvs.CVSResourcePicker;
import oracle.jdevimpl.vcs.cvs.client.CVSMethodSpecifier;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.control.CVSHintContainer;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.ui.CVSConnectRootPageUI;
import oracle.jdevimpl.vcs.cvs.wiz.connect.CVSConnectAccessMethod;
import oracle.jdevimpl.vcs.cvs.wiz.connect.CVSConnectConnectionPage;
import oracle.jdevimpl.vcs.cvs.wiz.connect.CVSConnectModelKey;
import oracle.jdevimpl.vcs.cvs.wiz.connect.CVSConnectNameObservable;
import oracle.jdevimpl.vcs.cvs.wiz.connect.CVSConnectNamePage;
import oracle.jdevimpl.vcs.cvs.wiz.connect.CVSConnectRootObservable;
import oracle.jdevimpl.vcs.cvs.wiz.connect.CVSConnectRshDialog;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardException;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardPage;

public class CVSConnectRootPage
extends CVSWizardPage
implements CVSConnectModelKey,
Observer {
    private JComponent _panel = null;
    private final CVSConnectRootPageUI _ui = new CVSConnectRootPageUI();
    private final CVSConnectRshDialog _rshDialog = new CVSConnectRshDialog();
    private final Observable _rootobs;
    private CVSConnectNameObservable _nameobs;

    CVSConnectRootPage(CVSConnectNameObservable nameobs, Observable rootobs) {
        this._nameobs = nameobs;
        this._rootobs = rootobs;
        this._rootobs.addObserver(this);
        this.createPanel();
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg == null) {
            this._ui.getCVSRootField().setText("");
            return;
        }
        CVSRootString rootstr = (CVSRootString)arg;
        this._ui.getCVSRootField().setText(rootstr.toString());
        CVSConnectConnectionPage.updateUseProxySettingsCheckBox(rootstr.getRootSpecifier().getMethodSpecifier(), this._ui.getRshPanel());
    }

    private void createPanel() {
        CVSResourcePicker.getPicker(this.getClass()).start((Container)this._ui);
        this._ui.getCVSRootLabel().setLabelFor(this._ui.getCVSRootField());
        this._ui.getCVSRootField().requestFocus();
        this._ui.getCVSRootField().getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            protected void documentUpdate(DocumentEvent e) {
                try {
                    CVSConnectConnectionPage.updateUseProxySettingsCheckBox(new CVSRootString(e.getDocument().getText(0, e.getDocument().getLength())).getRootSpecifier().getMethodSpecifier(), CVSConnectRootPage.this._ui.getRshPanel());
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
            }
        });
        this._ui.getRshPanel().getRshConfigButton().addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                CVSConnectRootPage.this._rshDialog.showDialog(CVSConnectRootPage.this._panel);
            }
        });
        this._ui.getRshPanel().getUseProxySettingsCheckBox().addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent ae) {
                CVSRootString rootstr = new CVSRootString(CVSConnectRootPage.this._ui.getCVSRootField().getText().trim());
                if (!rootstr.hasKnownAccess()) {
                    return;
                }
                CVSMethodSpecifier method = rootstr.getRootSpecifier().getMethodSpecifier();
                method = CVSConnectRootPage.this._ui.getRshPanel().getUseProxySettingsCheckBox().isSelected() ? CVSConnectConnectionPage.addProxySettingsToMethod(method) : CVSConnectConnectionPage.removeProxySettingsFromMethod(method);
                rootstr = new CVSRootString(method, rootstr.getUserName(), rootstr.getPassword(), rootstr.getServerLocation(), rootstr.getPort(), rootstr.getUsePortColon(), rootstr.getRepository());
                CVSConnectRootPage.this._ui.getCVSRootField().setText(rootstr.toString());
            }
        });
        this._ui.getCVSRootField().getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            protected void documentUpdate(DocumentEvent e) {
                CVSConnectRootPage.this.updateEnabledState();
            }
        });
        this._ui.getRshPanel().getUseProxySettingsCheckBox().setVisible(false);
        String hint = CVSArb.get("CONNECT_ROOT_PAGE_HINT");
        this._panel = new CVSHintContainer(hint, this._ui);
    }

    @Override
    public String getAccessibleDescription() {
        return CVSArb.get("CONNECT_ROOT_PAGE_HINT");
    }

    @Override
    public String getHelpTopic() {
        return "f1_cvsconwroot_html";
    }

    @Override
    public JComponent getPanel() {
        return this._panel;
    }

    @Override
    public Component getFocusComponent() {
        return this._ui.getCVSRootField();
    }

    @Override
    public String getLabel() {
        return CVSArb.get("CONNECT_ROOT_PAGE_LABEL");
    }

    @Override
    public Object[] getPropertyKeys() {
        return new Object[]{KEY_CONNECTION_ROOT};
    }

    @Override
    public void populatePage(Map props) {
        this._rshDialog.setProperties(props);
        Object value = props.get(KEY_CONNECTION_ROOT);
        if (value != null) {
            CVSRootString rootstr = new CVSRootString(value.toString());
            CVSConnectRootObservable rootobs = (CVSConnectRootObservable)this._rootobs;
            rootobs.setRoot(rootstr);
            rootobs.notifyObservers(rootstr);
        }
        this.updateEnabledState();
    }

    @Override
    public void validatePage() throws CVSWizardException {
    }

    @Override
    public void applyPage(Map props) {
        CVSRootString rootstr = new CVSRootString(this._ui.getCVSRootField().getText().trim());
        String access = rootstr.hasKnownAccess() ? rootstr.getAccessMethod() : null;
        Iterator itr = this._rshDialog.getPropertyKeys().iterator();
        while (itr.hasNext()) {
            props.remove(itr.next());
        }
        if (rootstr.isAccessExternal()) {
            props.putAll(this._rshDialog.getProperties());
        }
        CVSConnectRootObservable rootobs = (CVSConnectRootObservable)this._rootobs;
        CVSConnectNamePage.propagateCurrentRootToName(props, this._nameobs, rootobs, rootstr);
        rootobs.setRoot(rootstr);
        rootobs.notifyObservers(rootstr);
        props.put(KEY_CONNECTION_ROOT, rootobs.getRoot().toString());
        if (access == null || access == CVSConnectAccessMethod.ACCESS_OTHER) {
            return;
        }
    }

    private final void updateEnabledState() {
        this._ui.getRshPanel().getRshConfigButton().setEnabled(new CVSRootString(this._ui.getCVSRootField().getText().trim()).isAccessExternal());
        if (this.getWizardPage() != null) {
            this.getWizardPage().setCanAdvance(!this._ui.getCVSRootField().getText().trim().equals(""));
        }
    }

    private abstract class DocumentAdapter
    implements DocumentListener {
        private DocumentAdapter() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.documentUpdate(e);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.documentUpdate(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.documentUpdate(e);
        }

        protected abstract void documentUpdate(DocumentEvent var1);
    }
}

