/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.wiz.connect;

import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdevimpl.vcs.cvs.client.CVSClientConstants;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.wiz.connect.CVSConnectAccessMethod;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardException;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardValidationException;

public final class CVSConnectRoot
implements CVSClientConstants {
    static final int MIN_PORT_NUMBER = 0;
    static final int MAX_PORT_NUMBER = 65535;
    static final String SSH2_KEY_ACCESS_FIELD = "key";

    private CVSConnectRoot() {
    }

    static final String getSupportedAccessMethodRoot(Object access) {
        Collection accessOptions = CVSConnectAccessMethod.getAccessOptions();
        if (accessOptions.contains(access)) {
            return CVSConnectRoot.getAccessMethodRoot(access);
        }
        return "";
    }

    public static final String getAccessMethodRoot(Object access) {
        if (access.equals(CVSConnectAccessMethod.ACCESS_LOCAL)) {
            return "local";
        }
        if (access.equals(CVSConnectAccessMethod.ACCESS_EXTERNAL)) {
            return "ext";
        }
        if (access.equals(CVSConnectAccessMethod.ACCESS_PSERVER)) {
            return "pserver";
        }
        if (access.equals(CVSConnectAccessMethod.ACCESS_SSPI)) {
            return "sspi";
        }
        if (access.equals(CVSConnectAccessMethod.ACCESS_SERVER)) {
            return "server";
        }
        if (access.equals(CVSConnectAccessMethod.ACCESS_FORK_AS_LOCAL)) {
            return "fork";
        }
        if (access.equals(CVSConnectAccessMethod.ACCESS_SSH2)) {
            return "ssh2";
        }
        return "";
    }

    static final String getSupportedAccessMethodName(Object method) {
        Collection accessOptions = CVSConnectAccessMethod.getAccessOptions();
        String access = CVSConnectRoot.getAccessMethodName(method);
        return access != null && accessOptions.contains(access) ? access : CVSConnectAccessMethod.ACCESS_OTHER;
    }

    public static final String getAccessMethodName(Object method) {
        if (method.equals("local")) {
            return CVSConnectAccessMethod.ACCESS_LOCAL;
        }
        if (method.equals("ext")) {
            return CVSConnectAccessMethod.ACCESS_EXTERNAL;
        }
        if (method.equals("pserver")) {
            return CVSConnectAccessMethod.ACCESS_PSERVER;
        }
        if (method.equals("sspi")) {
            return CVSConnectAccessMethod.ACCESS_SSPI;
        }
        if (method.equals("server")) {
            return CVSConnectAccessMethod.ACCESS_SERVER;
        }
        if (method.equals("fork")) {
            return CVSConnectAccessMethod.ACCESS_FORK_AS_LOCAL;
        }
        if (method.equals("ssh2")) {
            return CVSConnectAccessMethod.ACCESS_SSH2;
        }
        return null;
    }

    static final void validateRoot(CVSRootString root) throws CVSWizardException {
        if (root == null) {
            return;
        }
        if (root.toString().equals("")) {
            throw new CVSWizardValidationException(CVSArb.get("CONNECT_ROOT_PAGE_ERROR_1"));
        }
        if (!root.hasKnownAccess()) {
            return;
        }
        if (root.supportsUserName() && CVSConnectRoot.isEmpty(root.getUserName())) {
            throw new CVSWizardValidationException(CVSArb.get("CONNECT_ROOT_VALIDATE_ERROR_1"));
        }
        if (root.supportsServerLocation() && (CVSConnectRoot.isEmpty(root.getServerLocation()) || !CVSConnectRoot.isValidHostname(root.getServerLocation()))) {
            throw new CVSWizardValidationException(CVSArb.get("CONNECT_ROOT_VALIDATE_ERROR_2"));
        }
        if (root.supportsRepository() && (CVSConnectRoot.isEmpty(root.getRepository()) || !CVSConnectRoot.isValidPathToRepository(root.getRepository()))) {
            throw new CVSWizardValidationException(CVSArb.get("CONNECT_ROOT_VALIDATE_ERROR_3"));
        }
        if (root.isAccessSsh2()) {
            Map accessFieldMap = root.getRootSpecifier().getMethodSpecifier().getFieldMap();
            String path = null;
            if (accessFieldMap != null) {
                path = (String)accessFieldMap.get(SSH2_KEY_ACCESS_FIELD);
            }
            if (path != null) {
                URL url = URLFactory.newFileURL(path);
                if (URLFileSystem.isDirectory((URL)url)) {
                    throw new CVSWizardValidationException(CVSArb.get("ERROR_KEY_FILE_IS_DIRECTORY"));
                }
                if (!URLFileSystem.exists((URL)url)) {
                    throw new CVSWizardValidationException(CVSArb.get("ERROR_KEY_FILE_DOES_NOT_EXIST"));
                }
            }
        }
        if (!root.supportsPort() || CVSConnectRoot.isEmpty(root.getPort())) {
            return;
        }
        if (!CVSConnectRoot.isValidPort(root.getPort())) {
            throw new CVSWizardValidationException(CVSArb.get("CONNECT_ROOT_VALIDATE_ERROR_6"));
        }
        try {
            int port = Integer.parseInt(root.getPort());
            if (port != 2401 && root.supportsRepository() && !CVSConnectRoot.isEmpty(root.getRepository()) && !root.getRepository().startsWith("/")) {
                throw new CVSWizardValidationException(CVSArb.get("CONNECT_ROOT_VALIDATE_ERROR_4"));
            }
            if (port < 0 || port > 65535) {
                throw new CVSWizardValidationException(CVSArb.get("CONNECT_ROOT_VALIDATE_ERROR_5"));
            }
        }
        catch (NumberFormatException nfe) {
            throw new CVSWizardValidationException(CVSArb.get("CONNECT_ROOT_VALIDATE_ERROR_6"));
        }
    }

    static final String canonicalizeCVSNTRoot(String root) {
        return CVSRootString.canonicalizeCVSNTRoot(root);
    }

    private static final boolean isEmpty(String s) {
        return s == null || s.equals("");
    }

    private static final boolean isValidHostname(String hostname) {
        return hostname == null || Pattern.matches("[^:/]+", hostname);
    }

    private static final boolean isValidPathToRepository(String pathToRepository) {
        return pathToRepository == null || Pattern.matches("([^:]:/|/|[^:]:\\\\).*", pathToRepository);
    }

    private static final boolean isValidPort(String port) {
        return port == null || Pattern.matches("([\\d]+)(:)?", port);
    }
}

