/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.wiz.connect;

import java.awt.Component;
import java.awt.EventQueue;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import oracle.ide.controller.IdeAction;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.jdeveloper.vcs.nav.VersioningNavigatorConstants;
import oracle.jdeveloper.vcs.spi.VCSControlCache;
import oracle.jdevimpl.vcs.cvs.CVSActiveClient;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodes;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.wiz.connect.CVSConnectCreateCommitter;
import oracle.jdevimpl.vcs.cvs.wiz.connect.CVSConnectModelKey;
import oracle.jdevimpl.vcs.cvs.wiz.connect.CVSConnectRoot;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardAbortException;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardCommitWatcher;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardCommitter;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardException;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardValidationException;

public abstract class CVSConnectCommitter
extends CVSWizardCommitter
implements CVSConnectModelKey {
    private final Map _oldProps;

    protected CVSConnectCommitter() {
        this(Collections.EMPTY_MAP);
    }

    protected CVSConnectCommitter(Map oldProps) {
        this._oldProps = oldProps;
    }

    @Override
    public String getCommitText() {
        return null;
    }

    @Override
    public void prepareCommit(Map props, Component modalComponent) throws CVSWizardException, CVSWizardAbortException {
        URL repositoryUrl;
        URL cvsrootUrl;
        String root = (String)props.get(KEY_CONNECTION_ROOT);
        Assert.check((root != null ? 1 : 0) != 0);
        CVSRootString rootstr = new CVSRootString(root);
        if ((rootstr.isAccessLocal() || rootstr.isAccessFork()) && !rootstr.getRepository().equals("") && !URLFileSystem.isDirectory((URL)(cvsrootUrl = URLFactory.newURL((URL)(repositoryUrl = URLFactory.newFileURL((String)rootstr.getRepository())), (String)"CVSROOT")))) {
            throw new CVSWizardValidationException(CVSArb.format("CONNECT_WIZ_INVALID_LOCAL_REPOSITORY", URLFileSystem.getPlatformPathName((URL)repositoryUrl)));
        }
        CVSConnectRoot.validateRoot(rootstr);
    }

    @Override
    public void commitWizard(Map props, Component modalComponent, CVSWizardCommitWatcher watcher) throws CVSWizardException, CVSWizardAbortException {
        String oldName = (String)this._oldProps.get(KEY_CONNECTION_NAME);
        String oldRoot = (String)this._oldProps.get(KEY_CONNECTION_ROOT);
        String name = (String)props.get(CVSConnectModelKey.KEY_CONNECTION_NAME);
        String root = (String)props.get(KEY_CONNECTION_ROOT);
        Assert.check((root != null ? 1 : 0) != 0);
        if (name == null) {
            props.put(CVSConnectModelKey.KEY_CONNECTION_NAME, root);
        }
        if (CVSActiveClient.isClientCVSNT()) {
            root = CVSConnectRoot.canonicalizeCVSNTRoot(root);
            props.put(KEY_CONNECTION_ROOT, root);
        }
        CVSConnectCreateCommitter.validateRoot(oldRoot, root);
        CVSConnectCreateCommitter.validateName(oldName, name);
        this.configureConnection(oldName, oldRoot, props);
        VCSControlCache.getInstance().fireControlStateChanged("oracle.jdeveloper.cvs");
        CVSClient.getInstance();
        CVSClient.getStatusCache().clear();
        CVSConnectionNodes.updateOverlays();
    }

    protected abstract void configureConnection(String var1, String var2, Map var3);

    @Override
    public void doneCommitting(Map props) {
    }

    protected void showNavigator() {
        final IdeAction showNavigatorAction = IdeAction.find((int)VersioningNavigatorConstants.SHOW_NAVIGATOR_CMD_ID);
        if (showNavigatorAction == null) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    showNavigatorAction.performAction();
                }
                catch (Exception e) {
                    Assert.printStackTrace((Throwable)e);
                }
            }
        });
    }

    static final void validateRoot(String oldRoot, String root) throws CVSWizardException {
        CVSRootString rootstr = new CVSRootString(root);
        if (oldRoot != null && new CVSRootString(oldRoot).equals(rootstr)) {
            return;
        }
        CVSConnectionData conn = CVSUtil.getRootConnection(rootstr);
        if (conn == null) {
            return;
        }
        if (new CVSRootString(conn.getRoot()).equals(rootstr)) {
            throw new CVSWizardValidationException(CVSArb.get("CONNECT_ROOT_EXISTS_ERROR"));
        }
    }

    static final void validateName(String oldName, String name) throws CVSWizardException {
        if (oldName != null && oldName.equals(name)) {
            return;
        }
        if (name.equals("")) {
            throw new CVSWizardValidationException(CVSArb.get("CONNECT_NAME_PAGE_ERROR_1"));
        }
        if (CVSConnectionNodes.getConnectionListData().hasConnection(name)) {
            throw new CVSWizardValidationException(CVSArb.get("CONNECT_NAME_PAGE_ERROR_2"));
        }
    }
}

