/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.wiz.connect;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import oracle.jdevimpl.vcs.cvs.CVSActiveClient;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;

public final class CVSConnectAccessMethod {
    public static final String ACCESS_LOCAL = CVSArb.get("ACCESS_LOCAL");
    public static final String ACCESS_EXTERNAL = CVSArb.get("ACCESS_EXTERNAL");
    public static final String ACCESS_PSERVER = CVSArb.get("ACCESS_PSERVER");
    public static final String ACCESS_SSPI = CVSArb.get("ACCESS_SSPI");
    public static final String ACCESS_SERVER = CVSArb.get("ACCESS_SERVER");
    public static final String ACCESS_OTHER = CVSArb.get("ACCESS_OTHER");
    public static final String ACCESS_FORK_AS_LOCAL = CVSArb.get("ACCESS_FORK_AS_LOCAL");
    public static final String ACCESS_SSH2 = CVSArb.get("ACCESS_SSH2");

    private CVSConnectAccessMethod() {
    }

    public static final Collection getAccessOptions() {
        ArrayList<Object> accessStringsList = new ArrayList<Object>();
        if (CVSClient.getInstance().isUsingInternalClient()) {
            accessStringsList.addAll(Arrays.asList(ACCESS_FORK_AS_LOCAL, ACCESS_EXTERNAL, ACCESS_PSERVER, ACCESS_SSH2));
        } else {
            accessStringsList.addAll(Arrays.asList(ACCESS_LOCAL, ACCESS_EXTERNAL, ACCESS_PSERVER, ACCESS_SERVER));
            if (CVSActiveClient.isClientCVSNT()) {
                accessStringsList.add(ACCESS_SSPI);
            }
        }
        Collections.sort(accessStringsList);
        accessStringsList.add(ACCESS_OTHER);
        if (!Boolean.getBoolean("jdev.cvs.enablefork")) {
            accessStringsList.remove(ACCESS_FORK_AS_LOCAL);
        }
        return accessStringsList;
    }

    static final boolean requiresUserName(Object access) {
        if (access == ACCESS_OTHER) {
            return false;
        }
        return access != ACCESS_LOCAL && access != ACCESS_SSPI && access != ACCESS_FORK_AS_LOCAL;
    }

    static final boolean requiresServerLocation(Object access) {
        if (access == ACCESS_OTHER) {
            return false;
        }
        return access != ACCESS_LOCAL && access != ACCESS_FORK_AS_LOCAL;
    }

    static final boolean requiresPort(Object access) {
        if (access == ACCESS_OTHER) {
            return false;
        }
        return access == ACCESS_PSERVER;
    }

    static final boolean requiresRepository(Object access) {
        return access != ACCESS_OTHER;
    }
}

