/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.wiz.checkout;

import java.awt.Component;
import java.awt.Container;
import java.net.URL;
import java.util.Map;
import javax.swing.JComponent;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdevimpl.vcs.cvs.CVSResourcePicker;
import oracle.jdevimpl.vcs.cvs.control.CVSHintContainer;
import oracle.jdevimpl.vcs.cvs.ui.CVSCheckoutTargetPageUI;
import oracle.jdevimpl.vcs.cvs.util.CVSResourceProxy;
import oracle.jdevimpl.vcs.cvs.wiz.checkout.CVSCheckoutModelKey;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardException;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardPage;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardValidationException;

public class CVSCheckoutTargetPage
extends CVSWizardPage
implements CVSCheckoutModelKey {
    private JComponent _panel = null;
    private CVSCheckoutTargetPageUI _ui = new CVSCheckoutTargetPageUI();

    protected CVSCheckoutTargetPage() {
        this.createPanel();
    }

    private void createPanel() {
        CVSResourcePicker.getPicker(this.getClass()).start((Container)this._ui);
        this._ui.getChooserPanel().setChooseFolders(true);
        this._ui.getTargetLabel().setLabelFor(this._ui.getChooserPanel().getFocusComponent());
        String hint = CVSResourceProxy.getProxy(this.getClass()).getString("CHECKOUT_TARGET_PAGE_HINT");
        this._panel = new CVSHintContainer(hint, this._ui);
    }

    @Override
    public String getAccessibleDescription() {
        return CVSResourceProxy.getProxy(this.getClass()).getString("CHECKOUT_TARGET_PAGE_HINT");
    }

    @Override
    public String getHelpTopic() {
        return "f1_cvschkoutwtarget_html";
    }

    @Override
    public JComponent getPanel() {
        return this._panel;
    }

    @Override
    public Component getFocusComponent() {
        return this._ui.getChooserPanel().getFocusComponent();
    }

    @Override
    public String getLabel() {
        return CVSResourceProxy.getProxy(this.getClass()).getString("CHECKOUT_TARGET_PAGE_LABEL");
    }

    @Override
    public Object[] getPropertyKeys() {
        return new Object[]{KEY_CHECKOUT_TARGET, KEY_CHECKOUT_CHECKOUT_TO_DIR};
    }

    @Override
    public void populatePage(Map props) {
        if (props.containsKey(KEY_CHECKOUT_CHECKOUT_TO_DIR)) {
            this._ui.getCheckoutIntoCheckBox().setSelected((Boolean)props.get(KEY_CHECKOUT_CHECKOUT_TO_DIR));
        }
        if (props.containsKey(KEY_CHECKOUT_TARGET)) {
            this._ui.getChooserPanel().setURL(URLFactory.newFileURL((String)props.get(KEY_CHECKOUT_TARGET).toString()));
        } else {
            URL url = this.getDefaultChooserURL();
            if (url != null) {
                this._ui.getChooserPanel().setURL(url);
            }
        }
    }

    @Override
    public void validatePage() throws CVSWizardException {
        URL folderUrl = this._ui.getChooserPanel().getURL();
        if (folderUrl == null || URLFileSystem.exists((URL)folderUrl) && !URLFileSystem.isDirectory((URL)folderUrl)) {
            throw new CVSWizardValidationException(CVSResourceProxy.getProxy(this.getClass()).getString("CHECKOUT_TARGET_PAGE_ERROR_1"));
        }
        if (this._ui.getCheckoutIntoCheckBox().isSelected() && URLFileSystem.isRoot((URL)folderUrl)) {
            throw new CVSWizardValidationException(CVSResourceProxy.getProxy(this.getClass()).getString("CHECKOUT_TARGET_PAGE_ERROR_2"));
        }
    }

    @Override
    public void applyPage(Map props) {
        URL url = this._ui.getChooserPanel().getURL();
        url = URLFileSystem.canonicalize((URL)url);
        props.put(KEY_CHECKOUT_TARGET, VCSFileSystemUtils.getPlatformPathName((URL)url));
        props.put(KEY_CHECKOUT_CHECKOUT_TO_DIR, new Boolean(this._ui.getCheckoutIntoCheckBox().isSelected()));
    }

    private URL getDefaultChooserURL() {
        return Ide.getWorkspaces().getWorkDirectory();
    }
}

