/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.wiz.checkout;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSResourcePicker;
import oracle.jdevimpl.vcs.cvs.control.CVSHintContainer;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionArgument;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionCategory;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionDirector;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionId;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionsCustomizer;
import oracle.jdevimpl.vcs.cvs.ui.CVSCheckoutOptionsPageUI;
import oracle.jdevimpl.vcs.cvs.ui.CVSCheckoutOptionsUI;
import oracle.jdevimpl.vcs.cvs.util.CVSResourceProxy;
import oracle.jdevimpl.vcs.cvs.wiz.checkout.CVSCheckoutModelKey;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardException;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardPage;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardValidationException;

public class CVSCheckoutOptionsPage
extends CVSWizardPage
implements CVSCheckoutModelKey {
    private JComponent _panel = null;
    private CVSCheckoutOptionsPageUI _ui = new CVSCheckoutOptionsPageUI();
    private CVSCheckoutOptionsUI _ui2 = new CVSCheckoutOptionsUI();
    private CVSOptionsCustomizer _customizer;

    protected CVSCheckoutOptionsPage() {
        this.createPanel();
    }

    private void createPanel() {
        CVSResourcePicker.getPicker(this.getClass()).start((Container)this._ui);
        CVSResourcePicker.getPicker(this.getClass()).start((Container)this._ui2);
        this._ui.getOptionsPanel().removeAll();
        this._ui.getOptionsPanel().setLayout(new BorderLayout());
        if (this.hasPruneOption()) {
            this._ui.getOptionsPanel().add((Component)this._ui2, "North");
        }
        String hint = CVSResourceProxy.getProxy(this.getClass()).getString("CHECKOUT_OPTIONS_PAGE_HINT");
        this._customizer = this.createOptionsCustomizer();
        if (this._customizer.getComponent().isVisible()) {
            if (this.hasPruneOption()) {
                JPanel container = new JPanel(new BorderLayout());
                container.add(Box.createVerticalStrut(10), "North");
                container.add(this._customizer.getComponent(), "Center");
                this._ui.getOptionsPanel().add((Component)container, "Center");
            } else {
                this._ui.getOptionsPanel().add(this._customizer.getComponent(), "Center");
            }
        }
        this._panel = new CVSHintContainer(hint, this._ui);
    }

    private CVSOptionsCustomizer createOptionsCustomizer() {
        CVSOptionDirector optionDirector = this.createOptionDirector();
        if (!CVSClient.getInstance().isAdvancedModeSet()) {
            optionDirector.deregisterCategoryOptions(CVSOptionCategory.ADVANCED);
        }
        CVSOptionsCustomizer customizer = new CVSOptionsCustomizer(optionDirector.constructOptionComponents());
        customizer.setLayoutColumns(1);
        customizer.setDefaultOptionValues(this.createDefaultOptionsValues());
        return customizer;
    }

    protected CVSOptionDirector createOptionDirector() {
        CVSOptionDirector optionDirector = new CVSOptionDirector();
        optionDirector.registerCategoryOptions(CVSOptionCategory.BASIC, new CVSOptionId[]{CVSOptionId.COMMON_USE_REVISION_OR_DATE_AND_FORCE});
        optionDirector.registerCategoryOptions(CVSOptionCategory.ADVANCED, new CVSOptionId[]{CVSOptionId.COMMON_LOCAL_FOLDER_ONLY, CVSOptionId.COMMON_NO_MODULE_PROGRAMS});
        return optionDirector;
    }

    @Override
    public String getAccessibleDescription() {
        return CVSResourceProxy.getProxy(this.getClass()).getString("CHECKOUT_OPTIONS_PAGE_HINT");
    }

    @Override
    public String getHelpTopic() {
        return "f1_cvschkoutwoptions_html";
    }

    @Override
    public JComponent getPanel() {
        return this._panel;
    }

    @Override
    public Component getFocusComponent() {
        return this.hasPruneOption() ? this._ui2.getPruneFolderCheckBox() : this._customizer.getInitialFocusComponent();
    }

    @Override
    public String getLabel() {
        return CVSResourceProxy.getProxy(this.getClass()).getString("CHECKOUT_OPTIONS_PAGE_LABEL");
    }

    @Override
    public Object[] getPropertyKeys() {
        ArrayList<Object> options = new ArrayList<Object>();
        options.addAll(Arrays.asList(new Object[]{CVSOptionId.COMMON_USE_REVISION_OR_DATE_AND_FORCE, CVSOptionArgument.REVISION_NAME, CVSOptionArgument.REVISION_DATE, CVSOptionArgument.FORCE_MATCH, CVSOptionId.COMMON_LOCAL_FOLDER_ONLY, CVSOptionId.COMMON_NO_MODULE_PROGRAMS}));
        if (this.hasPruneOption()) {
            options.add(KEY_CHECKOUT_PRUNE_FOLDERS);
        }
        return options.toArray();
    }

    @Override
    public void populatePage(Map props) {
        Map defaults = this.createDefaultOptionsValues();
        defaults.putAll(props);
        props = defaults;
        if (props.containsKey(KEY_CHECKOUT_PRUNE_FOLDERS)) {
            this._ui2.getPruneFolderCheckBox().setSelected((Boolean)props.get(KEY_CHECKOUT_PRUNE_FOLDERS));
        }
        if (this._customizer != null) {
            this._customizer.setOptions(props);
        }
        this.updateEnabledComponents();
    }

    @Override
    public void validatePage() throws CVSWizardException {
        Boolean useRevisionOrDate;
        if (this._customizer == null) {
            return;
        }
        try {
            this._customizer.validateOptions();
        }
        catch (VCSException vcse) {
            throw new CVSWizardValidationException(vcse.getMessage());
        }
        if (!this.isDateOrTagRequired()) {
            return;
        }
        Map common = this._customizer.getOptions();
        Boolean bl = useRevisionOrDate = common.containsKey((Object)CVSOptionId.COMMON_USE_REVISION_OR_DATE_AND_FORCE) ? (Boolean)common.get((Object)CVSOptionId.COMMON_USE_REVISION_OR_DATE_AND_FORCE) : null;
        if (useRevisionOrDate != null && !useRevisionOrDate.booleanValue()) {
            throw new CVSWizardValidationException(CVSResourceProxy.getProxy(this.getClass()).getString("CHECKOUT_GENERAL_PAGE_ERROR_1"));
        }
    }

    @Override
    public void applyPage(Map props) {
        if (this.hasPruneOption()) {
            props.put(KEY_CHECKOUT_PRUNE_FOLDERS, new Boolean(this._ui2.getPruneFolderCheckBox().isSelected()));
        }
        if (this._customizer == null) {
            return;
        }
        props.putAll(this._customizer.getOptions());
    }

    @Override
    public void disposePage() {
        if (this._customizer != null) {
            this._customizer.dispose();
        }
    }

    private final void updateEnabledComponents() {
        this._ui2.getPruneFolderCheckBox().setEnabled(this.hasPruneOption());
    }

    protected boolean hasJoinOption() {
        return true;
    }

    protected boolean hasPruneOption() {
        return true;
    }

    protected boolean isDateOrTagRequired() {
        return false;
    }

    protected Map createDefaultOptionsValues() {
        return new HashMap();
    }
}

