/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.util.revision;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.ide.util.Encodings;
import oracle.javatools.util.Log;
import oracle.jdeveloper.compare.StreamDecoder;
import oracle.jdeveloper.vcs.util.VCSStreamUtils;
import oracle.jdevimpl.vcs.cvs.CVSRootCache;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.error.CVSOperationException;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodeUtils;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerFactory;
import oracle.jdevimpl.vcs.cvs.util.revision.CVSRevisionInfo;

public class CVSRevisionUtils {
    private static final String RE_STR_REVISION_INFO = "RCS:\\s*(.*)VERS:\\s*([\\d\\.]*)";
    private static final Log LOG = new Log("vcs-cvs");

    private CVSRevisionUtils() {
    }

    public static final CVSRevisionInfo downloadContents(URL url, String rev, String date, boolean quiet) throws Exception {
        if (rev != null && date == null) {
            URL parent = URLFileSystem.getParent((URL)url);
            String root = CVSRootCache.getInstance().getRoot(parent).toString();
            String repository = CVSUtil.readRepository(parent);
            String path = repository + '/' + URLFileSystem.getFileName((URL)url);
            try {
                byte[] contents = CVSConnectionNodeUtils.downloadContents(root, path, rev);
                CVSRevisionInfo info = new CVSRevisionInfo();
                info.setRCSFile(path + ",v");
                info.setVersion(rev);
                info.setContents(contents);
                if (Boolean.getBoolean("jdev.cvs.debugencoding")) {
                    LOG.trace("CVS: Obtained revision data through connection services");
                }
                return info;
            }
            catch (UnsupportedOperationException contents) {
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
        }
        ArrayList<String> switches = new ArrayList<String>();
        if (rev != null) {
            switches.add("-r" + rev);
        }
        if (date != null) {
            switches.add("-D");
            switches.add(date);
        }
        switches.add("-p");
        CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        URL dir = url;
        if (URLFileSystem.getParent((URL)url) != null) {
            dir = URLFileSystem.getParent((URL)url);
        }
        runner.setDirURL_(dir);
        runner.getParameters().setFile(URLFileSystem.getFileName((URL)url));
        runner.setCommand_("update");
        runner.getParameters().setOptions(switches);
        runner.getParameters().setQuiet(quiet);
        runner.setBufferOutputBinary_(true);
        runner.exec_();
        if (runner.getOutputText_() == null) {
            throw new CVSOperationException(CVSArb.format("REVISION_DOWNLOAD_FAILED", URLFileSystem.getFileName((URL)url)));
        }
        if (runner.getErrorText_() != null && !runner.getErrorText_().equals("")) {
            LOG.trace(runner.getErrorText_());
        }
        CVSRevisionInfo info = new CVSRevisionInfo();
        Pattern pattern = Pattern.compile(RE_STR_REVISION_INFO, 32);
        Matcher matcher = pattern.matcher(runner.getErrorText_());
        if (matcher.find()) {
            info.setRCSFile(matcher.group(1).trim());
            info.setVersion(matcher.group(2).trim());
        }
        String platformNewline = System.getProperty("line.separator");
        byte[] contents = runner.getOutputBytes_();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (Boolean.getBoolean("jdev.cvs.debugencoding")) {
            BufferedInputStream bis = new BufferedInputStream(URLFileSystem.openInputStream((URL)url));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            VCSStreamUtils.pipeStreamData((InputStream)bis, (OutputStream)baos);
            CVSRevisionUtils.dumpBytes("bytes (file)", baos.toByteArray());
        }
        if (Boolean.getBoolean("jdev.cvs.debugencoding")) {
            CVSRevisionUtils.dumpBytes("bytes before", contents);
        }
        int i = 0;
        while (i < contents.length) {
            if (CVSRevisionUtils.matchesPlatformNewLine(contents, i, platformNewline)) {
                if ((i += platformNewline.length()) >= contents.length && !StreamDecoder.getDefaultEncoding((URL)url).equals(Encodings.getDefaultEncoding())) continue;
                byteArrayOutputStream.write(10);
                continue;
            }
            byteArrayOutputStream.write(contents[i]);
            ++i;
        }
        if (Boolean.getBoolean("jdev.cvs.debugencoding")) {
            CVSRevisionUtils.dumpBytes("bytes after", byteArrayOutputStream.toByteArray());
        }
        info.setContents(byteArrayOutputStream.toByteArray());
        return info;
    }

    private static final boolean matchesPlatformNewLine(byte[] contents, int i, String platformNewline) {
        int j = 0;
        while (j < platformNewline.length()) {
            if (i >= contents.length) {
                return false;
            }
            if (contents[i] != platformNewline.charAt(j)) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    private static final void dumpBytes(String label, byte[] bytes) {
        System.out.print(label + ": ");
        for (int i = 0; i < bytes.length; ++i) {
            if (i != 0) {
                System.out.print(",");
            }
            System.out.print(bytes[i]);
        }
        System.out.println();
    }

    private static final String readStringFile(URL url) throws IOException {
        try (BufferedReader in = new BufferedReader(new FileReader(URLFileSystem.getPlatformPathName((URL)url)));){
            String string = in.readLine();
            return string;
        }
    }
}

