/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.util.log;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.history.HistoryEntry;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSGlobalOptionId;
import oracle.jdevimpl.vcs.cvs.error.CVSProcessException;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.runner.CVSInternalClientRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerFactory;
import oracle.jdevimpl.vcs.cvs.util.log.CVSLogParser;

public final class CVSLogReadWorker {
    private final URL _url;

    public CVSLogReadWorker(URL url) {
        this._url = url;
    }

    public static final CVSRunner createLogRunner(URL url) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("log");
        cmd.add(URLFileSystem.getFileName((URL)url));
        CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        URL dir = url;
        URL parent = URLFileSystem.getParent((URL)url);
        if (parent != null) {
            dir = parent;
        }
        runner.setCmdList_(cmd);
        runner.setDirURL_(dir);
        runner.getParameters().setQuiet(!Boolean.getBoolean("jdev.cvs.debugconnectiontest"));
        if (runner.getParameters().getGlobals() != null) {
            Map globals = runner.getParameters().getGlobals();
            globals.remove((Object)CVSGlobalOptionId.L_NO_HISTORY_LOGGING);
            runner.getParameters().setGlobals(globals);
        }
        return runner;
    }

    public final HistoryEntry[] getEntries() throws Exception {
        CVSRunner runner = CVSLogReadWorker.createLogRunner(this._url);
        if (runner instanceof CVSInternalClientRunner) {
            ((CVSInternalClientRunner)runner).setStandardOutEncoding("UTF-8");
        }
        runner.setBufferOutputBinary_(true);
        runner.exec_();
        if (Boolean.getBoolean("jdev.cvs.debugconnectiontest")) {
            if (runner != null && runner.getExitCode_() == null) {
                CVSClient.getInstance().getLogWriter().println("exit code: null");
            } else {
                CVSClient.getInstance().getLogWriter().println("exit code: " + runner.getExitCode_());
            }
        }
        if (runner.getExitCode_() == null || runner.getExitCode_() != 0) {
            throw new CVSProcessException(CVSArb.get("ERROR_LOG_FAILED"), runner.getErrorText_());
        }
        List revisions = CVSLogParser.parse(this._url, new String(runner.getOutputBytes_(), "UTF-8"));
        return revisions.toArray(new HistoryEntry[revisions.size()]);
    }
}

