/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.util.log;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.ide.vhv.rlog.RlogFormat;
import oracle.ide.vhv.rlog.RlogModel;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.util.ImageIconCache;
import oracle.javatools.util.Log;
import oracle.javatools.util.Version;
import oracle.jdeveloper.compare.BinaryCompareContributor;
import oracle.jdeveloper.compare.InputStreamTextContributor;
import oracle.jdeveloper.compare.PatchCompareDescriptor;
import oracle.jdeveloper.compare.StreamDecoder;
import oracle.jdeveloper.history.RevisionIdentifier;
import oracle.jdeveloper.history.SharedProperties;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdevimpl.vcs.cvs.CVSEntriesCache;
import oracle.jdevimpl.vcs.cvs.client.CVSEntry;
import oracle.jdevimpl.vcs.cvs.op.CVSOperationOpenRevision;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.util.log.CVSLogEntry;
import oracle.jdevimpl.vcs.cvs.util.log.CVSLogModel;
import oracle.jdevimpl.vcs.cvs.util.revision.CVSRevisionInfo;
import oracle.jdevimpl.vcs.cvs.util.revision.CVSRevisionUtils;

class CVSLogParser {
    CVSLogParser() {
    }

    static final List parse(final URL url, String log) {
        RlogModel.Entry[] rlogEntries;
        RlogModel rlogModel = null;
        try {
            rlogModel = new RlogFormat().parse((Reader)new StringReader(log));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return Collections.EMPTY_LIST;
        }
        CVSEntry adminEntry = null;
        try {
            adminEntry = CVSEntriesCache.findEntry(CVSEntriesCache.getInstance().getEntriesMap(URLFileSystem.getParent((URL)url)), url);
        }
        catch (IOException ioe) {
            Assert.printStackTrace((Throwable)ioe);
        }
        ArrayList<1> entries = new ArrayList<1>();
        for (RlogModel.Entry rlogEntry : rlogEntries = rlogModel.getEntries()) {
            CVSLogEntry entry = new CVSLogEntry(){
                private URL _url;
                private SoftReference _compareContributor;
                private final Log LOG;
                {
                    this._url = url;
                    this.LOG = new Log("vcs-cvs");
                }

                public CompareContributor getCompareContributor() throws Exception {
                    if (this._compareContributor == null || this._compareContributor.get() == null) {
                        String revision = ((RevisionIdentifier)this.getValue(SharedProperties.getRevisionProperty())).getLabel();
                        CVSRevisionInfo info = CVSRevisionUtils.downloadContents(url, revision, null, true);
                        String path = info.getRCSFile() != null ? info.getRCSFile() : URLFileSystem.getPlatformPathName((URL)url);
                        String resourceName = CVSArb.format("DIFF_INTEGRATED_RESOURCE", revision, path);
                        String charsetName = StreamDecoder.getDefaultEncoding((URL)url);
                        if (Boolean.getBoolean("jdev.cvs.debugencoding")) {
                            this.LOG.trace("CVS: History revision has encoding " + charsetName);
                        }
                        if (VCSFileSystemUtils.isContentTypeBinary((URL)url)) {
                            return new BinaryCompareContributor((InputStream)new ByteArrayInputStream(info.getContents()), URLFileSystem.getFileName((URL)url), resourceName, resourceName);
                        }
                        InputStreamTextContributor compareContributor = new InputStreamTextContributor((InputStream)new ByteArrayInputStream(info.getContents()), charsetName, resourceName, resourceName, URLFileSystem.getSuffix((URL)url));
                        compareContributor.setPatchDescriptor(new PatchCompareDescriptor(URLFileSystem.getFileName((URL)url)));
                        compareContributor.getPatchDescriptor().setPatchParentURL(URLFileSystem.getParent((URL)url));
                        compareContributor.getPatchDescriptor().setLastModified(((Date)this.getValue(SharedProperties.getDateProperty())).getTime());
                        RevisionIdentifier revisionIdentifier = (RevisionIdentifier)this.getValue(SharedProperties.getRevisionProperty());
                        if (revisionIdentifier != null) {
                            compareContributor.getPatchDescriptor().setRevision(revisionIdentifier.getLabel());
                        }
                        this._compareContributor = new SoftReference<InputStreamTextContributor>(compareContributor);
                    }
                    return (CompareContributor)this._compareContributor.get();
                }

                public void view(Context context) throws Exception {
                    CVSOperationOpenRevision.openRevisionViewer(context, ((RevisionIdentifier)this.getValue(SharedProperties.getRevisionProperty())).getLabel());
                }

                @Override
                public URL getOwner() {
                    return this._url;
                }
            };
            RevisionIdentifier revision = new RevisionIdentifier((Icon)ImageIconCache.get((URL)CVSArb.class.getResource(CVSArb.get("CONNECTION_LIST_NODE_ICON"))), rlogEntry.getRevision().toString());
            revision.setCurrent(adminEntry != null && adminEntry.getRevision() != null && adminEntry.getRevision().equals(rlogEntry.getRevision().toString()));
            entry.setValue(CVSLogModel.PROPERTIES[1], revision);
            entry.setValue(CVSLogModel.PROPERTIES[2], CVSLogParser.getTagsForRevision(rlogModel.getSymbolicNames(), rlogEntry.getRevision()));
            entry.setValue(CVSLogModel.PROPERTIES[0], rlogEntry.getDate());
            entry.setValue(CVSLogModel.PROPERTIES[3], rlogEntry.getAuthor());
            entry.setValue(CVSLogModel.PROPERTIES[4], rlogEntry.getState());
            entry.setValue(CVSLogModel.PROPERTIES[5], rlogEntry.getLines() != null ? rlogEntry.getLines() : "");
            entry.setValue(CVSLogModel.PROPERTIES[6], rlogEntry.getMessage());
            entries.add(entry);
        }
        return entries;
    }

    private static final Collection<String> getTagsForRevision(Map symbolicNames, Version revision) {
        ArrayList<String> tags = new ArrayList<String>();
        for (Map.Entry entry : symbolicNames.entrySet()) {
            if (!entry.getValue().equals(revision)) continue;
            tags.add((String)entry.getKey());
        }
        Collections.sort(tags);
        return tags;
    }
}

