/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.options;

import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.ide.model.Locatable;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionBuilder;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionCategory;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionId;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionResources;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionStructure;
import oracle.jdevimpl.vcs.cvs.options.builder.CVSCommitForceCommitBuilder;
import oracle.jdevimpl.vcs.cvs.options.builder.CVSCommonLocalFolderOnlyBuilder;
import oracle.jdevimpl.vcs.cvs.options.builder.CVSCommonNoModuleProgramsBuilder;
import oracle.jdevimpl.vcs.cvs.options.builder.CVSCommonUseRevisionBuilder;
import oracle.jdevimpl.vcs.cvs.options.builder.CVSCommonUseRevisionOrDateBuilder;
import oracle.jdevimpl.vcs.cvs.options.builder.CVSCommonUseRevisionOrDateBuilder2;
import oracle.jdevimpl.vcs.cvs.options.builder.CVSTagCheckForChangesBuilder;
import oracle.jdevimpl.vcs.cvs.options.builder.CVSTagForceTagMoveBuilder;
import oracle.jdevimpl.vcs.cvs.options.builder.CVSTagTagNameBuilder;
import oracle.jdevimpl.vcs.cvs.options.builder.CVSTagTagNameChoiceBuilder;
import oracle.jdevimpl.vcs.cvs.options.builder.CVSUpdateCleanUpdateBuilder;
import oracle.jdevimpl.vcs.cvs.options.builder.CVSUpdateCreateFoldersBuilder;
import oracle.jdevimpl.vcs.cvs.options.builder.CVSUpdatePruneFoldersBuilder;
import oracle.jdevimpl.vcs.cvs.options.builder.CVSUpdateResetTagsBuilder;
import oracle.jdevimpl.vcs.cvs.options.builder.CVSWatchCommandTypeBuilder;
import oracle.jdevimpl.vcs.cvs.options.builder.CVSWatchSetWatchActionsBuilder;

public class CVSOptionDirector {
    private static final Map _builderMap = new HashMap();
    private final Map _categoryOptions = new LinkedHashMap();
    private final Map _builderPrototypes = new HashMap(_builderMap);
    private final URL[] _contextUrls;
    private final CVSOptionResources _resources;
    private Map<String, String> _contextProperties = null;

    public CVSOptionDirector() {
        this((URL[])null);
    }

    public CVSOptionDirector(Locatable[] contextLocatables) {
        this(VCSModelUtils.convertNodesToURLs((Locatable[])contextLocatables));
    }

    public CVSOptionDirector(URL[] contextUrls) {
        this(contextUrls, CVSOptionResources.getInstance());
    }

    public CVSOptionDirector(URL[] contextUrls, CVSOptionResources resources) {
        this._contextUrls = contextUrls;
        this._resources = resources;
    }

    public void setContextProperties(Map<String, String> contextProperties) {
        this._contextProperties = contextProperties;
    }

    public Map<String, String> getContextProperties() {
        return this._contextProperties;
    }

    public void registerCategoryOptions(CVSOptionCategory category, CVSOptionId[] ids) {
        this._categoryOptions.put(category, ids);
    }

    public void deregisterCategoryOptions(CVSOptionCategory category) {
        this._categoryOptions.remove((Object)category);
    }

    public void registerBuilderPrototype(CVSOptionId id, CVSOptionBuilder builderPrototype) {
        this._builderPrototypes.put(id, builderPrototype);
    }

    public void deregisterBuilderPrototype(CVSOptionId id) {
        this._builderPrototypes.remove((Object)id);
    }

    public CVSOptionStructure constructOptionComponents() {
        CVSOptionStructure structure = new CVSOptionStructure();
        for (Map.Entry entry : this._categoryOptions.entrySet()) {
            this.createStructure((CVSOptionId[])entry.getValue(), structure, (CVSOptionCategory)((Object)entry.getKey()));
        }
        this.attachListeners(structure);
        return structure;
    }

    private void createStructure(CVSOptionId[] ids, CVSOptionStructure structure, CVSOptionCategory category) {
        for (int i = 0; i < ids.length; ++i) {
            CVSOptionBuilder builder = this.createBuilder(ids[i]);
            if (this._contextUrls != null && !builder.isAvailable(this._contextUrls)) continue;
            builder.setCategory(category);
            builder.createComponents(this._resources);
            builder.populate(this._contextUrls, this._contextProperties);
            structure.addBuilder(builder);
        }
    }

    private CVSOptionBuilder createBuilder(CVSOptionId id) {
        return (CVSOptionBuilder)((CVSOptionBuilder)this._builderPrototypes.get((Object)id)).clone();
    }

    private void attachListeners(CVSOptionStructure structure) {
        CVSOptionId[] ids = structure.getOptionIds();
        for (int i = 0; i < ids.length; ++i) {
            structure.getBuilder(ids[i]).attachListeners(structure);
        }
    }

    public void repopulate(CVSOptionStructure structure) {
        for (CVSOptionId id : structure.getOptionIds()) {
            CVSOptionBuilder builder = structure.getBuilder(id);
            builder.populate(this._contextUrls, this._contextProperties);
        }
    }

    public static final CVSOptionId[] getRegisteredOptionIds() {
        return _builderMap.keySet().toArray(new CVSOptionId[0]);
    }

    static {
        _builderMap.put(CVSOptionId.COMMON_USE_REVISION, new CVSCommonUseRevisionBuilder());
        _builderMap.put(CVSOptionId.COMMON_USE_REVISION_OR_DATE, new CVSCommonUseRevisionOrDateBuilder());
        _builderMap.put(CVSOptionId.COMMON_USE_REVISION_OR_DATE_AND_FORCE, new CVSCommonUseRevisionOrDateBuilder2());
        _builderMap.put(CVSOptionId.COMMON_LOCAL_FOLDER_ONLY, new CVSCommonLocalFolderOnlyBuilder());
        _builderMap.put(CVSOptionId.COMMON_NO_MODULE_PROGRAMS, new CVSCommonNoModuleProgramsBuilder());
        _builderMap.put(CVSOptionId.TAG_TAG_NAME_CHOICE, new CVSTagTagNameChoiceBuilder());
        _builderMap.put(CVSOptionId.TAG_TAG_NAME, new CVSTagTagNameBuilder());
        _builderMap.put(CVSOptionId.TAG_CHECK_FOR_CHANGES, new CVSTagCheckForChangesBuilder());
        _builderMap.put(CVSOptionId.TAG_FORCE_TAG_MOVE, new CVSTagForceTagMoveBuilder());
        _builderMap.put(CVSOptionId.UPDATE_CLEAN_UPDATE, new CVSUpdateCleanUpdateBuilder());
        _builderMap.put(CVSOptionId.UPDATE_RESET_TAGS, new CVSUpdateResetTagsBuilder());
        _builderMap.put(CVSOptionId.UPDATE_CREATE_FOLDERS, new CVSUpdateCreateFoldersBuilder());
        _builderMap.put(CVSOptionId.UPDATE_PRUNE_FOLDERS, new CVSUpdatePruneFoldersBuilder());
        _builderMap.put(CVSOptionId.WATCH_COMMAND_TYPE, new CVSWatchCommandTypeBuilder());
        _builderMap.put(CVSOptionId.WATCH_SET_WATCH_ACTIONS, new CVSWatchSetWatchActionsBuilder());
        _builderMap.put(CVSOptionId.COMMIT_FORCE_COMMIT, new CVSCommitForceCommitBuilder());
    }
}

