/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.options;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSInternalClientSupport;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionArgument;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionCategory;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionException;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionId;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionLayoutBuilder;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionResources;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionStructure;

public abstract class CVSOptionBuilder
implements Cloneable {
    private static final String PROPERTY_BOOLEAN_STATE = "booleanState";
    private final CVSOptionId _id;
    private CVSOptionCategory _category;
    private JCheckBox _optionCheckBox;

    protected CVSOptionBuilder(CVSOptionId id) {
        this._id = id;
    }

    public CVSOptionId getId() {
        return this._id;
    }

    public Object clone() {
        throw new IllegalStateException();
    }

    public boolean isAvailable(URL[] contextUrls) {
        return true;
    }

    public void setCategory(CVSOptionCategory category) {
        this._category = category;
    }

    public CVSOptionCategory getCategory() {
        return this._category;
    }

    public int getLayoutRowCount() {
        return 1;
    }

    public Component getFocusComponent() {
        return this.getOptionComponent();
    }

    public Component getOptionComponent() {
        return this._optionCheckBox;
    }

    @Deprecated
    public boolean isSingleBoolean() {
        return true;
    }

    public void setBooleanState(boolean state) {
        if (this._optionCheckBox == null) {
            return;
        }
        if (!this._optionCheckBox.isEnabled()) {
            return;
        }
        this._optionCheckBox.setSelected(state);
        this._optionCheckBox.firePropertyChange(PROPERTY_BOOLEAN_STATE, !state, state);
    }

    public boolean getBooleanState() {
        return this._optionCheckBox != null ? this._optionCheckBox.isSelected() : true;
    }

    protected void populate(URL[] contextUrls, Map<String, String> contextProperties) {
        this.populate(contextUrls);
    }

    protected void populate(URL[] contextUrls) {
    }

    protected void dispose() {
    }

    protected void createComponents(CVSOptionResources resources) {
        this.createOptionComponent(resources);
    }

    protected void createOptionComponent(CVSOptionResources resources) {
        this._optionCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._optionCheckBox, (String)resources.getLabel(this.getId()));
    }

    protected void disableUnsupportedComponents(String command) {
    }

    protected void attachListeners(CVSOptionStructure structure) {
    }

    protected void buildLayout(CVSOptionLayoutBuilder layoutBuilder, Insets i) {
        if (this.getOptionComponent() == null) {
            return;
        }
        layoutBuilder.add(this.getOptionComponent(), i, 2, false, false);
        this.buildLayoutImpl(layoutBuilder, i);
        layoutBuilder.addHFiller();
        layoutBuilder.nl();
    }

    protected void buildLayoutImpl(CVSOptionLayoutBuilder layoutBuilder, Insets i) {
        layoutBuilder.addHFillerFixed();
    }

    protected void setValues(Map customizerOptions) {
        this.setBooleanState(customizerOptions.get((Object)this.getId()) == Boolean.TRUE);
        if (this.getBooleanState()) {
            this.setValuesImpl(customizerOptions);
        }
    }

    protected void validateValues() throws CVSOptionException {
        if (this.getBooleanState()) {
            this.validateValuesImpl();
        }
    }

    protected void commitValues(Map customizerOptions) {
        customizerOptions.put(this.getId(), this.getBooleanState() ? Boolean.TRUE : Boolean.FALSE);
        if (this.getBooleanState()) {
            this.commitValuesImpl(customizerOptions);
        }
    }

    protected void setValuesImpl(Map customizerOptions) {
    }

    protected void validateValuesImpl() throws CVSOptionException {
    }

    protected void commitValuesImpl(Map customizerOptions) {
    }

    protected boolean isSupportedOption(String command, CVSOptionId id) {
        return !CVSClient.getInstance().isUsingInternalClient() || CVSInternalClientSupport.isSupportedCommandOption(command, id);
    }

    protected boolean isSupportedOption(String command, CVSOptionArgument argument) {
        return !CVSClient.getInstance().isUsingInternalClient() || CVSInternalClientSupport.isSupportedCommandOption(command, argument);
    }

    protected void attachSlaveComponent(final Component slaveComponent) {
        if (this._optionCheckBox == null) {
            return;
        }
        this._optionCheckBox.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent ae) {
                CVSOptionBuilder.this.updateSlaveComponentEnabled(slaveComponent);
            }
        });
        this._optionCheckBox.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public final void propertyChange(PropertyChangeEvent pce) {
                if (pce.getPropertyName() != CVSOptionBuilder.PROPERTY_BOOLEAN_STATE) {
                    return;
                }
                CVSOptionBuilder.this.updateSlaveComponentEnabled(slaveComponent);
            }
        });
        this.updateSlaveComponentEnabled(slaveComponent);
    }

    protected boolean containsDirectoryURLs(URL[] contextUrls) {
        for (int i = 0; i < contextUrls.length; ++i) {
            if (!URLFileSystem.isDirectoryPath((URL)contextUrls[i])) continue;
            return true;
        }
        return false;
    }

    protected void updateSlaveComponentEnabled(Component component) {
        component.setEnabled(this.getBooleanState());
    }
}

