/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.op;

import java.io.IOException;
import java.net.URL;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.ide.vhv.VHVCustomizer;
import oracle.ide.vhv.VHVQuery;
import oracle.jdeveloper.vcs.cache.StatusCache;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdeveloper.vcs.versiontree.VersionTreeCommand;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSCommandConstants;
import oracle.jdevimpl.vcs.cvs.CVSFileStatus;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.CVSVHVQuery;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.op.CVSVHVCompareCommand;
import oracle.jdevimpl.vcs.cvs.op.CVSVHVCompareOtherCommand;

public class CVSOperationVHV
extends VersionTreeCommand {
    public CVSOperationVHV() {
        super(CVSCommandConstants.OPERATION_VHV_CMD_ID);
    }

    protected boolean isAvailableImpl(URL url) throws Exception {
        return super.isAvailableImpl(url) && !URLFileSystem.isDirectoryPath((URL)url);
    }

    protected StatusCache<VCSStatus> getStatusCacheBridge() {
        return CVSClient.getStatusCache();
    }

    protected VCSStatusFilter getStatusFilter() {
        return new VCSStatusFilter(){

            public boolean accept(VCSStatus status) {
                return status.isVersioned() && status != CVSFileStatus.STATUS_ADDED;
            }
        };
    }

    protected VHVQuery createQuery() {
        return new CVSVHVQuery();
    }

    protected VHVCustomizer createCustomizer() {
        VHVCustomizer customizer = new VHVCustomizer();
        customizer.setComparePreviousCommand(CVSVHVCompareCommand.class.getName());
        customizer.setCompareOtherCommand(CVSVHVCompareOtherCommand.class.getName());
        return customizer;
    }

    protected String getVersionPath(URL url) {
        try {
            String repository;
            StringBuilder versionPathBuffer = new StringBuilder();
            URL parentUrl = URLFileSystem.getParent((URL)url);
            CVSRootString root = CVSUtil.readAdminRoot(parentUrl);
            if (root != null) {
                repository = root.getRepository().replace('\\', '/');
                if (repository.matches("^\\p{Lower}:.*")) {
                    char[] chars = repository.toCharArray();
                    chars[0] = Character.toUpperCase(chars[0]);
                    repository = new String(chars);
                }
                versionPathBuffer.append(repository);
                versionPathBuffer.append('/');
            }
            if ((repository = CVSUtil.readRepository(parentUrl)) != null) {
                versionPathBuffer.append(repository);
                versionPathBuffer.append('/');
            }
            versionPathBuffer.append(URLFileSystem.getFileName((URL)url));
            return versionPathBuffer.toString();
        }
        catch (IOException ioe) {
            Assert.printStackTrace((Throwable)ioe);
            return URLFileSystem.getPlatformPathName((URL)url);
        }
    }
}

