/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.op;

import java.awt.Component;
import java.awt.EventQueue;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.ProductInformation;
import oracle.ide.controls.WaitCursor;
import oracle.ide.log.LogPrintWriter;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.jdeveloper.vcs.cache.Depth;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.spi.VCSCommandState;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSDialogCommitter;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokableState;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdeveloper.vcs.spi.VCSValidationException;
import oracle.jdeveloper.vcs.util.VCSBufferUtils;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSProcessUtils;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.cvs.CVSAbstractEditorCommand;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSCommandConstants;
import oracle.jdevimpl.vcs.cvs.CVSComponents;
import oracle.jdevimpl.vcs.cvs.CVSFileStatus;
import oracle.jdevimpl.vcs.cvs.CVSInternalClientSupport;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.error.CVSProcessException;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionCategory;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionDirector;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionId;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionStructure;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionsCustomizer;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcess;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcessStreamMonitor;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerFactory;
import oracle.jdevimpl.vcs.cvs.util.CVSDialogRunner;
import oracle.jdevimpl.vcs.cvs.util.CVSDirectoryInvokable;

public class CVSOperationUnedit
extends CVSAbstractEditorCommand {
    public CVSOperationUnedit() {
        super(CVSCommandConstants.OPERATION_UNEDIT_CMD_ID, VCSCommandStyle.MULTI);
    }

    protected VCSStatusFilter getStatusFilter() {
        return this.createStatusFilter(new VCSStatus[]{CVSFileStatus.STATUS_LOCALLY_CHANGED, CVSFileStatus.STATUS_UNMODIFIED_READWRITE, CVSFileStatus.STATUS_CONFLICTS, CVSFileStatus.STATUS_SANDBOX});
    }

    protected boolean isAvailableImpl() throws Exception {
        if (CVSClient.getInstance() == null) {
            return false;
        }
        if (CVSClient.getInstance().isUsingInternalClient() && !CVSInternalClientSupport.isSupportedCommand("unedit")) {
            return false;
        }
        Locatable[] locatables = this.getContextLocatables();
        if (!this.isOpenSessionSelection(locatables)) {
            return false;
        }
        return this.isAvailableImpl(locatables);
    }

    protected boolean isAvailableImpl(URL url) throws Exception {
        if (!URLFileSystem.exists((URL)url)) {
            return false;
        }
        return super.isAvailableImpl(url);
    }

    protected int doitImpl() throws Exception {
        Collection nodesPreCoalesce = this.getFilteredSelection();
        Collection nodes = this.coalesceNodesForFolderOperation(nodesPreCoalesce);
        if (nodes.size() <= 0) {
            return 9;
        }
        CVSUtil.saveDirtyNodesSilently(nodes);
        Map timestampMap = VCSBufferUtils.storeTimestamps((Collection)nodes);
        VCSDirectoryInvokableState invokableState = new VCSDirectoryInvokableState(VCSModelUtils.convertNodesToURLs((Collection)nodes));
        VCSCommandState state = new VCSCommandState(invokableState, timestampMap);
        if (this.getContext().getView() instanceof ChangeListWindow) {
            return this.uneditSilently(nodes, state);
        }
        return this.unedit(nodes, state);
    }

    protected void noOpImpl() throws VCSValidationException {
        throw new VCSValidationException(CVSArb.get("ERROR_UNEDIT_FILTERED_TITLE"), CVSArb.format("ERROR_UNEDIT_FILTERED", ProductInformation.getProductInformation().getShortName()));
    }

    private int uneditSilently(final Collection nodes, final VCSCommandState state) {
        boolean doIt = false;
        doIt = nodes.size() == 1 ? MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)CVSArb.format("UNEDIT_CONFIRM_MESSAGE_FILE", URLFileSystem.getFileName((URL)((Locatable)nodes.iterator().next()).getURL())), (String)CVSArb.get("UNEDIT_CONFIRM_TITLE"), null, (boolean)true) : MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)CVSArb.get("UNEDIT_CONFIRM_MESSAGE_MISC"), (String)CVSArb.get("UNEDIT_CONFIRM_TITLE"), null, (boolean)true);
        if (doIt) {
            final WaitCursor wc = new WaitCursor((Component)Ide.getMainWindow());
            wc.show();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        CVSOperationUnedit.this.doCommitOperationImpl((Component)Ide.getMainWindow(), null, state);
                    }
                    catch (Exception e) {
                        try {
                            CVSOperationUnedit.this.getExceptionHandler().handleException(e, (Component)Ide.getMainWindow());
                        }
                        catch (Throwable throwable) {
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    wc.hide();
                                    try {
                                        CVSOperationUnedit.this.postUnedit(nodes, state);
                                    }
                                    catch (Exception e) {
                                        CVSOperationUnedit.this.getExceptionHandler().handleException(e, (Component)Ide.getMainWindow());
                                    }
                                }
                            });
                            throw throwable;
                        }
                        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                    EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            };
            Thread t = new Thread(r, "CVSOperationUnedit");
            t.start();
            return 0;
        }
        return 1;
    }

    private int unedit(Collection nodes, final VCSCommandState state) {
        CVSOptionsCustomizer customizer = this.createOptionsCustomizer(nodes.toArray(new Locatable[0]));
        final JEWTDialog dialog = VCSComponents.createOperationDialog((Component)VCSWindowUtils.getCurrentWindow(), (String)CVSArb.get("UNEDIT_CAPTION"), (String)CVSArb.get("UNEDIT_LONG_PROMPT"), (Component)CVSComponents.createFileListerComponent(nodes), (Component)(customizer != null ? customizer.getComponent() : null), (String)"f1_cvsuneditfiles_html", (Component)(customizer != null ? customizer.getInitialFocusComponent() : null));
        dialog.addVetoableChangeListener((VetoableChangeListener)new VCSDialogCommitter(customizer){

            protected final boolean doCommitOperation(Map options) throws Exception {
                return CVSOperationUnedit.this.doCommitOperationImpl((Component)dialog, options, state);
            }
        });
        boolean dialogSuccessful = CVSDialogRunner.runDialog((JDialog)dialog);
        this.postUnedit(nodes, state);
        return !dialogSuccessful ? 1 : 0;
    }

    private void postUnedit(Collection nodes, VCSCommandState state) {
        Collection processedUrls = state.getInvokableState().getProcessedURLs();
        CVSClient.getInstance();
        CVSClient.getStatusCache().clear(processedUrls.toArray(new URL[0]), Depth.INFINITY);
        if (processedUrls.size() > 0) {
            VCSBufferUtils.reloadBuffers((Map)state.getTimestampMap());
        }
    }

    private CVSOptionsCustomizer createOptionsCustomizer(Locatable[] contextLocatables) {
        CVSOptionStructure optionStructure;
        CVSOptionDirector optionDirector = new CVSOptionDirector(contextLocatables);
        optionDirector.registerCategoryOptions(CVSOptionCategory.BASIC, new CVSOptionId[]{CVSOptionId.COMMON_LOCAL_FOLDER_ONLY});
        optionDirector.registerCategoryOptions(CVSOptionCategory.ADVANCED, new CVSOptionId[0]);
        if (!CVSClient.getInstance().isAdvancedModeSet()) {
            optionDirector.deregisterCategoryOptions(CVSOptionCategory.ADVANCED);
        }
        if ((optionStructure = optionDirector.constructOptionComponents()).getOptionIds().length <= 0) {
            return null;
        }
        return new CVSOptionsCustomizer(optionStructure);
    }

    private boolean doCommitOperationImpl(Component dialog, Map optionsMap, VCSCommandState state) throws Exception {
        DeterminateProgressMonitor monitor = new DeterminateProgressMonitor(dialog, CVSArb.get("UNEDIT_PROGRESS_TITLE"), (Object)CVSArb.get("UNEDIT_WATCHER_DESCRIPTION"), "", 0, -1);
        final CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        runner.setCommand_("unedit");
        runner.getParameters().setQuiet(false);
        if (optionsMap != null) {
            runner.getParameters().setBuilderOptions(optionsMap);
        }
        runner.addOutputMonitor(new RevertPromptMonitor());
        state.setInvokableState(this.coalesceStateForFolderOperation(optionsMap, state.getInvokableState()));
        CVSDirectoryInvokable invokable = new CVSDirectoryInvokable(state.getInvokableState()){

            @Override
            protected final boolean doInvocation2(URL parent, URL[] invokeUrls) throws Exception {
                String[] filenames = VCSFileSystemUtils.getURLFileNames((URL[])invokeUrls);
                runner.setDirURL_(parent);
                runner.getParameters().setFiles(Arrays.asList(filenames));
                CVSOperationUnedit.this.doInvocationImpl(runner);
                return true;
            }
        };
        invokable.setProgressMonitor(monitor);
        return invokable.runInvokable();
    }

    private void doInvocationImpl(CVSRunner runner) throws Exception {
        runner.exec_();
        if (runner.getExitCode_() != null && runner.getExitCode_() == 0) {
            return;
        }
        throw new CVSProcessException(CVSArb.get("ERROR_UNEDIT_FAILED"), runner.getErrorText_());
    }

    public static final class RevertPromptMonitor
    extends CVSProcessStreamMonitor {
        public RevertPromptMonitor() {
            super("revert changes?");
        }

        @Override
        protected void patternMatched(CVSProcess process) throws Exception {
            LogPrintWriter writer;
            process.waitForRedirectOutput();
            String input = "y";
            CVSClient client = CVSClient.getInstance();
            if (client != null && (writer = client.getLogWriter()) != null) {
                writer.println("<<< " + input);
            }
            VCSProcessUtils.sendInputData((Process)process.getProcess(), (String)input);
        }
    }
}

