/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.op;

import java.awt.Component;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.ProductInformation;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.jdeveloper.vcs.cache.Depth;
import oracle.jdeveloper.vcs.spi.VCSCommandState;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSDialogCommitter;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokableState;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSValidationException;
import oracle.jdeveloper.vcs.util.VCSBufferUtils;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.cvs.CVSAbstractCommand;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSCommandConstants;
import oracle.jdevimpl.vcs.cvs.CVSComponents;
import oracle.jdevimpl.vcs.cvs.CVSEntriesCache;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.client.CVSEntry;
import oracle.jdevimpl.vcs.cvs.error.CVSProcessException;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionCategory;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionDirector;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionId;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionsCustomizer;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerFactory;
import oracle.jdevimpl.vcs.cvs.util.CVSDialogRunner;
import oracle.jdevimpl.vcs.cvs.util.CVSDirectoryInvokable;

public class CVSOperationResetTags
extends CVSAbstractCommand
implements CVSCommandConstants {
    public CVSOperationResetTags() {
        super(OPERATION_RESET_TAGS_CMD_ID, VCSCommandStyle.MULTI);
    }

    protected boolean isAvailableImpl() throws Exception {
        Locatable[] locatables = this.getContextLocatables();
        if (!this.isOpenSessionSelection(locatables)) {
            return false;
        }
        return this.isAvailableImpl(locatables);
    }

    protected boolean isAvailableImpl(URL url) throws Exception {
        if (!URLFileSystem.exists((URL)url)) {
            return false;
        }
        CVSClient.getInstance();
        VCSStatus status = (VCSStatus)CVSClient.getStatusCache().get(url);
        if (!status.isVersioned()) {
            return false;
        }
        return this.hasTagsToReset(url);
    }

    protected int doitImpl() throws Exception {
        Collection nodesPreCoalesce = this.getFilteredSelectionResetTags();
        Collection nodes = this.coalesceNodesForFolderOperation(nodesPreCoalesce);
        if (nodes.size() <= 0) {
            return 9;
        }
        Node[] affectedNodes = CVSUtil.getCachedBaseURLNodes(VCSModelUtils.convertNodesToURLs((Collection)nodes));
        CVSOptionsCustomizer customizer = this.createOptionsCustomizer(nodes.toArray(new Locatable[0]));
        final JEWTDialog dialog = VCSComponents.createOperationDialog((Component)VCSWindowUtils.getCurrentWindow(), (String)CVSArb.get("RESET_TAGS_CAPTION"), (String)CVSArb.get("RESET_TAGS_LONG_PROMPT"), (Component)CVSComponents.createFileListerComponent(nodes), (Component)(customizer != null ? customizer.getComponent() : null), (String)"f1_cvsresettags_html", (Component)(customizer != null ? customizer.getInitialFocusComponent() : null));
        Map timestampMap = VCSBufferUtils.storeTimestamps(Arrays.asList(affectedNodes));
        VCSDirectoryInvokableState invokableState = new VCSDirectoryInvokableState(VCSModelUtils.convertNodesToURLs((Collection)nodes));
        final VCSCommandState state = new VCSCommandState(invokableState, timestampMap);
        dialog.addVetoableChangeListener((VetoableChangeListener)new VCSDialogCommitter(customizer){

            protected final boolean doCommitOperation(Map options) throws Exception {
                return CVSOperationResetTags.this.doCommitOperationImpl((Component)dialog, options, state);
            }
        });
        boolean dialogSuccessful = CVSDialogRunner.runDialog((JDialog)dialog);
        Collection processedUrls = state.getInvokableState().getProcessedURLs();
        CVSClient.getInstance();
        CVSClient.getStatusCache().clear(processedUrls.toArray(new URL[0]), Depth.INFINITY);
        if (processedUrls.size() > 0) {
            VCSBufferUtils.reloadBuffers((Map)timestampMap);
        }
        return !dialogSuccessful ? 1 : 0;
    }

    protected void noOpImpl() throws VCSValidationException {
        throw new VCSValidationException(CVSArb.get("ERROR_RESET_TAGS_FILTERED_TITLE"), CVSArb.format("ERROR_RESET_TAGS_FILTERED", ProductInformation.getProductInformation().getShortName()));
    }

    private CVSOptionsCustomizer createOptionsCustomizer(Locatable[] contextLocatables) {
        CVSOptionDirector optionDirector = new CVSOptionDirector(contextLocatables);
        optionDirector.registerCategoryOptions(CVSOptionCategory.BASIC, new CVSOptionId[]{CVSOptionId.COMMON_LOCAL_FOLDER_ONLY});
        optionDirector.registerCategoryOptions(CVSOptionCategory.ADVANCED, new CVSOptionId[0]);
        if (!CVSClient.getInstance().isAdvancedModeSet()) {
            optionDirector.deregisterCategoryOptions(CVSOptionCategory.ADVANCED);
        }
        CVSOptionsCustomizer customizer = new CVSOptionsCustomizer(optionDirector.constructOptionComponents());
        HashMap<CVSOptionId, Boolean> defaultOptionsValues = new HashMap<CVSOptionId, Boolean>();
        defaultOptionsValues.put(CVSOptionId.UPDATE_CREATE_FOLDERS, Boolean.TRUE);
        defaultOptionsValues.put(CVSOptionId.UPDATE_PRUNE_FOLDERS, Boolean.TRUE);
        customizer.setDefaultOptionValues(defaultOptionsValues);
        return customizer;
    }

    private boolean doCommitOperationImpl(Component dialog, Map optionsMap, VCSCommandState state) throws Exception {
        DeterminateProgressMonitor monitor = new DeterminateProgressMonitor(dialog, CVSArb.get("RESET_TAGS_PROGRESS_TITLE"), (Object)CVSArb.get("RESET_TAGS_WATCHER_DESCRIPTION"), "", 0, -1);
        final CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        ArrayList<String> opts = new ArrayList<String>();
        opts.add("-A");
        runner.setCommand_("update");
        runner.getParameters().setQuiet(false);
        if (optionsMap != null) {
            runner.getParameters().setBuilderOptions(optionsMap);
        }
        runner.getParameters().setOptions(opts);
        state.setInvokableState(this.coalesceStateForFolderOperation(optionsMap, state.getInvokableState()));
        CVSDirectoryInvokable invokable = new CVSDirectoryInvokable(state.getInvokableState()){

            @Override
            protected final boolean doInvocation2(URL parent, URL[] invokeUrls) throws Exception {
                String[] filenames = VCSFileSystemUtils.getURLFileNames((URL[])invokeUrls);
                runner.setDirURL_(parent);
                runner.getParameters().setFiles(Arrays.asList(filenames));
                CVSOperationResetTags.this.doInvocationImpl(runner);
                return true;
            }
        };
        invokable.setProgressMonitor(monitor);
        return invokable.runInvokable();
    }

    private void doInvocationImpl(CVSRunner runner) throws Exception {
        runner.exec_();
        if (runner.getExitCode_() != null && runner.getExitCode_() == 0) {
            return;
        }
        throw new CVSProcessException(CVSArb.get("ERROR_RESET_TAGS_FAILED"), runner.getErrorText_());
    }

    private Collection getFilteredSelectionResetTags() throws IOException {
        Locatable[] locatables = this.getContextLocatables();
        URL[] urls = VCSModelUtils.convertNodesToURLs((Locatable[])locatables);
        ArrayList<Locatable> nodes = new ArrayList<Locatable>();
        for (int i = 0; i < urls.length; ++i) {
            if (!this.hasTagsToReset(urls[i])) continue;
            nodes.add(locatables[i]);
        }
        return nodes;
    }

    private boolean hasTagsToReset(URL url) throws IOException {
        URL parent = URLFileSystem.getParent((URL)url);
        CVSEntry entry = CVSEntriesCache.findEntry(CVSEntriesCache.getInstance().getEntriesMap(parent != null ? parent : url), url);
        if (entry == null) {
            return false;
        }
        if (URLFileSystem.isDirectoryPath((URL)url)) {
            return true;
        }
        String options = entry.getOptions();
        if (options != null && !options.equals("")) {
            return true;
        }
        return entry.hasStickyTag() || entry.hasStickyDate();
    }
}

