/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.op;

import java.awt.Component;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.ProductInformation;
import oracle.ide.config.Preferences;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.jdeveloper.vcs.cache.Depth;
import oracle.jdeveloper.vcs.spi.VCSCommandState;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSDialogCommitter;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokableState;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdeveloper.vcs.spi.VCSValidationException;
import oracle.jdeveloper.vcs.util.VCSBufferUtils;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSURLFilters;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.cvs.CVSChangeListWindow;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSCommandConstants;
import oracle.jdevimpl.vcs.cvs.CVSCommandOptionsPrefs;
import oracle.jdevimpl.vcs.cvs.CVSComponents;
import oracle.jdevimpl.vcs.cvs.CVSEntriesCache;
import oracle.jdevimpl.vcs.cvs.CVSFileStatus;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.client.CVSEntriesFile;
import oracle.jdevimpl.vcs.cvs.client.CVSEntry;
import oracle.jdevimpl.vcs.cvs.error.CVSOperationException;
import oracle.jdevimpl.vcs.cvs.error.CVSProcessException;
import oracle.jdevimpl.vcs.cvs.op.CVSAbstractReplaceOperation;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionArgument;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionId;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerFactory;
import oracle.jdevimpl.vcs.cvs.util.CVSDialogRunner;
import oracle.jdevimpl.vcs.cvs.util.CVSDirectoryInvokable;
import oracle.jdevimpl.vcs.cvs.util.CVSListFilesUtil;

public class CVSOperationReplacePrevious
extends CVSAbstractReplaceOperation
implements CVSCommandConstants {
    private static final VCSStatusFilter sVersionFilter = new VCSStatusFilter(){

        public boolean accept(VCSStatus status) {
            return status != null && status == CVSFileStatus.STATUS_LOCALLY_CHANGED && status != CVSFileStatus.STATUS_REMOVED;
        }
    };

    public CVSOperationReplacePrevious() {
        super(OPERATION_REPLACE_PREVIOUS_CMD_ID, VCSCommandStyle.MULTI);
    }

    public CVSOperationReplacePrevious(int cmdId) {
        super(cmdId, VCSCommandStyle.MULTI);
    }

    protected boolean isAvailableImpl() throws Exception {
        Locatable[] locatables = this.getContextLocatables();
        return this.isOpenSessionSelection(locatables) && this.isAvailableImpl(locatables);
    }

    protected boolean isAvailableImpl(URL url) throws Exception {
        Node[] nodes = VCSModelUtils.findCachedNodes((URLFilter)VCSURLFilters.createSpecificURLFilter((URL[])new URL[]{url}));
        if (nodes != null && nodes.length > 0) {
            return nodes[0].isDirty() || super.isAvailableImpl(url);
        }
        return super.isAvailableImpl(url);
    }

    protected int doitImpl() throws Exception {
        Locatable[] locatables = this.getContextLocatables();
        Node[] affectedNodes = CVSUtil.getCachedBaseURLNodes(VCSModelUtils.convertNodesToURLs((Locatable[])locatables));
        ArrayList<Node> dirtyNodes = new ArrayList<Node>(10);
        ArrayList<Node> cleanNodes = new ArrayList<Node>(10);
        for (int i = 0; i < affectedNodes.length; ++i) {
            if (affectedNodes[i].isDirty()) {
                dirtyNodes.add(affectedNodes[i]);
                continue;
            }
            cleanNodes.add(affectedNodes[i]);
        }
        Collection filteredCleanNodes = this.getFilteredSelection(cleanNodes.toArray(new Locatable[cleanNodes.size()]), new VCSStatus[]{CVSFileStatus.STATUS_LOCALLY_CHANGED});
        ArrayList allAffectedNodes = new ArrayList(dirtyNodes);
        allAffectedNodes.addAll(filteredCleanNodes);
        if (allAffectedNodes.isEmpty()) {
            return 9;
        }
        VCSCommandState cmdState = new VCSCommandState(new VCSDirectoryInvokableState(VCSModelUtils.convertNodesToURLs(allAffectedNodes)), VCSBufferUtils.storeTimestamps(Arrays.asList(affectedNodes)));
        return this.replace(allAffectedNodes, affectedNodes, cmdState);
    }

    protected VCSStatusFilter getStatusFilter() {
        return sVersionFilter;
    }

    private int replace(Collection nodes, Node[] affectedNodes, final VCSCommandState state) throws Exception {
        final JEWTDialog dialog = this.createOperationDialog(nodes);
        dialog.addVetoableChangeListener((VetoableChangeListener)new VCSDialogCommitter(null){

            protected final boolean doCommitOperation(Map options) throws Exception {
                return CVSOperationReplacePrevious.this.doReplaceOperation((Component)dialog, options, state);
            }
        });
        boolean success = CVSDialogRunner.runDialog((JDialog)dialog);
        this.postReplace(state, affectedNodes);
        return success ? 0 : 1;
    }

    private void postReplace(VCSCommandState state, Node[] affectedNodes) throws Exception {
        Collection processedUrls = state.getInvokableState().getProcessedURLs();
        URL[] processedUrlArray = processedUrls.toArray(new URL[processedUrls.size()]);
        this.fireSomeFilesDeleted(processedUrlArray);
        CVSClient.getInstance();
        CVSClient.getStatusCache().clear(processedUrlArray, Depth.INFINITY);
        if (processedUrls.size() > 0) {
            VCSBufferUtils.reloadBuffers((Map)state.getTimestampMap());
        }
        if (this.getContext().getView() instanceof CVSChangeListWindow) {
            ((CVSChangeListWindow)this.getContext().getView()).getIncomingChangeList().refresh();
        }
    }

    private boolean doReplaceOperation(Component dialog, Map options, VCSCommandState state) throws Exception {
        final HashMap<CVSOptionId, Boolean> opts = new HashMap<CVSOptionId, Boolean>(10);
        opts.put(CVSOptionId.UPDATE_CLEAN_UPDATE, Boolean.TRUE);
        opts.put(CVSOptionId.UPDATE_CREATE_FOLDERS, Boolean.TRUE);
        opts.put(CVSOptionId.UPDATE_PRUNE_FOLDERS, Boolean.TRUE);
        final CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        runner.setCommand_("update");
        runner.getParameters().setQuiet(false);
        runner.getParameters().setBuilderOptions(opts);
        CVSDirectoryInvokable invokable = new CVSDirectoryInvokable(state.getInvokableState()){

            @Override
            protected boolean doInvocation2(URL parent, URL[] invokeUrls) throws Exception {
                CVSEntry entry;
                if (invokeUrls == null || invokeUrls.length == 0) {
                    List<URL> c = CVSListFilesUtil.listFiles(parent, 1);
                    invokeUrls = c.toArray(new URL[c.size()]);
                }
                CVSEntriesFile entriesFile = new CVSEntriesFile(parent);
                Collection<CVSEntry> entries = entriesFile.getEntries();
                ArrayList<URL> entriesToUpdate = new ArrayList<URL>();
                for (int i = 0; i < invokeUrls.length; ++i) {
                    File f;
                    Boolean renameOnRemove = CVSCommandOptionsPrefs.getInstance((PropertyStorage)Preferences.getPreferences()).getRenameOnRemove();
                    if (renameOnRemove != null && renameOnRemove.booleanValue() && CVSOperationReplacePrevious.this.getStatusCache().get(invokeUrls[i]) == CVSFileStatus.STATUS_LOCALLY_CHANGED) {
                        entry = CVSEntriesFile.findEntry(entries, invokeUrls[i]);
                        URL renameUrl = URLFactory.newURL((URL)parent, (String)(".#" + URLFileSystem.getFileName((URL)invokeUrls[i]) + "." + (entry != null ? entry.getRevision() : "backup")));
                        if (URLFileSystem.exists((URL)renameUrl)) {
                            URLFileSystem.delete((URL)renameUrl);
                        }
                        URLFileSystem.copy((URL)invokeUrls[i], (URL)renameUrl);
                    }
                    if (!(f = new File(URLFileSystem.getPlatformPathName((URL)invokeUrls[i]))).delete()) {
                        throw new CVSOperationException(CVSArb.get("ERROR_UTIL_CLEAN_DELETE_FAILED"));
                    }
                    CVSEntry entry2 = CVSEntriesFile.findEntry(entries, invokeUrls[i]);
                    if (entry2 != null && !entry2.hasStickyDate() && !entry2.hasStickyTag()) {
                        opts.put(CVSOptionId.COMMON_USE_REVISION, Boolean.TRUE);
                        opts.put(CVSOptionArgument.REVISION_NAME, entry2.getRevision());
                        entriesToUpdate.add(invokeUrls[i]);
                    }
                    runner.setDirURL_(parent);
                    runner.getParameters().setFile(URLFileSystem.getFileName((URL)invokeUrls[i]));
                    runner.exec_();
                    if (runner.getExitCode_() == null || runner.getExitCode_() >= 0) continue;
                    throw new CVSProcessException(CVSArb.get("ERROR_REPLACE_FAILED"), runner.getErrorText_());
                }
                if (!entriesToUpdate.isEmpty()) {
                    entries = entriesFile.getEntries();
                    for (URL entryToUpdate : entriesToUpdate) {
                        entry = CVSEntriesFile.findEntry(entries, entryToUpdate);
                        if (entry == null) continue;
                        CVSEntry newEntry = new CVSEntry(null, entry.isDirectory(), entry.getName(), entry.getStateFlag(), entry.getRevision(), entry.getTimestamp(), entry.getConflictFlag(), entry.getConflict(), entry.getOptions(), null, null);
                        entries.remove(entry);
                        entries.add(newEntry);
                    }
                    entriesFile.writeEntries(entries);
                    CVSEntriesCache.getInstance().clear();
                }
                return true;
            }
        };
        invokable.setProgressMonitor(this.createProgressMonitor(dialog));
        return invokable.runInvokable();
    }

    private DeterminateProgressMonitor createProgressMonitor(Component parent) {
        return new DeterminateProgressMonitor(parent, CVSArb.get("REPLACE_PROGRESS_TITLE"), (Object)CVSArb.get("REPLACE_WATCHER_DESCRIPTION"), "", 0, -1);
    }

    protected JEWTDialog createOperationDialog(Collection nodes) {
        return VCSComponents.createOperationDialog((Component)VCSWindowUtils.getCurrentWindow(), (String)CVSArb.get("REPLACE_PREVIOUS_CAPTION"), (String)CVSArb.get("REPLACE_PREVIOUS_LONG_PROMPT"), (Component)CVSComponents.createFileListerComponent(nodes, false), null, (String)"f1_cvsreplaceprevious_html");
    }

    protected void noOpImpl() throws VCSValidationException {
        throw new VCSValidationException(CVSArb.get("ERROR_REPLACE_PREVIOUS_FILTERED_TITLE"), CVSArb.format("ERROR_REPLACE_PREVIOUS_FILTERED", ProductInformation.getProductInformation().getShortName()));
    }
}

