/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.op;

import java.awt.Component;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.jdeveloper.vcs.cache.Depth;
import oracle.jdeveloper.vcs.spi.VCSCommandState;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSDialogCommitter;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokableState;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.util.VCSBufferUtils;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.cvs.CVSChangeListWindow;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSCommandConstants;
import oracle.jdevimpl.vcs.cvs.CVSComponents;
import oracle.jdevimpl.vcs.cvs.CVSFileStatus;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.error.CVSProcessException;
import oracle.jdevimpl.vcs.cvs.op.CVSAbstractReplaceOperation;
import oracle.jdevimpl.vcs.cvs.op.CVSOperationUpdate;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionId;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerFactory;
import oracle.jdevimpl.vcs.cvs.util.CVSDialogRunner;
import oracle.jdevimpl.vcs.cvs.util.CVSDirectoryInvokable;

public class CVSOperationReplaceHead
extends CVSAbstractReplaceOperation
implements CVSCommandConstants {
    public CVSOperationReplaceHead() {
        super(OPERATION_REPLACE_HEAD_CMD_ID, VCSCommandStyle.MULTI);
    }

    protected int doitImpl() throws Exception {
        Locatable[] locatables = this.getContextLocatables();
        Node[] affectedNodes = CVSUtil.getCachedBaseURLNodes(VCSModelUtils.convertNodesToURLs((Locatable[])locatables));
        if (!CVSUtil.saveDirtyNodes(Arrays.asList(affectedNodes))) {
            return 1;
        }
        Collection nodes = this.getFilteredSelection(locatables, new VCSStatus[]{CVSFileStatus.STATUS_LOCALLY_CHANGED, CVSFileStatus.STATUS_CONFLICTS, CVSFileStatus.STATUS_REMOVED, CVSFileStatus.STATUS_UNMODIFIED_READONLY, CVSFileStatus.STATUS_UNMODIFIED_READWRITE});
        if (nodes.isEmpty()) {
            return 9;
        }
        Map timestamps = VCSBufferUtils.storeTimestamps(Arrays.asList(affectedNodes));
        VCSDirectoryInvokableState invokableState = new VCSDirectoryInvokableState(VCSModelUtils.convertNodesToURLs((Collection)nodes));
        VCSCommandState cmdState = new VCSCommandState(invokableState, timestamps);
        return this.replace(nodes, affectedNodes, cmdState, null);
    }

    protected boolean isAvailableImpl() throws Exception {
        Locatable[] locatables = this.getContextLocatables();
        return this.isOpenSessionSelection(locatables) && this.isAvailableImpl(locatables);
    }

    protected boolean isAvailableImpl(URL url) throws Exception {
        if (!super.isAvailableImpl(url)) {
            return false;
        }
        if (!URLFileSystem.exists((URL)url)) {
            return false;
        }
        CVSClient.getInstance();
        VCSStatus status = (VCSStatus)CVSClient.getStatusCache().get(url);
        return status.isVersioned();
    }

    private int replace(Collection nodes, Node[] affectedNodes, final VCSCommandState state, VCSOptionsCustomizer customizer) throws Exception {
        final JEWTDialog dialog = this.createOperationDialog(nodes);
        dialog.addVetoableChangeListener((VetoableChangeListener)new VCSDialogCommitter(customizer){

            protected final boolean doCommitOperation(Map options) throws Exception {
                return CVSOperationReplaceHead.this.doReplaceOperation((Component)dialog, options, state);
            }
        });
        boolean success = CVSDialogRunner.runDialog((JDialog)dialog);
        this.postReplace(state, affectedNodes);
        return success ? 0 : 1;
    }

    private boolean doReplaceOperation(Component dialog, Map options, VCSCommandState state) throws Exception {
        options = new HashMap<CVSOptionId, Boolean>(10);
        options.put(CVSOptionId.UPDATE_CLEAN_UPDATE, Boolean.TRUE);
        options.put(CVSOptionId.UPDATE_CREATE_FOLDERS, Boolean.TRUE);
        options.put(CVSOptionId.UPDATE_PRUNE_FOLDERS, Boolean.TRUE);
        ArrayList<URL> urls = new ArrayList<URL>(Arrays.asList(state.getInvokableState().getURLs()));
        CVSOperationUpdate.DeletionOrderComparator comparator = new CVSOperationUpdate.DeletionOrderComparator();
        Collections.sort(urls, comparator);
        CVSUtil.deleteFiles(true, comparator, urls.toArray(new URL[0]));
        final CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        runner.setCmdArray_(new String[]{"update", "-AC"});
        runner.getParameters().setQuiet(false);
        runner.getParameters().setBuilderOptions(options);
        CVSDirectoryInvokable invokable = new CVSDirectoryInvokable(state.getInvokableState()){

            @Override
            protected boolean doInvocation2(URL parent, URL[] invokeUrls) throws Exception {
                String[] fileNames = VCSFileSystemUtils.getURLFileNames((URL[])invokeUrls);
                runner.setDirURL_(parent);
                runner.getParameters().setFiles(Arrays.asList(fileNames));
                runner.exec_();
                if (runner.getExitCode_() != null && runner.getExitCode_() == 0) {
                    return true;
                }
                throw new CVSProcessException(CVSArb.get("ERROR_REPLACE_FAILED"), runner.getErrorText_());
            }
        };
        invokable.setProgressMonitor(this.createProgressMonitor(dialog));
        return invokable.runInvokable();
    }

    private void postReplace(VCSCommandState state, Node[] affectedNodes) throws Exception {
        Collection processedUrls = state.getInvokableState().getProcessedURLs();
        URL[] processedUrlArray = processedUrls.toArray(new URL[processedUrls.size()]);
        this.fireSomeFilesDeleted(processedUrlArray);
        CVSClient.getInstance();
        CVSClient.getStatusCache().clear(processedUrlArray, Depth.INFINITY);
        if (processedUrls.size() > 0) {
            VCSBufferUtils.reloadBuffers((Map)state.getTimestampMap());
        }
        if (this.getContext().getView() instanceof CVSChangeListWindow) {
            ((CVSChangeListWindow)this.getContext().getView()).getIncomingChangeList().refresh();
        }
    }

    private JEWTDialog createOperationDialog(Collection nodes) {
        return VCSComponents.createOperationDialog((Component)VCSWindowUtils.getCurrentWindow(), (String)CVSArb.get("REPLACE_HEAD_CAPTION"), (String)CVSArb.get("REPLACE_HEAD_LONG_PROMPT"), (Component)CVSComponents.createFileListerComponent(nodes, false), null, (String)"f1_cvsreplacehead_html");
    }

    private DeterminateProgressMonitor createProgressMonitor(Component parent) {
        return new DeterminateProgressMonitor(parent, CVSArb.get("REPLACE_PROGRESS_TITLE"), (Object)CVSArb.get("REPLACE_WATCHER_DESCRIPTION"), "", 0, -1);
    }
}

