/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.op;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Frame;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.history.HistoryComponent;
import oracle.javatools.history.HistoryEntry;
import oracle.javatools.history.HistoryModel;
import oracle.jdeveloper.history.HistoryContext;
import oracle.jdeveloper.history.HistoryFilter;
import oracle.jdeveloper.history.HistoryManager;
import oracle.jdeveloper.history.RevisionIdentifier;
import oracle.jdeveloper.history.SharedProperties;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdevimpl.vcs.cvs.CVSAbstractCommand;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSCommandConstants;
import oracle.jdevimpl.vcs.cvs.CVSFileStatus;
import oracle.jdevimpl.vcs.cvs.CVSResourcePicker;
import oracle.jdevimpl.vcs.cvs.CVSRootCache;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodeUtils;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.ui.CVSOpenRevisionDialogUI;
import oracle.jdevimpl.vcs.cvs.util.CVSDialogRunner;

public class CVSOperationOpenRevision
extends CVSAbstractCommand
implements CVSCommandConstants {
    public CVSOperationOpenRevision() {
        super(OPERATION_OPEN_REVISION_CMD_ID, VCSCommandStyle.SINGLE);
    }

    protected CVSOperationOpenRevision(int id) {
        super(id, VCSCommandStyle.SINGLE);
    }

    protected boolean isAvailableImpl(Locatable locatable) throws Exception {
        if (CVSConnectionNodeUtils.getFileNodeClass().isInstance(locatable)) {
            return true;
        }
        if (!this.isOpenSessionSelection(new Locatable[]{locatable})) {
            return false;
        }
        return super.isAvailableImpl(locatable);
    }

    protected boolean isAvailableImpl(URL url) throws Exception {
        if (!URLFileSystem.exists((URL)url)) {
            return false;
        }
        CVSClient.getInstance();
        VCSStatus status = (VCSStatus)CVSClient.getStatusCache().get(url);
        if (status == CVSFileStatus.STATUS_SANDBOX) {
            return false;
        }
        return status.isVersioned() && status != CVSFileStatus.STATUS_ADDED && status != CVSFileStatus.STATUS_REMOVED;
    }

    protected int doitImpl() throws Exception {
        if (CVSConnectionNodeUtils.getFileNodeClass().isInstance(this.getContext().getNode())) {
            CVSOperationOpenRevision.openDefaultEditorInFrameLater(this.context);
            return 0;
        }
        URL url = this.getContextLocatables()[0].getURL();
        HistoryModel model = HistoryManager.getHistoryManager().buildModel(url, false, new HistoryFilter(){

            public boolean accept(HistoryEntry entry) {
                return true;
            }

            public String getShortLabel() {
                return CVSArb.get("LOG_FILTER_CVS_REVISIONS");
            }
        });
        final HistoryComponent component = HistoryManager.getHistoryManager().createHistoryComponent(model);
        final JEWTDialog dialog = new JEWTDialog((Frame)Ide.getMainWindow(), CVSArb.format("OPEN_REVISION_TITLE", URLFileSystem.getFileName((URL)url)), 7);
        CVSOpenRevisionDialogUI ui = new CVSOpenRevisionDialogUI();
        CVSResourcePicker.get().start((Container)ui);
        ui.getTablePanel().setLayout(new BorderLayout());
        ui.getTablePanel().add((Component)component, "Center");
        ui.getHintLabel().setLabelFor((Component)component);
        dialog.setResizable(true);
        dialog.setPreferredSize(700, 500);
        dialog.setContent((Component)ui);
        HelpSystem.getHelpSystem().registerTopic((JComponent)ui, "f1_cvsopenrevision_html");
        component.addListSelectionListener(new ListSelectionListener(){

            @Override
            public final void valueChanged(ListSelectionEvent e) {
                CVSOperationOpenRevision.this.updateOKEnabled(dialog, component);
            }
        });
        this.updateOKEnabled(dialog, component);
        if (!CVSDialogRunner.runDialog((JDialog)dialog)) {
            return 1;
        }
        this.doCommitOperationImpl(component);
        return 0;
    }

    protected boolean isThreaded() {
        return true;
    }

    public static final void openRevisionViewer(Context context, String revision) throws Exception {
        URL realUrl = HistoryContext.getRealURL((Context)context);
        CVSOperationOpenRevision._openRepositoryRevision(realUrl != null ? realUrl : context.getNode().getURL(), revision);
    }

    protected void openRepositoryRevision(HistoryComponent table, HistoryEntry version) throws IOException, MalformedURLException, IllegalAccessException, InstantiationException {
        this.openRepositoryRevision(version);
    }

    protected void openRepositoryRevision(HistoryEntry version) throws IOException, MalformedURLException, IllegalAccessException, InstantiationException {
        this.openRepositoryRevision(((RevisionIdentifier)version.getValue(SharedProperties.getRevisionProperty())).getLabel());
    }

    protected void openRepositoryRevision(String revision) throws IOException, MalformedURLException, IllegalAccessException, InstantiationException {
        CVSOperationOpenRevision._openRepositoryRevision(this.getContextLocatables()[0].getURL(), revision);
    }

    private static final void _openRepositoryRevision(URL url, String revision) throws IOException, MalformedURLException, IllegalAccessException, InstantiationException {
        URL parent = URLFileSystem.getParent((URL)url);
        String root = CVSRootCache.getInstance().getRoot(parent).toString();
        String repository = CVSUtil.readRepository(parent);
        String path = repository + '/' + URLFileSystem.getFileName((URL)url);
        CVSOperationOpenRevision.openDefaultEditorInFrameLater(new Context(CVSConnectionNodeUtils.createNode(root, path, revision)));
    }

    private void updateOKEnabled(JEWTDialog dialog, HistoryComponent table) {
        dialog.setOKButtonEnabled(table.getSingleSelection() != null);
    }

    private void doCommitOperationImpl(HistoryComponent table) throws MalformedURLException, IOException, IllegalAccessException, InstantiationException {
        HistoryEntry entry = table.getSingleSelection();
        this.openRepositoryRevision(table, entry);
    }

    private static final void openDefaultEditorInFrameLater(final Context context) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public final void run() {
                EditorManager.getEditorManager().openDefaultEditorInFrame(context);
            }
        });
    }
}

