/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.op;

import java.awt.Component;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.UIManager;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.vcs.cache.Depth;
import oracle.jdeveloper.vcs.spi.VCSCancelException;
import oracle.jdeveloper.vcs.spi.VCSImportBackupHelper;
import oracle.jdevimpl.vcs.cvs.CVSAbstractCommand;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSCommandConstants;
import oracle.jdevimpl.vcs.cvs.CVSFileURLFileSystemHelper;
import oracle.jdevimpl.vcs.cvs.CVSInternalClientSupport;
import oracle.jdevimpl.vcs.cvs.CVSRootCache;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.error.CVSOperationException;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.wiz.checkout.CVSCheckoutCommitter;
import oracle.jdevimpl.vcs.cvs.wiz.checkout.CVSCheckoutModelKey;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardAbortException;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardCancelException;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardException;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardRunner;
import oracle.jdevimpl.vcs.cvs.wiz.import_.CVSImportModelKey;
import oracle.jdevimpl.vcs.cvs.wiz.import_.CVSImportWizard;

public class CVSOperationImport
extends CVSAbstractCommand
implements CVSImportModelKey,
CVSCheckoutModelKey,
CVSCommandConstants {
    public CVSOperationImport() {
        super(OPERATION_IMPORT_CMD_ID);
    }

    protected boolean isThreaded() {
        return true;
    }

    protected boolean isAvailableImpl() throws Exception {
        if (this.isContextConnectionAndNotSupported()) {
            return false;
        }
        if (CVSClient.getInstance() == null) {
            return false;
        }
        return !CVSClient.getInstance().isUsingInternalClient() || CVSInternalClientSupport.isSupportedCommand("import");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doitImpl() throws Exception {
        URL backupDirectoryUrl;
        CVSUtil.checkCreateConnection(this.getContext());
        CVSImportWizard wizard = new CVSImportWizard();
        wizard.setContext(this.getContext());
        Map importModel = null;
        try {
            importModel = CVSWizardRunner.runWizard(wizard, this.getContext());
        }
        catch (CVSWizardCancelException wce) {
            throw new VCSCancelException();
        }
        if (importModel == null || !((Boolean)importModel.get(KEY_IMPORT_DO_CHECKOUT)).booleanValue()) {
            return 0;
        }
        URL importDirectoryUrl = URLFactory.newDirURL((URL)URLFactory.newFileURL((String)importModel.get(KEY_IMPORT_SOURCES).toString()), (String)"");
        try {
            CVSFileURLFileSystemHelper.arrestCommands(this, importDirectoryUrl);
            VCSImportBackupHelper backupHelper = new VCSImportBackupHelper(importDirectoryUrl){

                protected void createBackupDirectory(URL backupDirectoryUrl) throws Exception {
                    if (!URLFileSystem.mkdirs((URL)backupDirectoryUrl)) {
                        throw new CVSOperationException(CVSArb.format("ERROR_IMPORT_BACKUP_MKDIRS_FAILED", URLFileSystem.getPlatformPathName((URL)backupDirectoryUrl)));
                    }
                }

                protected boolean confirmRetryBackupAfterFailure(URL url) {
                    return MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)CVSArb.format("ERROR_IMPORT_BACKUP_FAILED", URLFileSystem.getPlatformPathName((URL)url)), (String)CVSArb.get("ERROR_IMPORT_BACKUP_FAILED_TITLE"), null, (boolean)false, (String)CVSArb.get("ERROR_IMPORT_BACKUP_FAILED_YESTEXT"), (String)UIManager.getString("OptionPane.cancelButtonText"));
                }

                protected void preprocessBackup(URL url) {
                    CVSFileURLFileSystemHelper.arrestCommands((Object)this, url);
                }

                protected void postprocessBackup(URL url) {
                    CVSFileURLFileSystemHelper.resumeCommands((Object)this, url);
                }
            };
            backupDirectoryUrl = backupHelper.backupDirectoryFiles();
            CVSRootCache.getInstance().clear();
        }
        finally {
            CVSFileURLFileSystemHelper.resumeCommands(this, importDirectoryUrl);
        }
        if (backupDirectoryUrl == null) {
            return 1;
        }
        CVSClient.getInstance();
        CVSClient.getStatusCache().clear(new URL[]{backupDirectoryUrl}, Depth.INFINITY);
        Map checkoutModel = this.createCheckoutModel(importModel);
        try {
            CVSWizardRunner.commitWizard(checkoutModel, new CVSCheckoutCommitter(), this.getContext());
        }
        catch (CVSWizardAbortException wae) {
            throw new VCSCancelException();
        }
        catch (CVSWizardException we) {
            throw new CVSOperationException(we.getMessage());
        }
        return 0;
    }

    private Map createCheckoutModel(Map importModel) {
        HashMap checkoutModel = new HashMap();
        checkoutModel.put(KEY_CHECKOUT_MODULE_NAME, importModel.get(KEY_IMPORT_MODULE_NAME));
        checkoutModel.put(KEY_CHECKOUT_CONNECTION_NAME, importModel.get(KEY_IMPORT_CONNECTION_NAME));
        checkoutModel.put(KEY_CHECKOUT_TARGET, importModel.get(KEY_IMPORT_SOURCES));
        checkoutModel.put(KEY_CHECKOUT_CHECKOUT_TO_DIR, Boolean.TRUE);
        return checkoutModel;
    }
}

