/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.op;

import java.awt.Component;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.ProductInformation;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.jdeveloper.vcs.cache.Depth;
import oracle.jdeveloper.vcs.spi.VCSCommandState;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSDialogCommitter;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokableState;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdeveloper.vcs.spi.VCSValidationException;
import oracle.jdeveloper.vcs.util.VCSCommandUtils;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSURLFilters;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.cvs.CVSAbstractCommand;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSCommandConstants;
import oracle.jdevimpl.vcs.cvs.CVSComponents;
import oracle.jdevimpl.vcs.cvs.CVSFileStatus;
import oracle.jdevimpl.vcs.cvs.CVSInternalClientSupport;
import oracle.jdevimpl.vcs.cvs.error.CVSProcessException;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionCategory;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionDirector;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionId;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionsCustomizer;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerFactory;
import oracle.jdevimpl.vcs.cvs.util.CVSDialogRunner;
import oracle.jdevimpl.vcs.cvs.util.CVSDirectoryInvokable;

public class CVSOperationEdit
extends CVSAbstractCommand
implements CVSCommandConstants {
    public CVSOperationEdit() {
        super(OPERATION_EDIT_CMD_ID, VCSCommandStyle.MULTI);
    }

    protected VCSStatusFilter getStatusFilter() {
        return this.createStatusFilter(new VCSStatus[]{CVSFileStatus.STATUS_UNMODIFIED_READONLY, CVSFileStatus.STATUS_SANDBOX, CVSFileStatus.STATUS_CONFLICTS});
    }

    protected boolean isAvailableImpl() throws Exception {
        if (CVSClient.getInstance() == null) {
            return false;
        }
        if (CVSClient.getInstance().isUsingInternalClient() && !CVSInternalClientSupport.isSupportedCommand("edit")) {
            return false;
        }
        Locatable[] locatables = this.getContextLocatables();
        if (!this.isOpenSessionSelection(locatables)) {
            return false;
        }
        return this.isAvailableImpl(locatables);
    }

    protected boolean isAvailableImpl(URL url) throws Exception {
        if (!URLFileSystem.exists((URL)url)) {
            return false;
        }
        if (VCSFileSystemUtils.isNonEditable((URL)url)) {
            return false;
        }
        if (!super.isAvailableImpl(url)) {
            return false;
        }
        return this.getPolicyStatusCache().get(url) != CVSFileStatus.STATUS_CONFLICTS || URLFileSystem.isReadOnly((URL)url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doitImpl() throws Exception {
        Collection nodesPreCoalesce = this.getFilteredSelection();
        VCSCommandUtils.removeNonEditableNodes((Collection)nodesPreCoalesce);
        Collection nodes = this.coalesceNodesForFolderOperation(nodesPreCoalesce);
        if (nodes.size() <= 0) {
            return 9;
        }
        VCSDirectoryInvokableState state = new VCSDirectoryInvokableState(VCSModelUtils.convertNodesToURLs((Collection)nodes));
        final VCSCommandState state0 = new VCSCommandState(state, null);
        try {
            CVSOptionsCustomizer customizer = this.createOptionsCustomizer(nodes.toArray(new Locatable[0]));
            final JEWTDialog dialog = VCSComponents.createOperationDialog((Component)VCSWindowUtils.getCurrentWindow(), (String)CVSArb.get("EDIT_CAPTION"), (String)CVSArb.get("EDIT_LONG_PROMPT"), (Component)CVSComponents.createFileListerComponent(nodes), (Component)customizer.getComponent(), (String)"f1_cvseditfiles_html", (Component)customizer.getInitialFocusComponent());
            dialog.addVetoableChangeListener((VetoableChangeListener)new VCSDialogCommitter(customizer){

                protected final boolean doCommitOperation(Map options) throws Exception {
                    return CVSOperationEdit.this.doCommitOperationImpl((Component)dialog, options, state0);
                }
            });
            boolean dialogSuccessful = CVSDialogRunner.runDialog((JDialog)dialog);
            int n = !dialogSuccessful ? 1 : 0;
            return n;
        }
        finally {
            URL[] processedUrlArray = state0.getInvokableState().getProcessedURLs().toArray(new URL[0]);
            URLFilter filter = VCSURLFilters.createBaseURLContentsFilter((URL[])processedUrlArray);
            this.updateReadOnlyStates(VCSModelUtils.findCachedNodes((URLFilter)filter));
            CVSClient.getInstance();
            CVSClient.getStatusCache().clear(processedUrlArray, Depth.INFINITY);
        }
    }

    protected void noOpImpl() throws VCSValidationException {
        throw new VCSValidationException(CVSArb.get("ERROR_EDIT_FILTERED_TITLE"), CVSArb.format("ERROR_EDIT_FILTERED", ProductInformation.getProductInformation().getShortName()));
    }

    private CVSOptionsCustomizer createOptionsCustomizer(Locatable[] contextLocatables) {
        CVSOptionDirector optionDirector = new CVSOptionDirector(contextLocatables);
        optionDirector.registerCategoryOptions(CVSOptionCategory.BASIC, new CVSOptionId[]{CVSOptionId.WATCH_SET_WATCH_ACTIONS, CVSOptionId.COMMON_LOCAL_FOLDER_ONLY});
        optionDirector.registerCategoryOptions(CVSOptionCategory.ADVANCED, new CVSOptionId[0]);
        if (!CVSClient.getInstance().isAdvancedModeSet()) {
            optionDirector.deregisterCategoryOptions(CVSOptionCategory.ADVANCED);
        }
        CVSOptionsCustomizer optionsCustomizer = new CVSOptionsCustomizer(optionDirector.constructOptionComponents());
        optionsCustomizer.disableUnsupportedComponents("edit", CVSOptionId.WATCH_SET_WATCH_ACTIONS);
        return optionsCustomizer;
    }

    private boolean doCommitOperationImpl(Component dialog, Map optionsMap, VCSCommandState state) throws Exception {
        DeterminateProgressMonitor monitor = null;
        if (dialog != null) {
            monitor = new DeterminateProgressMonitor(dialog, CVSArb.get("EDIT_PROGRESS_TITLE"), (Object)CVSArb.get("EDIT_WATCHER_DESCRIPTION"), "", 0, -1);
        }
        final CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        runner.setCommand_("edit");
        runner.getParameters().setQuiet(false);
        runner.getParameters().setBuilderOptions(optionsMap);
        state.setInvokableState(this.coalesceStateForFolderOperation(optionsMap, state.getInvokableState()));
        CVSDirectoryInvokable invokable = new CVSDirectoryInvokable(state.getInvokableState()){

            @Override
            protected final boolean doInvocation2(URL parent, URL[] invokeUrls) throws Exception {
                String[] filenames = VCSFileSystemUtils.getURLFileNames((URL[])invokeUrls);
                runner.setDirURL_(parent);
                runner.getParameters().setFiles(Arrays.asList(filenames));
                CVSOperationEdit.this.doInvocationImpl(runner);
                return true;
            }
        };
        invokable.setProgressMonitor(monitor);
        return invokable.runInvokable();
    }

    private void doInvocationImpl(CVSRunner runner) throws Exception {
        runner.exec_();
        if (runner.getExitCode_() != null && runner.getExitCode_() == 0) {
            return;
        }
        throw new CVSProcessException(CVSArb.get("ERROR_EDIT_FAILED"), runner.getErrorText_());
    }
}

