/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.op;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.model.Dirtyable;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.history.HistoryEntry;
import oracle.javatools.history.HistoryModel;
import oracle.javatools.util.Log;
import oracle.jdeveloper.compare.BinaryCompareContributor;
import oracle.jdeveloper.compare.CompareManager;
import oracle.jdeveloper.compare.CompareViewer;
import oracle.jdeveloper.compare.InputStreamTextContributor;
import oracle.jdeveloper.compare.PatchCompareDescriptor;
import oracle.jdeveloper.compare.StreamDecoder;
import oracle.jdeveloper.compare.TextNodeContributor;
import oracle.jdeveloper.compare.URLContributor;
import oracle.jdeveloper.history.HistoryContext;
import oracle.jdeveloper.history.HistoryEntrySelector;
import oracle.jdeveloper.history.HistoryManager;
import oracle.jdeveloper.history.RevisionIdentifier;
import oracle.jdeveloper.history.SharedProperties;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdevimpl.compare.CompareUtil;
import oracle.jdevimpl.vcs.cvs.CVSAbstractCommand;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSCommandConstants;
import oracle.jdevimpl.vcs.cvs.CVSEntriesCache;
import oracle.jdevimpl.vcs.cvs.CVSFileStatus;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.client.CVSEntry;
import oracle.jdevimpl.vcs.cvs.client.CVSRevisionNumber;
import oracle.jdevimpl.vcs.cvs.error.CVSOperationException;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.util.log.CVSLogEntry;
import oracle.jdevimpl.vcs.cvs.util.revision.CVSRevisionInfo;
import oracle.jdevimpl.vcs.cvs.util.revision.CVSRevisionUtils;

public class CVSOperationDiff
extends CVSAbstractCommand {
    private static final Log LOG = new Log("vcs-cvs");

    public CVSOperationDiff() {
        super(CVSCommandConstants.OPERATION_DIFF_CMD_ID, VCSCommandStyle.SINGLE);
    }

    protected CVSOperationDiff(int id) {
        super(id, VCSCommandStyle.SINGLE);
    }

    protected boolean isAvailableImpl() throws Exception {
        if (CompareViewer.get() == null) {
            return false;
        }
        Locatable[] locatables = this.getContextLocatables();
        if (!this.isOpenSessionSelection(locatables)) {
            return false;
        }
        return this.isAvailableImpl(locatables[0]);
    }

    protected boolean isAvailableImpl(URL url) throws Exception {
        if (!super.isAvailableImpl(url)) {
            return false;
        }
        if (!CompareManager.getCompareManager().isContentComparable(url)) {
            return false;
        }
        if (!URLFileSystem.exists((URL)url)) {
            return false;
        }
        CVSClient.getInstance();
        VCSStatus status = (VCSStatus)CVSClient.getStatusCache().get(url);
        if (status == CVSFileStatus.STATUS_SANDBOX) {
            return false;
        }
        return status.isVersioned() && status != CVSFileStatus.STATUS_ADDED && status != CVSFileStatus.STATUS_REMOVED;
    }

    protected int doitImpl() throws Exception {
        CompareContributor left;
        this.context = ChangeListWindow.handleContext((Context)this.context);
        Locatable[] locatables = this.getContextLocatables();
        if (locatables.length == 0) {
            return -1;
        }
        if (!(locatables[0] instanceof TextNode) && !CVSUtil.saveDirtyNodes(Collections.singleton(locatables[0]))) {
            return 1;
        }
        CVSRevisionNumber contextRevision = this._getContextRevisionNumber(locatables);
        if (!(locatables[0] instanceof Element) || !oracle.ide.history.HistoryManager.getHistoryManager().isHistoried((Element)locatables[0])) {
            this.compareWithPreviousIntegrated(locatables[0], contextRevision);
            return 0;
        }
        CompareContributor right = CVSOperationDiff.createNodeContributor(locatables[0]);
        Node contextNode = locatables[0] instanceof Node ? (Node)locatables[0] : null;
        CompareModel model = CompareUtil.createCompareModel((Node)contextNode, (CompareContributor)(left = CVSOperationDiff.createRevisionContributor(locatables[0].getURL(), contextRevision.toString())), (CompareContributor)right);
        if (model == null) {
            return -1;
        }
        if (model.getDifferences().length == 0 && !CompareUtil.confirmIdenticalCompare()) {
            return 1;
        }
        HistoryEntrySelector historyEntrySelector = contextRevision != CVSRevisionNumber.HEAD ? new HistoryEntrySelector(contextRevision.toString()) : new HistoryEntrySelector(){

            public HistoryEntry select(HistoryModel historyModel) {
                HistoryEntry headHistoryEntry = null;
                CVSRevisionNumber headVersion = null;
                for (int i = 0; i < historyModel.getSize(); ++i) {
                    HistoryEntry historyEntry = historyModel.getEntry(i);
                    if (!(historyEntry instanceof CVSLogEntry)) continue;
                    CVSRevisionNumber version = CVSRevisionNumber.createRevisionNumber(((RevisionIdentifier)historyEntry.getValue(SharedProperties.getRevisionProperty())).getLabel());
                    if (headHistoryEntry != null && version.compareTo(headVersion) < 0) continue;
                    headHistoryEntry = historyEntry;
                    headVersion = version;
                }
                return headHistoryEntry;
            }
        };
        Context detailedContext = new Context(this.getContext());
        if (locatables[0] instanceof Node) {
            detailedContext.setNode((Node)locatables[0]);
        }
        HistoryContext.setHistoryEntrySelectorLHS((Context)detailedContext, (HistoryEntrySelector)historyEntrySelector);
        HistoryManager.getHistoryManager().showHistory(detailedContext);
        return 0;
    }

    protected CVSRevisionNumber getContextRevisionNumber(Locatable[] locatables) throws Exception {
        boolean baseCompare = locatables[0] instanceof Dirtyable && ((Dirtyable)locatables[0]).isDirty();
        URL url = locatables[0].getURL();
        if (!baseCompare) {
            CVSClient.getInstance();
            VCSStatus status = ((VCSStatus[])CVSClient.getStatusCache().get(new URL[]{url}))[0];
            baseCompare = baseCompare || status == CVSFileStatus.STATUS_LOCALLY_CHANGED;
        }
        CVSEntry entry = CVSEntriesCache.findEntry(CVSEntriesCache.getInstance().getEntriesMap(URLFileSystem.getParent((URL)url)), url);
        CVSRevisionNumber contextRevision = CVSRevisionNumber.createRevisionNumber(entry.getRevision());
        if (baseCompare || contextRevision.decrement()) {
            // empty if block
        }
        return contextRevision;
    }

    static final CompareContributor createRevisionContributor(URL url, String revision) throws Exception {
        CVSRevisionInfo info = CVSRevisionUtils.downloadContents(url, revision, null, true);
        String path = info.getRCSFile() != null ? info.getRCSFile() : URLFileSystem.getPlatformPathName((URL)url);
        String resourceName = CVSArb.format("DIFF_INTEGRATED_RESOURCE", revision, path);
        String charsetName = StreamDecoder.getDefaultEncoding((URL)url);
        LOG.trace("CVS: Compare contributor has encoding " + charsetName);
        if (VCSFileSystemUtils.isContentTypeBinary((URL)url)) {
            return new BinaryCompareContributor((InputStream)new ByteArrayInputStream(info.getContents()), URLFileSystem.getFileName((URL)url), resourceName, resourceName);
        }
        InputStreamTextContributor compareContributor = new InputStreamTextContributor((InputStream)new ByteArrayInputStream(info.getContents()), charsetName, resourceName, resourceName, URLFileSystem.getSuffix((URL)url));
        compareContributor.setPatchDescriptor(new PatchCompareDescriptor(URLFileSystem.getFileName((URL)url)));
        compareContributor.getPatchDescriptor().setPatchParentURL(URLFileSystem.getParent((URL)url));
        compareContributor.getPatchDescriptor().setRevision(info.getVersion());
        return compareContributor;
    }

    private static final CompareContributor createNodeContributor(Locatable node) throws IOException {
        if (node instanceof TextNode && ((TextNode)node).isDirty()) {
            return new TextNodeContributor((TextNode)node);
        }
        if (VCSFileSystemUtils.isContentTypeBinary((URL)node.getURL())) {
            return new BinaryCompareContributor(node.getURL());
        }
        return new URLContributor(node.getURL());
    }

    private CVSRevisionNumber _getContextRevisionNumber(Locatable[] locatables) throws Exception {
        try {
            return this.getContextRevisionNumber(locatables);
        }
        catch (NumberFormatException nfe) {
            throw new CVSOperationException(CVSArb.get("ERROR_DIFF_REVISION_FAILED"));
        }
    }

    private void compareWithPreviousIntegrated(Locatable node, CVSRevisionNumber contextRevision) throws Exception {
        CompareContributor left = null;
        CompareContributor right = null;
        right = CVSOperationDiff.createNodeContributor(node);
        final CompareContributor resLeft = left = CVSOperationDiff.createRevisionContributor(node.getURL(), contextRevision.toString());
        final CompareContributor resRight = right;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CompareViewer.get().show(resLeft, resRight);
            }
        });
    }
}

