/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.op;

import java.awt.Component;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.ProductInformation;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.jdeveloper.vcs.spi.VCSCommandState;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSDialogCommitter;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokableState;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSValidationException;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.cvs.CVSAbstractCommand;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSCommandConstants;
import oracle.jdevimpl.vcs.cvs.CVSComponents;
import oracle.jdevimpl.vcs.cvs.CVSFileStatus;
import oracle.jdevimpl.vcs.cvs.error.CVSProcessException;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionCategory;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionDirector;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionId;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionsCustomizer;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerFactory;
import oracle.jdevimpl.vcs.cvs.util.CVSDialogRunner;
import oracle.jdevimpl.vcs.cvs.util.CVSDirectoryInvokable;

public class CVSOperationDeleteTag
extends CVSAbstractCommand {
    public CVSOperationDeleteTag() {
        super(CVSCommandConstants.OPERATION_DELETE_TAG_CMD_ID, VCSCommandStyle.MULTI);
    }

    protected boolean isAvailableImpl(Locatable[] locatables) throws Exception {
        if (!this.isOpenSessionSelection(locatables)) {
            return false;
        }
        return super.isAvailableImpl(locatables);
    }

    protected boolean isAvailableImpl(URL url) throws Exception {
        if (!super.isAvailableImpl(url)) {
            return false;
        }
        if (!URLFileSystem.exists((URL)url)) {
            return false;
        }
        CVSClient.getInstance();
        VCSStatus status = (VCSStatus)CVSClient.getStatusCache().get(url);
        return status.isVersioned();
    }

    protected int doitImpl() throws Exception {
        VCSStatus[] statuses = new VCSStatus[]{CVSFileStatus.STATUS_LOCALLY_CHANGED, CVSFileStatus.STATUS_UNMODIFIED_READWRITE, CVSFileStatus.STATUS_UNMODIFIED_READONLY, CVSFileStatus.STATUS_CONFLICTS, CVSFileStatus.STATUS_SANDBOX};
        Collection nodesPreCoalesce = this.getFilteredSelection(this.getContextLocatables(), statuses);
        Collection nodes = this.coalesceNodesForFolderOperation(nodesPreCoalesce);
        if (nodes.size() <= 0) {
            return 9;
        }
        CVSOptionsCustomizer customizer = this.createOptionsCustomizer(nodes.toArray(new Locatable[0]));
        final JEWTDialog dialog = VCSComponents.createOperationDialog((Component)VCSWindowUtils.getCurrentWindow(), (String)CVSArb.get("DELETE_TAG_CAPTION"), (String)CVSArb.get("DELETE_TAG_LONG_PROMPT"), (Component)CVSComponents.createFileListerComponent(nodes), (Component)customizer.getComponent(), (String)"f1_cvsdeletetag_html", (Component)customizer.getInitialFocusComponent());
        VCSDirectoryInvokableState state = new VCSDirectoryInvokableState(VCSModelUtils.convertNodesToURLs((Collection)nodes));
        final VCSCommandState state0 = new VCSCommandState(state, null);
        dialog.addVetoableChangeListener((VetoableChangeListener)new VCSDialogCommitter(customizer){

            protected final boolean doCommitOperation(Map options) throws Exception {
                return CVSOperationDeleteTag.this.doCommitOperationImpl((Component)dialog, options, state0);
            }
        });
        boolean dialogSuccessful = CVSDialogRunner.runDialog((JDialog)dialog);
        customizer.dispose();
        return !dialogSuccessful ? 1 : 0;
    }

    protected void noOpImpl() throws VCSValidationException {
        throw new VCSValidationException(CVSArb.get("ERROR_DELETE_TAG_FILTERED_TITLE"), CVSArb.format("ERROR_DELETE_TAG_FILTERED", ProductInformation.getProductInformation().getShortName()));
    }

    private CVSOptionsCustomizer createOptionsCustomizer(Locatable[] contextLocatables) {
        CVSOptionDirector optionDirector = new CVSOptionDirector(contextLocatables);
        optionDirector.registerCategoryOptions(CVSOptionCategory.BASIC, new CVSOptionId[]{CVSOptionId.TAG_TAG_NAME_CHOICE, CVSOptionId.COMMON_LOCAL_FOLDER_ONLY});
        optionDirector.registerCategoryOptions(CVSOptionCategory.ADVANCED, new CVSOptionId[0]);
        if (!CVSClient.getInstance().isAdvancedModeSet()) {
            optionDirector.deregisterCategoryOptions(CVSOptionCategory.ADVANCED);
        }
        return new CVSOptionsCustomizer(optionDirector.constructOptionComponents());
    }

    private boolean doCommitOperationImpl(Component dialog, Map optionsMap, VCSCommandState state) throws Exception {
        DeterminateProgressMonitor monitor = new DeterminateProgressMonitor(dialog, CVSArb.get("DELETE_TAG_PROGRESS_TITLE"), (Object)CVSArb.get("DELETE_TAG_WATCHER_DESCRIPTION"), "", 0, -1);
        final CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        runner.setCmdArray_(new String[]{"tag", "-d"});
        runner.getParameters().setQuiet(false);
        if (optionsMap != null) {
            runner.getParameters().setBuilderOptions(optionsMap);
        }
        state.setInvokableState(this.coalesceStateForFolderOperation(optionsMap, state.getInvokableState()));
        CVSDirectoryInvokable invokable = new CVSDirectoryInvokable(state.getInvokableState()){

            @Override
            protected final boolean doInvocation2(URL parent, URL[] invokeUrls) throws Exception {
                String[] filenames = VCSFileSystemUtils.getURLFileNames((URL[])invokeUrls);
                runner.setDirURL_(parent);
                runner.getParameters().setFiles(Arrays.asList(filenames));
                CVSOperationDeleteTag.this.doInvocationImpl(runner);
                return true;
            }
        };
        invokable.setProgressMonitor(monitor);
        return invokable.runInvokable();
    }

    private void doInvocationImpl(CVSRunner runner) throws Exception {
        runner.exec_();
        if (runner.getExitCode_() != null && runner.getExitCode_() == 0) {
            return;
        }
        throw new CVSProcessException(CVSArb.get("ERROR_DELETE_TAG_FAILED"), runner.getErrorText_());
    }
}

