/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.op;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.vcs.nav.VersioningNavigatorConstants;
import oracle.jdeveloper.vcs.spi.VCSControlCache;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdevimpl.vcs.cvs.CVSAbstractCommand;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSCommandConstants;
import oracle.jdevimpl.vcs.cvs.CVSInternalClientSupport;
import oracle.jdevimpl.vcs.cvs.CVSResourcePicker;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.error.CVSProcessException;
import oracle.jdevimpl.vcs.cvs.error.CVSValidationException;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionDetailsKey;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListAPI;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodes;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.runner.CVSExternalClientRunner;
import oracle.jdevimpl.vcs.cvs.ui.CVSCreateRepositoryUI;
import oracle.jdevimpl.vcs.cvs.util.CVSDialogRunner;

public class CVSOperationCreateRepository
extends CVSAbstractCommand {
    public CVSOperationCreateRepository() {
        super(CVSCommandConstants.OPERATION_CREATE_REPOSITORY_CMD_ID);
    }

    protected boolean isAvailableImpl() {
        if (CVSClient.getInstance() == null) {
            return false;
        }
        if (CVSClient.getInstance().isClientStateVerified() && !CVSClient.getInstance().isExecutableInstalled()) {
            return false;
        }
        return !CVSClient.getInstance().isUsingInternalClient() || CVSInternalClientSupport.isSupportedCommand("init");
    }

    protected int doitImpl() throws Exception {
        if (!CVSClient.getInstance().isExecutableInstalled()) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)CVSArb.get("ERROR_SERVER_NOT_INSTALLED"), (String)CVSArb.get("ERROR_SERVER_NOT_INSTALLED_TITLE"), null);
            return -1;
        }
        JEWTDialog dialog = new JEWTDialog((Frame)Ide.getMainWindow(), CVSArb.get("CREATE_REPOSITORY_TITLE"), 7);
        final CVSCreateRepositoryUI ui = new CVSCreateRepositoryUI();
        CVSResourcePicker.get().start((Container)ui);
        ui.getChooserPanel().setURL(CVSUtil.FILESYSTEM_ROOT);
        ui.getChooserPanel().setChooseFolders(true);
        ui.getCreateConnectionCheckBox().setSelected(true);
        dialog.setResizable(false);
        dialog.setContent((Component)ui);
        HelpSystem.getHelpSystem().registerTopic((JComponent)ui, "f1_cvscreatelocalrepository_html");
        dialog.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
                URL url;
                if (!JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)e)) {
                    return;
                }
                if (!new File(ui.getChooserPanel().getPath()).isAbsolute()) {
                    this.validationFailed("ERROR_CREATE_REPOSITORY_NOT_PATH", e);
                }
                if (URLFileSystem.exists((URL)(url = VCSFileSystemUtils.getDirectoryPathURL((URL)ui.getChooserPanel().getURL())))) {
                    URL[] contentsUrls;
                    if (!URLFileSystem.isDirectory((URL)url)) {
                        this.validationFailed("ERROR_CREATE_REPOSITORY_IS_NOT_DIR", e);
                    }
                    if ((contentsUrls = URLFileSystem.list((URL)url)) != null && contentsUrls.length > 0) {
                        this.validationFailed("ERROR_CREATE_REPOSITORY_DIR_NOT_EMPTY", e);
                    }
                } else if (!URLFileSystem.mkdirs((URL)url)) {
                    this.validationFailed("ERROR_CREATE_REPOSITORY_MKDIRS_FAILED", e);
                }
            }

            private void validationFailed(String messageResource, PropertyChangeEvent e) throws PropertyVetoException {
                CVSValidationException exception = new CVSValidationException(CVSArb.get(messageResource));
                CVSOperationCreateRepository.this.getExceptionHandler().handleException((Exception)((Object)exception));
                throw new PropertyVetoException("", e);
            }
        });
        if (!CVSDialogRunner.runDialog((JDialog)dialog)) {
            return 1;
        }
        CVSExternalClientRunner runner = new CVSExternalClientRunner();
        URL url = ui.getChooserPanel().getURL();
        String repositoryPath = URLFileSystem.getPlatformPathName((URL)URLFileSystem.canonicalize((URL)url));
        runner.setDirURL_(url);
        runner.getParameters().setRoot(repositoryPath);
        runner.setCommand_("init");
        runner.exec_();
        if (runner.getExitCode_() == null || runner.getExitCode_() != 0) {
            throw new CVSProcessException(CVSArb.get("ERROR_CREATE_REPOSITORY_FAILED_TITLE"), CVSArb.get("ERROR_CREATE_REPOSITORY_FAILED"), runner.getErrorText_());
        }
        if (ui.getCreateConnectionCheckBox().isSelected()) {
            this.createLocalConnection(repositoryPath);
            CVSUtil.usageTrackerLog();
        }
        MessageDialog.information((Component)Ide.getMainWindow(), (Object)CVSArb.format("CREATE_REPOSITORY_SUCCESS_MESSAGE", repositoryPath), (String)CVSArb.get("CREATE_REPOSITORY_SUCCESS_TITLE"), null);
        return 0;
    }

    private void createLocalConnection(String repositoryPath) {
        repositoryPath = CVSUtil.removeTrailingFileSeparators(repositoryPath);
        CVSRootString rootstr = new CVSRootString(":local:" + repositoryPath).canonicalize();
        CVSConnectionData connection = CVSUtil.getRootConnection(rootstr);
        if (connection != null) {
            return;
        }
        String root = rootstr.toString();
        CVSConnectionListAPI list = CVSConnectionNodes.getConnectionListAPI();
        HashMap<Object, String> props = new HashMap<Object, String>();
        props.put(CVSConnectionDetailsKey.KEY_CONNECTION_NAME, root);
        props.put(CVSConnectionDetailsKey.KEY_CONNECTION_ROOT, root);
        list.addConnection(props);
        VCSControlCache.getInstance().fireControlStateChanged("oracle.jdeveloper.cvs");
        CVSClient.getInstance();
        CVSClient.getStatusCache().clear();
        CVSConnectionNodes.updateOverlays();
        final IdeAction showNavigatorAction = IdeAction.find((int)VersioningNavigatorConstants.SHOW_NAVIGATOR_CMD_ID);
        if (showNavigatorAction == null) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    showNavigatorAction.performAction();
                }
                catch (Exception e) {
                    Assert.printStackTrace((Throwable)e);
                }
            }
        });
    }
}

