/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.op;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.SortedComboBoxModel;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Enum;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.vcs.cache.Depth;
import oracle.jdeveloper.vcs.spi.VCSCancelException;
import oracle.jdeveloper.vcs.spi.VCSCompositeOptionsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSControlCache;
import oracle.jdeveloper.vcs.spi.VCSDialogCommitter;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizerAdapter;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSProcessUtils;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.cvs.CVSAbstractCommand;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSCommandConstants;
import oracle.jdevimpl.vcs.cvs.CVSNewFilesHandler;
import oracle.jdevimpl.vcs.cvs.CVSNewFilesWatcher2;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.control.CVSConnectionComboBoxRenderer;
import oracle.jdevimpl.vcs.cvs.control.CVSFilePanel;
import oracle.jdevimpl.vcs.cvs.control.CVSModuleSelectionPanel;
import oracle.jdevimpl.vcs.cvs.error.CVSOperationException;
import oracle.jdevimpl.vcs.cvs.error.CVSProcessException;
import oracle.jdevimpl.vcs.cvs.error.CVSValidationException;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionFileData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodeUtils;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodes;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionCategory;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionDirector;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionId;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionsCustomizer;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcess;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcessStreamMonitor;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerFactory;
import oracle.jdevimpl.vcs.cvs.util.CVSDialogRunner;
import oracle.jdevimpl.vcs.cvs.util.CVSDirectoryInvokable;

public class CVSOperationCheckout
extends CVSAbstractCommand {
    private ModuleObservable _moduleObservable;

    public CVSOperationCheckout() {
        super(CVSCommandConstants.OPERATION_CHECKOUT_CMD_ID);
    }

    protected boolean isAvailableImpl() throws Exception {
        return this.isContextConnectionAndNotSupported() ? false : super.isAvailableImpl();
    }

    protected boolean isThreaded() {
        return true;
    }

    private ModuleObservable getModuleObservable() {
        return this._moduleObservable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doitImpl() throws Exception {
        CheckoutOptionsCustomizer checkoutOptionsCustomizer;
        CVSUtil.checkCreateConnection(this.getContext());
        Map defaultCheckoutOptionValues = this.createDefaultCheckoutOptionsValues();
        CheckoutOptionsCustomizer optionsCustomizer = checkoutOptionsCustomizer = new CheckoutOptionsCustomizer();
        String connectionName = (String)defaultCheckoutOptionValues.get((Object)CheckoutOptionId.CONNECTION_NAME);
        final String moduleName = (String)defaultCheckoutOptionValues.get((Object)CheckoutOptionId.MODULE_NAME);
        int displayFlags = 0;
        String dialogTitle = CVSArb.get("CHECK_OUT_TITLE");
        if (connectionName != null) {
            displayFlags |= 1;
            dialogTitle = CVSArb.format("CHECK_OUT_TITLE_CONTEXTUAL", connectionName);
        }
        if (moduleName != null) {
            displayFlags |= 2;
            dialogTitle = CVSArb.format("CHECK_OUT_TITLE_CONTEXTUAL", moduleName);
        }
        optionsCustomizer.setDisplayFlags(displayFlags);
        optionsCustomizer.setOptions(defaultCheckoutOptionValues);
        this._moduleObservable = new ModuleObservable(checkoutOptionsCustomizer);
        CVSOptionsCustomizer dynamicCustomizer = this.createDynamicOptionsCustomizer();
        optionsCustomizer = new VCSCompositeOptionsCustomizer(new VCSOptionsCustomizer[]{optionsCustomizer, dynamicCustomizer}){

            protected Component layoutComponents(Component[] components) {
                JPanel panel = new JPanel(new BorderLayout());
                panel.add(components[0], "Center");
                panel.add(components[1], "South");
                if (moduleName == null) {
                    return panel;
                }
                JPanel panel0 = new JPanel(new BorderLayout());
                panel0.add((Component)panel, "North");
                panel0.add(Box.createVerticalGlue(), "Center");
                return panel0;
            }
        };
        VCSDialogCommitter dialogCommitter = new VCSDialogCommitter((VCSOptionsCustomizer)optionsCustomizer){};
        final JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)Ide.getMainWindow(), (Component)optionsCustomizer.getComponent(), (Component)optionsCustomizer.getInitialFocusComponent(), (String)dialogTitle, (int)7);
        dialog.setResizable(true);
        dialog.addVetoableChangeListener((VetoableChangeListener)dialogCommitter);
        checkoutOptionsCustomizer.getModuleSelectionPanel().addModuleNameChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                dialog.setOKButtonEnabled(!checkoutOptionsCustomizer.getModuleSelectionPanel().getModuleName().equals(""));
                CVSOperationCheckout.this.getModuleObservable().notifyObservers();
            }
        });
        checkoutOptionsCustomizer.getConnectionNameComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CVSOperationCheckout.this.getModuleObservable().notifyObservers();
            }
        });
        JComponent content = (JComponent)dialog.getContent();
        HelpSystem.getHelpSystem().registerTopic(content, "f1_cvscheckoutfromcvs_html");
        Dimension contentPreferredSize = content.getPreferredSize();
        contentPreferredSize.width = Math.max(560, contentPreferredSize.width);
        content.setPreferredSize(contentPreferredSize);
        if ((displayFlags & 2) <= 0) {
            dialog.setPreferredSize(640, 480);
        } else {
            dialog.setResizable(false);
        }
        try {
            if (!CVSDialogRunner.runDialog((JDialog)dialog)) {
                int n = 1;
                return n;
            }
        }
        finally {
            dynamicCustomizer.dispose();
        }
        return this.doOperation(optionsCustomizer.getOptions());
    }

    private CVSOptionsCustomizer createDynamicOptionsCustomizer() {
        final CVSOptionDirector optionDirector = new CVSOptionDirector();
        optionDirector.setContextProperties(this.createContextProperties());
        if (CVSClient.getInstance().isAdvancedModeSet()) {
            optionDirector.registerCategoryOptions(CVSOptionCategory.BASIC, new CVSOptionId[]{CVSOptionId.COMMON_USE_REVISION_OR_DATE_AND_FORCE, CVSOptionId.UPDATE_PRUNE_FOLDERS});
            optionDirector.registerCategoryOptions(CVSOptionCategory.ADVANCED, new CVSOptionId[]{CVSOptionId.COMMON_LOCAL_FOLDER_ONLY, CVSOptionId.COMMON_NO_MODULE_PROGRAMS});
        } else {
            optionDirector.registerCategoryOptions(CVSOptionCategory.BASIC, new CVSOptionId[]{CVSOptionId.COMMON_USE_REVISION, CVSOptionId.UPDATE_PRUNE_FOLDERS});
        }
        final CVSOptionsCustomizer customizer = new CVSOptionsCustomizer(optionDirector.constructOptionComponents());
        customizer.setDefaultOptionValues(this.createDefaultDynamicOptionsValues());
        this.getModuleObservable().addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                Map<String, String> oldProperties = optionDirector.getContextProperties();
                Map newProperties = CVSOperationCheckout.this.createContextProperties();
                if (newProperties != null && oldProperties != null && !oldProperties.equals(newProperties)) {
                    optionDirector.setContextProperties(newProperties);
                    optionDirector.repopulate(customizer.getOptionStructure());
                }
            }
        });
        return customizer;
    }

    private Map<String, String> createContextProperties() {
        CVSConnectionFileData fileData;
        String moduleName;
        String connectionName;
        HashMap<String, String> contextProperties = new HashMap<String, String>();
        CVSConnectionData connection = CVSConnectionNodeUtils.getConnectionForContext(this.context);
        String string = connectionName = connection != null ? connection.getName() : null;
        if (connectionName == null) {
            CVSConnectionData data = this.getModuleObservable().getUI().getSelectedConnection();
            String string2 = connectionName = data != null ? data.getName() : null;
        }
        if (connectionName != null) {
            contextProperties.put("cvsroot", CVSConnectionNodes.getConnectionListAPI().getConnectionRoot(connectionName));
        }
        String string3 = moduleName = (fileData = CVSConnectionNodeUtils.getContextFileData(this.context)) != null && (fileData.isDirectory() || fileData.isModulesEntry()) ? fileData.getPath() : null;
        if (moduleName == null) {
            moduleName = this.getModuleObservable().getUI().getModuleSelectionPanel().getModuleName();
        }
        if (moduleName != null && moduleName.equals("")) {
            moduleName = null;
        }
        if (moduleName != null) {
            contextProperties.put("rcspath", moduleName);
        }
        return contextProperties.isEmpty() ? null : contextProperties;
    }

    private Map createDefaultCheckoutOptionsValues() {
        URL url;
        CVSConnectionFileData fileData;
        HashMap<CheckoutOptionId, String> defaultOptionValues = new HashMap<CheckoutOptionId, String>();
        Context context = this.getContext();
        if (context == null) {
            return defaultOptionValues;
        }
        CVSConnectionData connection = CVSConnectionNodeUtils.getConnectionForContext(context);
        if (connection != null) {
            defaultOptionValues.put(CheckoutOptionId.CONNECTION_NAME, connection.getName());
        }
        if ((fileData = CVSConnectionNodeUtils.getContextFileData(context)) != null && (fileData.isDirectory() || fileData.isModulesEntry())) {
            defaultOptionValues.put(CheckoutOptionId.MODULE_NAME, fileData.getPath());
        }
        if ((url = Ide.getWorkspaces().getWorkDirectory()) != null) {
            defaultOptionValues.put(CheckoutOptionId.CHECKOUT_TARGET, VCSFileSystemUtils.getPlatformPathName((URL)url));
        }
        return defaultOptionValues;
    }

    private Map createDefaultDynamicOptionsValues() {
        return new HashMap();
    }

    private int doOperation(final Map options) throws Exception {
        CVSConnectionNodeUtils.ensureLogin((String)options.get((Object)CheckoutOptionId.CONNECTION_NAME), VCSWindowUtils.getCurrentWindow());
        final WaitCursor wc = new WaitCursor((Component)Ide.getMainWindow());
        EventQueue.invokeLater(new Runnable(){

            @Override
            public final void run() {
                wc.show();
            }
        });
        Runnable r = new Runnable(){

            @Override
            public final void run() {
                try {
                    CVSOperationCheckout.this.doOperationImpl(options);
                }
                catch (Exception e) {
                    try {
                        CVSOperationCheckout.this.getExceptionHandler().handleException(e);
                    }
                    catch (Throwable throwable) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public final void run() {
                                wc.hide();
                            }
                        });
                        throw throwable;
                    }
                    EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        };
        new Thread(r, "CVSOperationCheckout").start();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doOperationImpl(Map options) throws Exception {
        monitor.setCancellable(false);
        try (IndeterminateProgressMonitor monitor = new IndeterminateProgressMonitor((Component)VCSWindowUtils.getCurrentWindow(), CVSArb.get("CHECKING_OUT_FILES_TITLE"), (Object)CVSArb.get("CHECKING_OUT_FILES"), "");){
            int n = this.doOperationImpl2(options, monitor);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doOperationImpl2(Map options, final IndeterminateProgressMonitor monitor) throws Exception {
        String connectionName = (String)options.get((Object)CheckoutOptionId.CONNECTION_NAME);
        String moduleName = (String)options.get((Object)CheckoutOptionId.MODULE_NAME);
        String checkoutTarget = (String)options.get((Object)CheckoutOptionId.CHECKOUT_TARGET);
        CVSConnectionData connection = CVSConnectionNodes.getConnectionListAPI().getConnectionAPI(connectionName);
        if (connection == null || CVSDirectoryInvokable.isProgressDelayable(new CVSRootString(connection.getRoot()))) {
            monitor.setMillisToPopup(2000);
        } else {
            monitor.setMillisToPopup(0);
        }
        ArrayList<String> commandOptions = new ArrayList<String>();
        URL checkoutDirectoryUrl = URLFactory.newDirURL((URL)URLFactory.newFileURL((String)checkoutTarget), (String)"");
        boolean checkoutToDirectory = URLFileSystem.getFileName((URL)checkoutDirectoryUrl).equals(moduleName);
        if (checkoutToDirectory) {
            commandOptions.add("-d");
            commandOptions.add(URLFileSystem.getFileName((URL)checkoutDirectoryUrl));
        }
        commandOptions.add(moduleName);
        if (!URLFileSystem.exists((URL)checkoutDirectoryUrl) && !URLFileSystem.mkdirs((URL)checkoutDirectoryUrl)) {
            throw new CVSOperationException(CVSArb.get("CHECKOUT_TARGET_CREATE_FAILED"));
        }
        final CVSNewFilesWatcher2 watcher = new CVSNewFilesWatcher2(checkoutDirectoryUrl);
        CVSRunner runner = null;
        Node[] affectedNodes = CVSUtil.getCachedBaseURLNodes(new URL[]{checkoutDirectoryUrl});
        if (!CVSUtil.saveDirtyNodes(Arrays.asList(affectedNodes))) {
            throw new VCSCancelException();
        }
        monitor.start();
        try {
            runner = CVSRunnerFactory.getInstance().createRunner();
            runner.addOutputMonitor(new CVSProcessStreamMonitor(){

                @Override
                protected void streamLine(String line, CVSProcess process) throws Exception {
                    monitor.getPanel().setNote(line.trim());
                }
            });
            runner.getParameters().setRoot(CVSConnectionNodes.getConnectionListAPI().getConnectionRoot(connectionName));
            runner.setCommand_("checkout");
            runner.getParameters().setBuilderOptions(options);
            runner.getParameters().setOptions(commandOptions);
            runner.setDirURL_(checkoutToDirectory ? URLFileSystem.getParent((URL)checkoutDirectoryUrl) : checkoutDirectoryUrl);
            runner.getParameters().setQuiet(false);
            watcher.takeSnapshotOne();
            runner.exec_();
        }
        catch (Throwable throwable) {
            CVSClient.getInstance();
            CVSClient.getStatusCache().clear(new URL[]{checkoutDirectoryUrl}, Depth.INFINITY);
            VCSControlCache.getInstance().fireControlStateChanged("oracle.jdeveloper.cvs");
            throw throwable;
        }
        CVSClient.getInstance();
        CVSClient.getStatusCache().clear(new URL[]{checkoutDirectoryUrl}, Depth.INFINITY);
        VCSControlCache.getInstance().fireControlStateChanged("oracle.jdeveloper.cvs");
        watcher.takeSnapshotTwo();
        if (runner.getExitCode_() == null || runner.getExitCode_() != 0) {
            throw new CVSProcessException(CVSArb.get("CHECKOUT_PROCESS_FAILED"), runner.getErrorText_());
        }
        monitor.close();
        final String moduleName0 = moduleName;
        final URL checkoutDirectoryUrl0 = checkoutDirectoryUrl;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public final void run() {
                try {
                    if (VCSProcessUtils.productHandleNewFiles()) {
                        CVSNewFilesHandler.handleNewFiles(CVSOperationCheckout.this.getContext(), watcher, checkoutDirectoryUrl0, moduleName0);
                    }
                }
                catch (Exception e) {
                    CVSOperationCheckout.this.getExceptionHandler().handleException(e);
                }
            }
        });
        return 0;
    }

    private static class CheckoutOptionsCustomizer
    extends VCSOptionsCustomizerAdapter {
        public static final int HIDE_CONNECTION_NAME = 1;
        public static final int HIDE_MODULE_NAME = 2;
        private int _displayFlags;
        private JLabel _connectionNameLabel;
        private JComboBox _connectionNameComboBox;
        private JLabel _moduleNameLabel;
        private CVSModuleSelectionPanel _moduleSelectionPanel;
        private JLabel _targetLabel;
        private CVSFilePanel _targetChooserPanel;

        private CheckoutOptionsCustomizer() {
        }

        public JComboBox getConnectionNameComboBox() {
            return this._connectionNameComboBox;
        }

        public CVSModuleSelectionPanel getModuleSelectionPanel() {
            return this._moduleSelectionPanel;
        }

        public void setDisplayFlags(int displayFlags) {
            this._displayFlags = displayFlags;
        }

        public Component getComponent() {
            if (this._component == null) {
                this._component = new JPanel();
                this.createComponents();
                this.layoutComponents();
                this.consumeResources();
                this.populateComponents();
                this.attachListeners();
            }
            return this._component;
        }

        public void setOptions(Map options) {
            this.getComponent();
            String connectionName = (String)options.get((Object)CheckoutOptionId.CONNECTION_NAME);
            String moduleName = (String)options.get((Object)CheckoutOptionId.MODULE_NAME);
            String checkoutTarget = (String)options.get((Object)CheckoutOptionId.CHECKOUT_TARGET);
            if (checkoutTarget != null) {
                this._targetChooserPanel.setURL(URLFactory.newFileURL((String)checkoutTarget));
            }
            CVSConnectionData connection = null;
            if (connectionName != null) {
                connection = CVSConnectionNodes.getConnectionListAPI().getConnectionAPI(connectionName);
            }
            if (connection != null) {
                this.setComboBoxItem(this._connectionNameComboBox, connection);
            }
            this._connectionNameComboBox_actionPerformed(null);
            if (moduleName != null) {
                this._moduleSelectionPanel.setModuleName(moduleName);
            } else {
                this._moduleSelectionPanel.setModuleNameFromFirstItem();
            }
        }

        public Map getOptions() {
            this.getComponent();
            HashMap<CheckoutOptionId, String> options = new HashMap<CheckoutOptionId, String>();
            options.put(CheckoutOptionId.CONNECTION_NAME, this.getSelectedConnection().getName());
            options.put(CheckoutOptionId.MODULE_NAME, this._moduleSelectionPanel.getModuleName());
            options.put(CheckoutOptionId.CHECKOUT_TARGET, VCSFileSystemUtils.getPlatformPathName((URL)this._targetChooserPanel.getURL()));
            return options;
        }

        public void validateOptions() throws VCSException {
            String moduleName = this._moduleSelectionPanel.getModuleName();
            if (moduleName == null || this.isWhitespace(moduleName.toString())) {
                throw new CVSValidationException(CVSArb.get("CHECKOUT_MODULE_INVALID"));
            }
            if (this._targetChooserPanel.isFieldEmpty()) {
                throw new CVSValidationException(CVSArb.get("CHECKOUT_TARGET_EMPTY"));
            }
            URL url = this._targetChooserPanel.getURL();
            if (url == null || URLFileSystem.exists((URL)url) && !URLFileSystem.isDirectory((URL)url)) {
                throw new CVSValidationException(CVSArb.get("CHECKOUT_TARGET_INVALID"));
            }
        }

        public Component getInitialFocusComponent() {
            return this._connectionNameComboBox;
        }

        private void createComponents() {
            this._component = new JPanel();
            this._connectionNameLabel = new JLabel();
            this._connectionNameComboBox = new JComboBox();
            this._moduleNameLabel = new JLabel();
            this._moduleSelectionPanel = new CVSModuleSelectionPanel();
            this._targetLabel = new JLabel();
            this._targetChooserPanel = new CVSFilePanel();
        }

        private void layoutComponents() {
            LayoutBuilder layoutBuilder;
            Insets i = new Insets(2, 2, 2, 2);
            JPanel connectionPanel = null;
            JPanel modulePanel = null;
            JPanel optionsPanel = new JPanel();
            if ((this._displayFlags & 1) <= 0) {
                connectionPanel = new JPanel();
                layoutBuilder = new LayoutBuilder();
                layoutBuilder.add((Component)this._connectionNameLabel, i, 1, false, true);
                layoutBuilder.nl();
                layoutBuilder.add((Component)this._connectionNameComboBox, i, 1, false, true);
                layoutBuilder.nl();
                layoutBuilder.add(Box.createVerticalStrut(0), i, 1, false, true);
                layoutBuilder.nl();
                layoutBuilder.addToPanel((Container)connectionPanel);
            }
            if ((this._displayFlags & 2) <= 0) {
                Box moduleSelectionPanelBox = Box.createVerticalBox();
                moduleSelectionPanelBox.add(Box.createVerticalStrut(i.bottom + i.top));
                moduleSelectionPanelBox.add(this._moduleSelectionPanel);
                modulePanel = new JPanel(new BorderLayout());
                modulePanel.add((Component)this._moduleNameLabel, "North");
                modulePanel.add((Component)moduleSelectionPanelBox, "Center");
            }
            layoutBuilder = new LayoutBuilder();
            layoutBuilder.add((Component)this._targetLabel, i, 1, false, true);
            layoutBuilder.nl();
            layoutBuilder.add((Component)((Object)this._targetChooserPanel), i, 1, false, true);
            layoutBuilder.nl();
            layoutBuilder.add(Box.createVerticalStrut(10), null, 1, false, true);
            layoutBuilder.nl();
            layoutBuilder.addToPanel((Container)optionsPanel);
            JPanel panel = (JPanel)this._component;
            panel.setLayout(new BorderLayout());
            if (connectionPanel != null) {
                panel.add((Component)connectionPanel, "North");
            }
            if (modulePanel != null) {
                panel.add((Component)modulePanel, "Center");
            }
            panel.add((Component)optionsPanel, "South");
            layoutBuilder = null;
        }

        private void consumeResources() {
            ResourceUtils.resLabel((JLabel)this._connectionNameLabel, (Component)this._connectionNameComboBox, (String)CVSArb.get("CONNECTION_NAME"));
            ResourceUtils.resLabel((JLabel)this._moduleNameLabel, (Component)this._moduleSelectionPanel.getModuleNameComponent(), (String)CVSArb.get("MODULE_NAME"));
            ResourceUtils.resLabel((JLabel)this._targetLabel, (Component)((Object)this._targetChooserPanel), (String)CVSArb.get("FOLDER_FOR_TARGET"));
        }

        private void populateComponents() {
            this._moduleSelectionPanel.setParentComponent(this._component);
            this._moduleSelectionPanel.setVisibleRowCount(6);
            this._connectionNameComboBox.setEditable(false);
            SortedComboBoxModel connectionNameComboBoxModel = new SortedComboBoxModel();
            connectionNameComboBoxModel.setComparator((Comparator)new ConnectionComparator());
            Set connectionNames = CVSConnectionNodes.getConnectionListAPI().getConnectionNames();
            if (connectionNames == null) {
                connectionNames = Collections.EMPTY_SET;
            }
            Iterator itr = connectionNames.iterator();
            while (itr.hasNext()) {
                connectionNameComboBoxModel.addElement((Object)CVSConnectionNodes.getConnectionListAPI().getConnectionAPI((String)itr.next()));
            }
            this._connectionNameComboBox.setModel(connectionNameComboBoxModel);
            this._connectionNameComboBox.setRenderer(new CVSConnectionComboBoxRenderer());
            if (this._connectionNameComboBox.getItemCount() > 0) {
                this._connectionNameComboBox.setSelectedIndex(0);
            }
            this._targetChooserPanel.setChooseFolders(true);
            this._connectionNameComboBox_actionPerformed(null);
        }

        private void attachListeners() {
            this._connectionNameComboBox.addActionListener(new ActionListener(){

                @Override
                public final void actionPerformed(ActionEvent e) {
                    this._connectionNameComboBox_actionPerformed(e);
                }
            });
        }

        private void setComboBoxItem(JComboBox comboBox, Object item) {
            DefaultComboBoxModel comboBoxModel = (DefaultComboBoxModel)comboBox.getModel();
            if (comboBoxModel.getIndexOf(item) < 0) {
                comboBoxModel.addElement(item);
            }
            comboBox.setSelectedItem(item);
            if (comboBox.isEditable()) {
                comboBox.getEditor().setItem(item);
            }
        }

        private CVSConnectionData getSelectedConnection() {
            return (CVSConnectionData)this._connectionNameComboBox.getSelectedItem();
        }

        private void _connectionNameComboBox_actionPerformed(ActionEvent e) {
            CVSConnectionData connection = this.getSelectedConnection();
            this._moduleSelectionPanel.connectionNameChanged(connection != null ? connection.getName() : "");
        }

        private boolean isWhitespace(String s) {
            if (s.equals("")) {
                return true;
            }
            String illegalChars = " \t\n\f\r";
            for (int i = 0; i < s.length(); ++i) {
                if (" \t\n\f\r".indexOf(s.charAt(i)) >= 0) continue;
                return false;
            }
            return true;
        }

        private class ConnectionComparator
        implements Comparator {
            private ConnectionComparator() {
            }

            public int compare(Object o1, Object o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null && o2 != null) {
                    return 1;
                }
                if (o1 != null && o2 == null) {
                    return -1;
                }
                return ((CVSConnectionData)o1).getName().compareTo(((CVSConnectionData)o2).getName());
            }
        }
    }

    private static class CheckoutOptionId
    extends Enum {
        public static final CheckoutOptionId CONNECTION_NAME = new CheckoutOptionId("CONNECTION_NAME");
        public static final CheckoutOptionId MODULE_NAME = new CheckoutOptionId("MODULE_NAME");
        public static final CheckoutOptionId CHECKOUT_TARGET = new CheckoutOptionId("CHECKOUT_TARGET");
        private static final CheckoutOptionId[] PRIVATE_VALUES = new CheckoutOptionId[]{CONNECTION_NAME, MODULE_NAME, CHECKOUT_TARGET};
        private static int _nextOrdinal = 0;

        private CheckoutOptionId(String name) {
            super(name, _nextOrdinal++);
        }

        public static final CheckoutOptionId valueOf(String name) {
            return (CheckoutOptionId)Enum.valueOf((Enum[])PRIVATE_VALUES, (String)name);
        }

        public static final CheckoutOptionId[] values() {
            return (CheckoutOptionId[])PRIVATE_VALUES.clone();
        }
    }

    private class ModuleObservable
    extends Observable {
        private CheckoutOptionsCustomizer _ui;

        private ModuleObservable(CheckoutOptionsCustomizer ui) {
            this._ui = ui;
        }

        @Override
        public void notifyObservers(Object arg) {
            this.setChanged();
            super.notifyObservers(arg);
        }

        public CheckoutOptionsCustomizer getUI() {
            return this._ui;
        }
    }
}

