/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.nav.cmd;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.net.URLFactory;
import oracle.ide.util.Assert;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.vcs.controls.ConnectionImportExportPanel;
import oracle.jdeveloper.vcs.spi.VCSControlCache;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.control.CVSConnectionListCellRenderer;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListAPI;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListNode;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNode;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodes;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;

public class CVSConnectionsImportExport
extends ConnectionImportExportPanel {
    public CVSConnectionsImportExport() {
        this.setConnectionsCellRenderer(new CVSConnectionListCellRenderer());
    }

    protected Object[] getExportableConnections() {
        CVSConnectionListNode list = CVSConnectionNodes.getConnectionListNode();
        ArrayList<CVSConnectionNode> al = new ArrayList<CVSConnectionNode>();
        Iterator i = list.getChildren();
        while (i.hasNext()) {
            CVSConnectionNode connNode = (CVSConnectionNode)i.next();
            al.add(connNode);
        }
        Object[] arr = new Object[al.size()];
        al.toArray(arr);
        return arr;
    }

    protected void filenameChanged(String filename) {
        File f = new File(filename);
        if (f.exists()) {
            try {
                CVSConnectionListNode list = new CVSConnectionListNode();
                list.load(URLFactory.newFileURL((String)filename));
                Iterator i = list.getChildren();
                ArrayList<CVSConnectionNode> al = new ArrayList<CVSConnectionNode>();
                while (i.hasNext()) {
                    CVSConnectionNode connectionNode = (CVSConnectionNode)i.next();
                    if (this.isImportMode() && CVSConnectionNodes.getConnectionListAPI().getRootConnection(connectionNode.getConnection().getRoot()) != null) continue;
                    al.add(connectionNode);
                }
                Object[] arr = new Object[al.size()];
                al.toArray(arr);
                if (arr.length > 0) {
                    this.setConnections(arr);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected boolean importConnections() {
        Object[] conns = this.getSelectedConnections();
        CVSConnectionListNode list = CVSConnectionNodes.getConnectionListNode();
        if ((conns = this.confirmImportConnections(conns)) == null) {
            return false;
        }
        list.getChildren();
        for (int i = 0; i < conns.length; ++i) {
            CVSConnectionNode connNode = (CVSConnectionNode)conns[i];
            CVSConnectionData conn = connNode.getConnection();
            String name = conn.getName();
            if (!list.hasConnection(name)) {
                list.addConnection(conn);
                continue;
            }
            if (!this.askOverwrite(name)) continue;
            list.updateConnection(name, conn);
        }
        VCSControlCache.getInstance().fireControlStateChanged("oracle.jdeveloper.cvs");
        CVSClient.getInstance();
        CVSClient.getStatusCache().clear();
        CVSConnectionNodes.updateOverlays();
        CVSUtil.usageTrackerLog();
        return true;
    }

    protected boolean exportConnections(final String filename) {
        Assert.checkAWTThread();
        try {
            Object[] conns = this.getSelectedConnections();
            final CVSConnectionListNode list = new CVSConnectionListNode(false);
            for (int i = 0; i < conns.length; ++i) {
                list.addConnection(((CVSConnectionNode)conns[i]).getConnection());
            }
            if (EventQueue.isDispatchThread()) {
                list.save(URLFactory.newFileURL((String)filename));
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            list.save(URLFactory.newFileURL((String)filename));
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                });
            }
            return true;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
    }

    private Object[] confirmImportConnections(Object[] conns) {
        ArrayList<Object> conns0 = new ArrayList<Object>(Arrays.asList(conns));
        Iterator itr = conns0.iterator();
        while (itr.hasNext()) {
            CVSConnectionData conn = ((CVSConnectionNode)itr.next()).getConnection();
            if (CVSConnectionListAPI.isSupportedConnection(conn)) continue;
            itr.remove();
        }
        if (conns0.size() == conns.length) {
            return conns;
        }
        ArrayList<Object> conns1 = new ArrayList<Object>(Arrays.asList(conns));
        conns1.removeAll(conns0);
        Component connectionsPanel = this.createConnectionsPanel(conns1.toArray(), CVSArb.get("IMPORT_UNSUPPORTED_CONNECTIONS"), CVSArb.get("UNSUPPORTED_CONNECTIONS"));
        int result = MessageDialog.confirmOrCancel((Component)VCSWindowUtils.getCurrentWindow(), (Object)connectionsPanel, (String)CVSArb.get("IMPORT_UNSUPPORTED_CONNECTIONS_TITLE"), null);
        if (result == 1) {
            return conns;
        }
        if (result == 0) {
            return conns0.toArray();
        }
        return null;
    }

    private Component createConnectionsPanel(Object[] connections, String message, String label) {
        JList<Object> jlist = new JList<Object>(connections);
        jlist.setCellRenderer(new CVSConnectionListCellRenderer());
        jlist.setVisibleRowCount(2);
        JLabel jlabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jlabel, jlist, (String)label);
        Box box = Box.createVerticalBox();
        Box box0 = Box.createHorizontalBox();
        box0.add(jlabel);
        box0.add(Box.createHorizontalGlue());
        box.add((Component)new JWrappedLabel(message));
        box.add(Box.createVerticalStrut(5));
        box.add(box0);
        box.add(Box.createVerticalStrut(2));
        box.add(new JScrollPane(jlist));
        Dimension preferredSize = box.getPreferredSize();
        preferredSize.width = Math.min(preferredSize.width, 700);
        box.setPreferredSize(preferredSize);
        return box;
    }

    private boolean askOverwrite(String name) {
        return MessageDialog.confirm((Component)((Object)this), (Object)CVSArb.format("CVSCONNECTIONSIMPORTEXPORT_OVERWRITE_TEXT", name), (String)CVSArb.get("CVSCONNECTIONSIMPORTEXPORT_OVERWRITE_TITLE"), null);
    }
}

