/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.nav;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.ide.util.Encodings;
import oracle.ide.util.IdeUtil;
import oracle.javatools.util.Log;
import oracle.jdeveloper.vcs.util.VCSStreamUtils;
import oracle.jdevimpl.vcs.cvs.CVSActiveClient;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSEncodingUtil;
import oracle.jdevimpl.vcs.cvs.client.CVSRootConversion;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.error.CVSOperationException;
import oracle.jdevimpl.vcs.cvs.error.CVSProcessException;
import oracle.jdevimpl.vcs.cvs.login.CVSLogin;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionDefaultServices;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionDirectoryData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionFilePathUtils;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionFileURL;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.ocvs.OCVSCheckedInHandler;
import oracle.ocvs.OCVSClientException;
import oracle.ocvs.OCVSCommand;
import oracle.ocvs.OCVSEntry;
import oracle.ocvs.OCVSException;
import oracle.ocvs.OCVSLogStream;
import oracle.ocvs.OCVSMergedHandler;
import oracle.ocvs.OCVSOption;
import oracle.ocvs.OCVSPServerConnection;
import oracle.ocvs.OCVSPathName;
import oracle.ocvs.OCVSProcessIO;
import oracle.ocvs.OCVSRemovedHandler;
import oracle.ocvs.OCVSResource;
import oracle.ocvs.OCVSResponseHandler;
import oracle.ocvs.OCVSResponseRegistry;
import oracle.ocvs.OCVSRoot;
import oracle.ocvs.OCVSServerException;
import oracle.ocvs.OCVSSession;
import oracle.ocvs.OCVSUpdate;
import oracle.ocvs.OCVSUpdatedHandler;
import oracle.ocvs.OCVSValidRequestsHandler;

class CVSConnectionPServerServices
extends CVSConnectionDefaultServices {
    private static final Log LOG = new Log("vcs-cvs");

    CVSConnectionPServerServices() {
        if (Boolean.getBoolean("jdev.cvs.debugbrowser")) {
            OCVSLogStream._clientStream = System.out;
            OCVSLogStream._serverStream = System.err;
        }
    }

    @Override
    CVSConnectionDirectoryData[] getRootDirectoryList(String root) throws Exception {
        try {
            return super.getRootDirectoryList(root);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            String line;
            CVSRootString rootStringOriginal = new CVSRootString(root);
            CVSRootString rootString = this.processRootString(rootStringOriginal);
            final char[] spw = CVSLogin.getMethod(rootStringOriginal).getLoginPassword(rootStringOriginal);
            final String repository = this.convertPathToPServerRepository(rootString.getRepository());
            OCVSUpdate command = new OCVSUpdate(){

                protected void authenticateUserForPServer(OCVSPServerConnection connection, OCVSRoot root, boolean verifyOnly, char[] password) throws IOException, OCVSException {
                    super.authenticateUserForPServer(connection, root, verifyOnly, spw);
                }

                protected int indexOfFileArgument(Map options, String[] arguments) throws OCVSClientException {
                    return -1;
                }

                protected void sessionPrepared(OCVSSession session, Map options, OCVSResource[] resources) throws IOException, ParseException, OCVSException {
                    session.sendDirectory(".", repository);
                }
            };
            HashMap<OCVSOption, String> options = new HashMap<OCVSOption, String>();
            options.put(OCVSCommand.OPTION_OVERRIDE_CVSROOT, rootString.toString());
            options.put(OCVSCommand.OPTION_DO_NOT_EXEC_DISK, null);
            options.put(OCVSUpdate.OPTION_CREATE_AND_UPDATE_NEW_DIRS, null);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ByteArrayOutputStream byteArrayErrorStream = new ByteArrayOutputStream();
            OCVSProcessIO io = new OCVSProcessIO(null, new PrintStream(byteArrayOutputStream), new PrintStream(byteArrayErrorStream));
            this.initializeProcessIO(io);
            try {
                int exitCode = command.executeCommand(io, null, options, new String[0]);
                if (exitCode != 0) {
                    Assert.printStackTrace();
                    throw new UnsupportedOperationException();
                }
            }
            catch (OCVSClientException ocvsce) {
                this.handleClientException(ocvsce);
            }
            catch (OCVSServerException ocvsse) {
                this.handleServerException(ocvsse, byteArrayErrorStream.toString(), rootStringOriginal);
            }
            String errorText = byteArrayErrorStream.toString();
            BufferedReader bufferedReader = new BufferedReader(new StringReader(errorText));
            ArrayList<CVSConnectionDirectoryData> directoryData = new ArrayList<CVSConnectionDirectoryData>();
            final boolean[] exit = new boolean[1];
            while (!exit[0] && (line = bufferedReader.readLine()) != null) {
                Pattern pattern;
                Matcher matcher;
                if (line.indexOf("Updating") >= 0 && line.indexOf(" .") < 0) {
                    LOG.trace("FIXME: CVS client does not support 'ls' and it's a CVSNT server.");
                    LOG.trace("       See bugs 3947505 and 3947534.");
                    LOG.trace("       We're going to make the internal CVS client support 'ls'.");
                    Assert.execute((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            exit[0] = true;
                        }
                    });
                }
                if (!(matcher = (pattern = Pattern.compile(".*New directory `(.*)' -- ignored")).matcher(line)).matches()) continue;
                directoryData.add(new CVSConnectionDirectoryData(matcher.group(1)));
            }
            return directoryData.toArray(new CVSConnectionDirectoryData[0]);
        }
    }

    @Override
    byte[] getRevisionContents(CVSConnectionFileURL url) throws Exception {
        try {
            return this._getRevisionContents(url);
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
            return super.getRevisionContents(url);
        }
    }

    protected CVSRootString processRootString(CVSRootString rootString) throws Exception {
        if (Boolean.getBoolean("jdev.cvs.debugbrowser") && CVSLogin.getMethod(rootString).getLoginPassword(rootString) == null) {
            Assert.printStackTrace((Throwable)new IllegalStateException("no password for root '" + rootString + "'"));
            throw new UnsupportedOperationException();
        }
        return new CVSRootString(CVSRootConversion.convertExtensionToClientRootPServer(rootString).toString());
    }

    protected void initializeProcessIO(OCVSProcessIO io) {
    }

    private byte[] _getRevisionContents(CVSConnectionFileURL url) throws Exception {
        CVSRootString rootStringOriginal = new CVSRootString(url.getRoot());
        CVSRootString rootString = this.processRootString(rootStringOriginal);
        final char[] spw = CVSLogin.getMethod(rootStringOriginal).getLoginPassword(rootStringOriginal);
        String repository = this.convertPathToPServerRepository(rootString.getRepository());
        final String fileName = CVSConnectionFilePathUtils.getFileName(url.getPath());
        final String directory = CVSConnectionFilePathUtils.createChildPath(repository, CVSConnectionFilePathUtils.getParent(url.getPath()));
        OCVSUpdate command = new OCVSUpdate(){

            protected void authenticateUserForPServer(OCVSPServerConnection connection, OCVSRoot root, boolean verifyOnly, char[] password) throws IOException, OCVSException {
                super.authenticateUserForPServer(connection, root, verifyOnly, spw);
            }

            protected int indexOfFileArgument(Map options, String[] arguments) throws OCVSClientException {
                return -1;
            }

            protected void sessionStarted(OCVSSession session, Map options, OCVSResource[] resources) throws IOException, ParseException, OCVSException {
                options.remove(OCVSCommand.OPTION_DO_NOT_EXEC_DISK);
            }

            protected void sessionPrepared(OCVSSession session, Map options, OCVSResource[] resources) throws IOException, ParseException, OCVSException {
                session.sendDirectory(".", directory);
                session.sendEntry('/' + fileName + "////");
                session.sendUnchanged(fileName);
                session.sendArgument(fileName);
            }
        };
        HashMap<OCVSOption, String> options = new HashMap<OCVSOption, String>();
        options.put(OCVSCommand.OPTION_OVERRIDE_CVSROOT, rootString.toString());
        options.put(OCVSCommand.OPTION_DO_NOT_EXEC_DISK, null);
        options.put(OCVSUpdate.OPTION_USE_FILE_REVISION, url.getRevision());
        if (CVSEncodingUtil.getEncodingForRoot(url.getRoot()) != null || !CVSClient.getInstance().isUsingInternalClient() && !IdeUtil.getIdeEncoding().equals(Encodings.getDefaultEncoding())) {
            LOG.trace("CVS: No EOL conversion downloading file for " + url.getRoot() + ", path " + url.getPath());
            options.put(OCVSCommand.OPTION_DO_NOT_CONVERT_EOLS, null);
        }
        final File[] contentsFile = new File[1];
        OCVSUpdatedHandler updatedHandler = new OCVSUpdatedHandler(){

            protected boolean isNoExecDisk(OCVSSession session) {
                return false;
            }

            public void handleResponse(OCVSSession session, String argument) throws ParseException, IOException, OCVSClientException {
                OCVSPathName pathName = this.receivePathName(session, argument);
                String newEntriesLine = session.receiveLine();
                OCVSEntry entry = OCVSEntry.parseEntrySpec((String)newEntriesLine);
                int type = entry.isBinary() ? 1 : 0;
                contentsFile[0] = session.receiveModeFile(type);
            }
        };
        OCVSResponseRegistry responseRegistry = new OCVSResponseRegistry();
        responseRegistry.registerResponseHandler((OCVSResponseHandler)new OCVSValidRequestsHandler());
        responseRegistry.registerResponseHandler((OCVSResponseHandler)new OCVSCheckedInHandler());
        responseRegistry.registerResponseHandler((OCVSResponseHandler)new OCVSMergedHandler());
        responseRegistry.registerResponseHandler((OCVSResponseHandler)new OCVSRemovedHandler());
        responseRegistry.registerResponseHandler((OCVSResponseHandler)updatedHandler);
        command.setResponseRegistry(responseRegistry);
        ByteArrayOutputStream byteArrayErrorStream = new ByteArrayOutputStream();
        OCVSProcessIO io = new OCVSProcessIO(null, new PrintStream(new PipedOutputStream()), new PrintStream(byteArrayErrorStream));
        this.initializeProcessIO(io);
        try {
            int n = command.executeCommand(io, null, options, new String[0]);
        }
        catch (OCVSClientException ocvsce) {
            this.handleClientException(ocvsce);
        }
        catch (OCVSServerException ocvsse) {
            this.handleServerException(ocvsse, byteArrayErrorStream.toString(), rootStringOriginal);
        }
        if (contentsFile[0] == null) {
            throw new IllegalStateException();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        URL dataFileUrl = contentsFile[0].toURL();
        VCSStreamUtils.pipeStreamData((InputStream)URLFileSystem.openInputStream((URL)dataFileUrl), (OutputStream)byteArrayOutputStream);
        byteArrayOutputStream.close();
        URLFileSystem.delete((URL)dataFileUrl);
        return byteArrayOutputStream.toByteArray();
    }

    private String convertPathToPServerRepository(String path) {
        return path;
    }

    private void handleClientException(OCVSClientException ocvsce) throws Exception {
        if (ocvsce.getMessage() != null && ocvsce.getMessage().indexOf("authorization failed") >= 0) {
            throw new PServerAuthFailException(ocvsce);
        }
        StringBuilder sb = new StringBuilder();
        if (ocvsce.getMessage() != null && ocvsce.getMessage().indexOf("ConnectException") >= 0) {
            sb.append(CVSArb.get("ERROR_NAVIGATOR_CONNECTION_FAILURE"));
        } else {
            sb.append(CVSArb.get("ERROR_NAVIGATOR_CLIENT_FAILURE"));
        }
        if (ocvsce.getMessage() != null) {
            sb.append("\n\n");
            sb.append(ocvsce.getMessage());
        }
        throw new CVSOperationException(sb.toString());
    }

    private void handleServerException(OCVSServerException ocvsse, String errorText, CVSRootString rootString) throws Exception {
        if (errorText != null && errorText.indexOf("no such repository") >= 0 && rootString.isAccessLocal() && CVSActiveClient.isClientCVSNT()) {
            throw new CVSOperationException(CVSArb.format("ERROR_NAVIGATOR_NO_CVSNT_REPOS", rootString.getRepository()));
        }
        throw new CVSProcessException(CVSArb.get("ERROR_NAVIGATOR_SERVER_FAILURE"), errorText);
    }

    protected class PServerAuthFailException
    extends Exception {
        PServerAuthFailException(OCVSClientException cause) {
            super((Throwable)cause);
        }
    }
}

