/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.nav;

import java.awt.Component;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.jdeveloper.vcs.nav.ConnectionNode;
import oracle.jdeveloper.vcs.nav.ConnectionNodeDecorator;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdevimpl.vcs.cvs.CVSActiveClient;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.login.CVSLogin;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionContext;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionDetailsKey;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionDirectoryData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionDirectoryNode;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionFileData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionFileNode;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionFileURL;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListAPI;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionModuleData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionModuleNameCache;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNode;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodeRecognizer;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodes;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionServices;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionServicesFactory;
import oracle.jdevimpl.vcs.cvs.nav.cmd.CVSCloseConnectionCmd;
import oracle.jdevimpl.vcs.cvs.util.CVSEnvironmentVars;

public class CVSConnectionNodeUtils {
    private CVSConnectionNodeUtils() {
    }

    public static final CVSConnectionNode getContextConnectionNode(Context c) {
        ConnectionNode cNode;
        if (c == null) {
            return null;
        }
        Element e = c.getElement();
        if (e instanceof CVSConnectionNode) {
            return (CVSConnectionNode)e;
        }
        if (e instanceof ConnectionNodeDecorator && (cNode = ((ConnectionNodeDecorator)e).getConnectionNode()) != null && cNode instanceof CVSConnectionNode) {
            return (CVSConnectionNode)cNode;
        }
        return null;
    }

    public static final CVSConnectionData getConnectionForContext(Context c) {
        if (c == null) {
            return null;
        }
        Element e = c.getElement();
        if (e == null) {
            return null;
        }
        return e instanceof CVSConnectionContext ? ((CVSConnectionContext)e).getConnection() : null;
    }

    public static final CVSConnectionFileData getContextFileData(Context c) {
        if (c == null) {
            return null;
        }
        Element e = c.getElement();
        if (e == null) {
            return null;
        }
        Object data = e.getData();
        return data instanceof CVSConnectionFileData ? (CVSConnectionFileData)data : null;
    }

    static final CVSConnectionDirectoryNode getContextDirectoryNode(Context c) {
        if (c == null) {
            return null;
        }
        Element e = c.getElement();
        return e instanceof CVSConnectionDirectoryNode ? (CVSConnectionDirectoryNode)e : null;
    }

    static final CVSConnectionFileNode getContextFileNode(Context c) {
        if (c == null) {
            return null;
        }
        Element e = c.getElement();
        return e instanceof CVSConnectionFileNode ? (CVSConnectionFileNode)e : null;
    }

    public static final Map createEnvironmentConnectionDetails() {
        CVSClient client = CVSClient.getInstance();
        CVSConnectionListData connectionList = CVSConnectionNodes.getConnectionListData();
        if (connectionList.hasConnection("CVSROOT")) {
            return null;
        }
        client.verifyClientState();
        Map vars = CVSEnvironmentVars.getInstance().getVariables();
        String cvsroot = (String)vars.get("CVSROOT");
        String cvsrsh = (String)vars.get("CVS_RSH");
        String cvsserver = (String)vars.get("CVS_SERVER");
        if (cvsroot == null || cvsroot.equals("")) {
            return null;
        }
        if (connectionList.getRootConnection(cvsroot) != null) {
            return null;
        }
        if (CVSActiveClient.isClientCVSNT()) {
            cvsroot = CVSRootString.canonicalizeCVSNTRoot(cvsroot);
        }
        HashMap<Object, Object> details = new HashMap<Object, Object>();
        details.put(CVSConnectionDetailsKey.KEY_CONNECTION_NAME, "CVSROOT");
        details.put(CVSConnectionDetailsKey.KEY_CONNECTION_ROOT, cvsroot);
        if (cvsrsh != null) {
            details.put(CVSConnectionDetailsKey.KEY_CONNECTION_SET_RSH, Boolean.TRUE);
            details.put(CVSConnectionDetailsKey.KEY_CONNECTION_CVS_RSH, cvsrsh);
        }
        if (cvsserver != null) {
            details.put(CVSConnectionDetailsKey.KEY_CONNECTION_SET_SERVER, Boolean.TRUE);
            details.put(CVSConnectionDetailsKey.KEY_CONNECTION_CVS_SERVER, cvsserver);
        }
        return details;
    }

    public static final Node createNode(String root, String path, String revision) throws MalformedURLException, IllegalAccessException, InstantiationException {
        CVSConnectionNodeRecognizer recognizer = new CVSConnectionNodeRecognizer();
        URL url = new CVSConnectionFileURL(root, path, revision).toURL();
        return recognizer.create(url, recognizer.recognize(url));
    }

    public static final Class getFileNodeClass() {
        return CVSConnectionFileNode.class;
    }

    public static final CVSConnectionFileData[] getRootFileList(String root) throws Exception {
        CVSConnectionServices services = CVSConnectionServicesFactory.createServices(root);
        ArrayList<CVSConnectionFileData> fileList = new ArrayList<CVSConnectionFileData>();
        try {
            CVSConnectionDirectoryData[] rootDirectoryData = services.getRootDirectoryList(root);
            if (!Boolean.getBoolean("jdev.cvs.enableopenmodule") && rootDirectoryData != null) {
                fileList.addAll(Arrays.asList(rootDirectoryData));
            }
        }
        catch (UnsupportedOperationException rootDirectoryData) {
            // empty catch block
        }
        try {
            CVSConnectionModuleData[] moduleData = services.getModuleList(root);
            if (!Boolean.getBoolean("jdev.cvs.enableopenmodule") && moduleData != null) {
                fileList.addAll(Arrays.asList(moduleData));
            }
        }
        catch (UnsupportedOperationException moduleData) {
            // empty catch block
        }
        String[] cachedDirectoryNames = CVSConnectionModuleNameCache.getNames(root);
        for (int i = 0; cachedDirectoryNames != null && i < cachedDirectoryNames.length; ++i) {
            if (CVSConnectionNodeUtils.containsFileDataForPath(fileList, cachedDirectoryNames[i])) continue;
            fileList.add(new CVSConnectionDirectoryData(cachedDirectoryNames[i]));
        }
        if (!CVSConnectionNodeUtils.containsFileDataForPath(fileList, "CVSROOT")) {
            fileList.add(new CVSConnectionDirectoryData("CVSROOT"));
        }
        return fileList.toArray(new CVSConnectionFileData[0]);
    }

    public static final void ensureLogin(String connection, Component parent) throws VCSException {
        CVSConnectionListAPI connectionList = CVSConnectionNodes.getConnectionListAPI();
        CVSRootString root = new CVSRootString(((CVSConnectionListData)connectionList).getConnectionRoot(connection));
        if (!CVSLogin.getMethod(root).isLoggedIn(root)) {
            CVSLogin.getMethod(root).doLogin(root, parent);
        }
    }

    public static final void closeConnection(String connectionName) throws Exception {
        CVSConnectionNode connectionNode = CVSConnectionNodes.getConnectionListData().getConnectionNode(connectionName);
        if (connectionNode != null && connectionNode.isOpen()) {
            CVSCloseConnectionCmd.close(Context.newIdeContext((Node)connectionNode));
        }
    }

    public static final void closeAllConnections() throws Exception {
        CVSConnectionListData connectionList = CVSConnectionNodes.getConnectionListData();
        for (String connectionName : connectionList.getConnectionNames()) {
            String connectionRoot = connectionList.getConnectionRoot(connectionName);
            if (connectionRoot == null) continue;
            CVSRootString rootString = new CVSRootString(connectionRoot);
            if (CVSLogin.hasMethod(rootString) && CVSLogin.getMethod(rootString).isLoggedIn(rootString)) {
                CVSLogin.getMethod(rootString).doLogout(rootString);
            }
            CVSConnectionNodeUtils.closeConnection(connectionName);
        }
        CVSConnectionNodes.updateOverlays();
    }

    public static final byte[] downloadContents(String root, String path, String revision) throws Exception {
        return CVSConnectionServicesFactory.createServices(root).getRevisionContents(new CVSConnectionFileURL(root, path, revision));
    }

    private static final boolean containsFileDataForPath(Collection fileData, String path) {
        Iterator itr = fileData.iterator();
        while (itr.hasNext()) {
            if (!((CVSConnectionFileData)itr.next()).getPath().equals(path)) continue;
            return true;
        }
        return false;
    }
}

