/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.nav;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Observable;
import oracle.ide.Context;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.javatools.util.Version;
import oracle.jdeveloper.vcs.nav.BaseConnectionProvider;
import oracle.jdeveloper.vcs.nav.ConnectionFilter;
import oracle.jdeveloper.vcs.nav.ConnectionListFilterNode;
import oracle.jdeveloper.vcs.nav.ConnectionNode;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdevimpl.vcs.cvs.CVSActiveClient;
import oracle.jdevimpl.vcs.cvs.CVSLoginCache;
import oracle.jdevimpl.vcs.cvs.client.CVSMethodSpecifier;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionDetailsKey;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionFilterNode;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListFilterNode;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListModel;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListNode;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNavigatorManager;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNode;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodeCache;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodeUtils;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodes;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionObservable;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.wiz.connect.CVSConnectModelKey;
import oracle.jdevimpl.vcs.cvs.wiz.connect.CVSConnectWizard;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardCancelException;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardRunner;

public class CVSConnectionNavigatorProvider
extends BaseConnectionProvider {
    public Node getConnectionListNode() {
        CVSConnectionNodes.attachToNavigator();
        return CVSConnectionNodes.getConnectionListNode();
    }

    public String getALMTeamSourceControlType() {
        return "CVS";
    }

    protected boolean createConnection(Map<String, String> criteria, Context context) {
        HashMap<Object, String> props = null;
        if (criteria != null && !criteria.isEmpty()) {
            CVSMethodSpecifier methodSpec = this.getMethod(criteria);
            CVSRootString rootString = new CVSRootString(methodSpec, System.getProperty("user.name"), null, criteria.get("host"), criteria.get("port"), false, criteria.get("repository"));
            props = new HashMap<Object, String>();
            props.put(CVSConnectModelKey.KEY_CONNECTION_ROOT, rootString.toString());
            String name = criteria.get("name");
            props.put(CVSConnectModelKey.KEY_CONNECTION_NAME, name != null ? name : rootString.toString());
        }
        try {
            CVSWizardRunner.runWizard(new CVSConnectWizard(props), context);
            return true;
        }
        catch (CVSWizardCancelException wce) {
            return false;
        }
    }

    protected String getCriteriaFullPath(Map<String, String> criteria) {
        String repository = criteria.get("repository");
        String path = criteria.get("path");
        if (repository == null && path == null) {
            return null;
        }
        if (repository == null) {
            return path;
        }
        if (path == null) {
            return repository;
        }
        return this.canonicalizePath(repository) + path;
    }

    protected ConnectionNode createConnectionNodeSilently(Map<String, String> criteria) {
        CVSMethodSpecifier methodSpec = this.getMethod(criteria);
        CVSRootString rootString = new CVSRootString(methodSpec, System.getProperty("user.name"), null, criteria.get("host"), criteria.get("port"), false, criteria.get("repository"));
        CVSConnectionListModel model = new CVSConnectionListModel();
        HashMap conn = new HashMap();
        HashMap<Object, String> data = new HashMap<Object, String>();
        data.put(CVSConnectionDetailsKey.KEY_CONNECTION_NAME, criteria.get("name"));
        data.put(CVSConnectionDetailsKey.KEY_CONNECTION_ROOT, rootString.toString());
        conn.put(criteria.get("name"), data);
        model.setData(conn);
        CVSConnectionData connection = new CVSConnectionData(criteria.get("name"), model);
        CVSConnectionListNode lstNode = CVSConnectionNavigatorManager.getInstance().getConnectionListNode();
        lstNode.addConnection(connection);
        CVSConnectionNode node = lstNode.getConnectionNode(criteria.get("name"));
        return node;
    }

    protected ConnectionListFilterNode createConnectionListFilterNode() {
        return new CVSConnectionListFilterNode();
    }

    protected Element createConnectionFilterNode(ConnectionNode connectionNode, ConnectionFilter filter) {
        CVSConnectionFilterNode connectionFilterNode = new CVSConnectionFilterNode((CVSConnectionData)connectionNode.getData(), filter);
        connectionFilterNode.setNodeCache(new CVSConnectionNodeCache((CVSConnectionNode)connectionNode));
        return connectionFilterNode;
    }

    protected void addOverlayClient(Node listNode) {
        CVSConnectionNavigatorManager.getInstance().addOverlayClient(listNode);
    }

    public Observable getConnectionObservable() {
        return CVSConnectionObservable.getObservable();
    }

    public boolean canOpenVersionViewer(Map<String, String> criteria) {
        CVSConnectionNode connectionNode = (CVSConnectionNode)this.findConnectionNode(criteria);
        return connectionNode != null && CVSLoginCache.getInstance().isLoggedIn(new CVSRootString(connectionNode.getConnection().getRoot()));
    }

    public void openVersionViewer(Map<String, String> criteria, String path, String revision) throws Exception {
        CVSConnectionNode connectionNode = (CVSConnectionNode)this.findConnectionNode(criteria);
        try {
            Node node = CVSConnectionNodeUtils.createNode(connectionNode.getConnection().getRoot(), path, new Version(revision).toString());
            EditorManager.getEditorManager().openDefaultEditorInFrame(new Context(node));
        }
        catch (NumberFormatException nfe) {
            throw new VCSException(CVSArb.get("CANNOT_OPEN_REVISION_TITLE"), CVSArb.format("COR_INVALID_REVISION", revision));
        }
    }

    private CVSMethodSpecifier getMethod(Map<String, String> criteria) {
        LinkedHashMap<String, String> accessFieldMap = new LinkedHashMap<String, String>();
        String proxy = criteria.get("proxy");
        String proxyPort = criteria.get("proxyport");
        if (proxy != null && !proxy.trim().equals("")) {
            accessFieldMap.put("proxy", proxy);
            if (proxyPort != null && !proxyPort.trim().equals("")) {
                accessFieldMap.put("proxyport", proxyPort);
            }
        }
        String method = criteria.get("method") != null ? criteria.get("method") : "pserver";
        CVSMethodSpecifier methodSpec = CVSMethodSpecifier.createMethodSpec(method, accessFieldMap, CVSActiveClient.isClientCVSNT() ? ";" : "#");
        return methodSpec;
    }
}

