/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.nav;

import oracle.ide.Ide;
import oracle.ide.IdeActivationEvent;
import oracle.ide.IdeActivationListener;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListNode;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionOverlayClient;

public class CVSConnectionNavigatorManager {
    private static final CVSConnectionNavigatorManager _instance = new CVSConnectionNavigatorManager();
    private CVSConnectionListNode _node = new CVSConnectionListNode();

    public static final CVSConnectionNavigatorManager getInstance() {
        return _instance;
    }

    public CVSConnectionListNode getConnectionListNode() {
        return this._node;
    }

    public void initialize() {
        this.addOverlayClient((Node)this._node);
        Ide.getMainWindow().addIdeActivationListener(new IdeActivationListener(){

            public final void activated(IdeActivationEvent e) {
                CVSUtil.clearPerformanceCaches();
                CVSConnectionNavigatorManager.this.updateOverlays();
            }

            public final void deactivated(IdeActivationEvent e) {
            }
        });
    }

    void addOverlayClient(final Node node) {
        CVSConnectionOverlayClient.setEnabled(true);
        if (node != null && !node.isOpen()) {
            node.attach(new Observer(){

                public void update(Object observed, UpdateMessage change) {
                    if (change.getMessageID() == UpdateMessage.OBJECT_OPENED && observed == node) {
                        CVSConnectionNavigatorManager.this.updateOverlays();
                        node.detach((Observer)this);
                    }
                }
            });
        }
        CVSConnectionOverlayClient.updateOverlayIcons();
    }

    public void updateOverlays() {
        CVSConnectionOverlayClient.updateOverlayIcons();
    }
}

