/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.nav;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.Assert;
import oracle.javatools.util.ImageIconCache;
import oracle.jdeveloper.vcs.nav.ConnectionFilter;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionContext;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionDirectoryData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionDirectoryNode;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionElement;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionFileURL;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionFilterableContainer;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodeCache;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodeUtils;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;

public class CVSConnectionFilterNode
extends CVSConnectionFilterableContainer
implements CVSConnectionElement,
CVSConnectionContext {
    private final CVSConnectionData _data;
    private CVSConnectionNodeCache _cache;
    private boolean _login;

    CVSConnectionFilterNode(CVSConnectionData data) {
        this(data, null);
    }

    CVSConnectionFilterNode(CVSConnectionData data, ConnectionFilter filter) {
        this._data = data;
        this.setFilter(filter);
        this.getAttributes().set(ElementAttributes.NAVIGABLE);
    }

    protected void setNodeCache(CVSConnectionNodeCache cache) {
        this._cache = cache;
        if (this._cache != null) {
            this._cache.getRootNode().attach(new Observer(){

                public void update(Object observed, UpdateMessage change) {
                    if (change.getMessageID() == UpdateMessage.STRUCTURE_CHANGED) {
                        UpdateMessage.fireStructureChanged((Subject)CVSConnectionFilterNode.this, (Collection)change.getModifyObjects());
                    }
                }
            });
        }
    }

    public Map<String, String> getConnectionCriteria() {
        return this._data.getConnectionCriteria();
    }

    protected boolean isTrackedInNodeCache() {
        return false;
    }

    @Override
    public CVSConnectionData getConnection() {
        return this._data;
    }

    public Node createDirectoryNode(String path) {
        URL url = this.createConnectionFileURL(path, null);
        CVSConnectionDirectoryData directoryData = new CVSConnectionDirectoryData(path);
        CVSConnectionDirectoryNode directoryNode = new CVSConnectionDirectoryNode(this._cache, directoryData, url);
        return directoryNode;
    }

    public void updateModuleFileData() {
        this._cache.getRootNode().updateModuleFileData();
    }

    CVSConnectionNodeCache getNodeCache() {
        return this._cache;
    }

    public Object getData() {
        return this._data;
    }

    public Icon getIcon() {
        return ImageIconCache.get((URL)CVSArb.class.getResource(CVSArb.get("CONNECTION_NODE_ICON")));
    }

    public String getLongLabel() {
        return this._data.getName();
    }

    public String getShortLabel() {
        return this._data.getName();
    }

    public String getToolTipText() {
        MessageFormat formatter = new MessageFormat(CVSArb.get("CONNECTION_TOOLTIP"));
        return formatter.format(new Object[]{this._data.getRoot()});
    }

    protected void openImpl() throws IOException {
        if (!this.ensureConnectionLogin()) {
            this._login = false;
            this.forceNodeToCollapse();
        } else {
            super.openImpl();
            this._login = true;
        }
    }

    void forceNodeToCollapse() {
        UpdateMessage.fireObjectClosed((Subject)this);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CVSConnectionFilterNode.this.setOpen(false);
            }
        });
    }

    protected void closeImpl() throws IOException {
        super.closeImpl();
        this._cache.getRootNode().close();
    }

    public Iterator getChildren() {
        try {
            this.open();
            if (!this._login) {
                return null;
            }
            Iterator itr = this._cache.getRootNode().getChildren();
            if (!this._cache.getRootNode().isOpen()) {
                this.setOpen(false);
                return null;
            }
            return this.createFilteredChildIterator(itr);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean add(Element e) {
        return this._cache.getRootNode().add(e);
    }

    public boolean remove(Element e) {
        return this._cache.getRootNode().remove(e);
    }

    public boolean ensureConnectionLogin() {
        try {
            CVSConnectionNodeUtils.ensureLogin(this.getConnection().getName(), VCSWindowUtils.getCurrentWindow());
            return true;
        }
        catch (VCSException ce) {
            CVSClient.getInstance().getExceptionHandler().handleException((Exception)((Object)ce), (Component)Ide.getMainWindow());
            return false;
        }
    }

    public String toString() {
        return this._data.getRoot();
    }

    private URL createConnectionFileURL(String path, String revision) {
        try {
            return CVSConnectionFileURL.toURL(this._data.getRoot(), path, revision);
        }
        catch (MalformedURLException murle) {
            Assert.printStackTrace((Throwable)murle);
            return null;
        }
    }
}

