/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.nav;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.Icon;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.Assert;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionContext;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionDefaultServices;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionDirectoryData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionElement;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionFileData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionFileNode;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionFilePathUtils;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionFileURL;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionFilterableContainer;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListNode;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNode;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodeCache;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionPServerServices;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionServices;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionServicesFactory;
import oracle.jdevimpl.vcs.util.browser.BrowserModelWorker;

class CVSConnectionDirectoryNode
extends CVSConnectionFilterableContainer
implements CVSConnectionElement,
CVSConnectionContext {
    private final CVSConnectionNodeCache _cache;
    private final CVSConnectionDirectoryData _data;
    protected final Lock _lock = new ReentrantLock();

    CVSConnectionDirectoryNode(CVSConnectionNodeCache cache, CVSConnectionDirectoryData data, URL url) {
        super(url);
        this._cache = cache;
        this._data = data;
    }

    protected boolean isTrackedInNodeCache() {
        return false;
    }

    public Object getData() {
        return this._data;
    }

    public Icon getIcon() {
        return CVSConnectionElement.DIRECTORY_ICON;
    }

    public String getToolTipText() {
        return this._data.getPath();
    }

    public String getShortLabel() {
        return this._data.getFileName();
    }

    protected void openImpl() throws IOException {
        new BrowserModelWorker((Subject)this, this._children, this._lock){

            protected Collection getChildrenInBackground() {
                CVSConnectionDirectoryNode.this._openImpl(this);
                return Collections.EMPTY_SET;
            }
        }.execute();
    }

    private final void _openImpl(BrowserModelWorker worker) {
        CVSClient client = CVSClient.getInstance();
        client.verifyClientState();
        if (!client.isClientAvailable()) {
            worker.fail(new Runnable(){

                @Override
                public void run() {
                    CVSConnectionDirectoryNode.this.forceConnectionNodeToCollapse();
                }
            });
            return;
        }
        try {
            this.requeryChildren(worker);
        }
        catch (CVSConnectionDefaultServices.JSchAuthFailException jschafe) {
            worker.fail(new Runnable(){

                @Override
                public void run() {
                    CVSConnectionDirectoryNode.this.forceConnectionNodeToCollapse();
                }
            });
            return;
        }
        catch (CVSConnectionPServerServices.PServerAuthFailException psafe) {
            worker.fail(new Runnable(){

                @Override
                public void run() {
                    CVSConnectionDirectoryNode.this.forceConnectionNodeToCollapse();
                }
            });
            return;
        }
        catch (Exception e) {
            worker.fail(new Runnable(){

                @Override
                public void run() {
                    CVSClient.getInstance().getExceptionHandler().handleException(e, (Component)Ide.getMainWindow());
                    CVSConnectionDirectoryNode.this.forceConnectionNodeToCollapse();
                }
            });
        }
    }

    protected void closeImpl() throws IOException {
        super.closeImpl();
        this._lock.lock();
        try {
            this._cache.uncache(this._data.getPath());
            this.uncacheAllChildren();
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getChildren() {
        try {
            this.open();
            ArrayList arrayList = this._children;
            synchronized (arrayList) {
                return this.createFilteredChildIterator(new ArrayList(this._children).iterator());
            }
        }
        catch (CVSConnectionListNode.ClientIOException clientIOException) {
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return null;
    }

    @Override
    public CVSConnectionData getConnection() {
        return this._cache.getConnectionNode().getConnection();
    }

    protected final CVSConnectionNodeCache getNodeCache() {
        return this._cache;
    }

    protected final String getRoot() {
        return this.getConnection().getRoot();
    }

    protected final CVSConnectionDirectoryNode createDirectoryNode(CVSConnectionDirectoryData directoryData) {
        URL url = this.createConnectionFileURL(directoryData.getPath(), null);
        CVSConnectionDirectoryNode directoryNode = new CVSConnectionDirectoryNode(this._cache, directoryData, url);
        return directoryNode;
    }

    private void forceConnectionNodeToCollapse() {
        CVSConnectionNode connectionNode = this._cache.getConnectionNode();
        UpdateMessage.fireObjectClosed((Subject)this);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CVSConnectionDirectoryNode.this.setOpen(false);
            }
        });
        connectionNode.forceNodeToCollapse();
    }

    private void requeryChildren(BrowserModelWorker worker) throws Exception {
        this.uncacheAllChildren();
        this._cache.cache(this._data.getPath(), (Element)this);
        try {
            this.performQuery(worker);
        }
        catch (Exception e) {
            this._cache.uncache(this._data.getPath());
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uncacheAllChildren() {
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            this._children.clear();
        }
        Iterator itr = this._cache.iterator();
        while (itr.hasNext()) {
            String path = (String)itr.next();
            if (!CVSConnectionFilePathUtils.isBasePathFor(this._data.getPath(), path) || this._data.getPath().equals(path)) continue;
            this._cache.uncache(path);
        }
    }

    protected void performQuery(BrowserModelWorker worker) throws Exception {
        CVSConnectionServices services = CVSConnectionServicesFactory.createServices(this.getRoot());
        CVSConnectionFileData[] fileData = null;
        try {
            fileData = services.getDirectoryList(this.getRoot(), this._data.getPath());
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        for (final CVSConnectionFileData fileDataItem : Arrays.asList(fileData)) {
            if (fileDataItem == null) {
                Assert.printStackTrace((Throwable)new IllegalStateException());
                break;
            }
            worker.defer(new Runnable(){

                @Override
                public void run() {
                    if (fileDataItem.isDirectory()) {
                        CVSConnectionDirectoryNode.this.createCachedDirectoryNode((CVSConnectionDirectoryData)fileDataItem);
                    } else {
                        CVSConnectionDirectoryNode.this.createCachedFileNode(fileDataItem);
                    }
                }
            });
        }
    }

    private void createCachedFileNode(CVSConnectionFileData fileData) {
        String path = fileData.getPath();
        URL url = this.createConnectionFileURL(path, fileData.getRevision());
        CVSConnectionFileNode fileNode = new CVSConnectionFileNode(this._cache, fileData, url);
        this._cache.cache(path, (Element)fileNode);
        this.addNodeToParent((Element)fileNode);
    }

    private void createCachedDirectoryNode(CVSConnectionDirectoryData directoryData) {
        this.findOrCreateDirectoryNode(directoryData);
    }

    private CVSConnectionDirectoryNode findOrCreateDirectoryNode(CVSConnectionDirectoryData directoryData) {
        String path = directoryData.getPath();
        Element e = this._cache.find(path);
        if (e != null && e instanceof CVSConnectionDirectoryNode) {
            return (CVSConnectionDirectoryNode)e;
        }
        CVSConnectionDirectoryNode moduleNode = this.createDirectoryNode(directoryData);
        this._cache.cache(path, (Element)moduleNode);
        this.addNodeToParent((Element)moduleNode);
        return moduleNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNodeToParent(Element e) {
        String path = ((CVSConnectionFileData)e.getData()).getPath();
        String parent = CVSConnectionFilePathUtils.getParent(path);
        CVSConnectionDirectoryNode parentDirectoryNode = this.findOrCreateDirectoryNode(new CVSConnectionDirectoryData(parent));
        if (parentDirectoryNode != null) {
            ArrayList arrayList = parentDirectoryNode._children;
            synchronized (arrayList) {
                parentDirectoryNode._children.add(e);
            }
        }
    }

    private URL createConnectionFileURL(String path, String revision) {
        try {
            return CVSConnectionFileURL.toURL(this.getRoot(), path, revision);
        }
        catch (MalformedURLException murle) {
            Assert.printStackTrace((Throwable)murle);
            return null;
        }
    }
}

