/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.login;

import java.awt.Component;
import java.awt.Container;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.InterruptedIOException;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.Assert;
import oracle.jdeveloper.vcs.spi.VCSCancelException;
import oracle.jdeveloper.vcs.spi.VCSDialogCommitter;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdeveloper.vcs.util.VCSOperatingSystem;
import oracle.jdevimpl.vcs.cvs.CVSActiveClient;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSClientInfo;
import oracle.jdevimpl.vcs.cvs.CVSResourcePicker;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.client.CVSAccessPServer;
import oracle.jdevimpl.vcs.cvs.client.CVSRootConversion;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.error.CVSAccessException;
import oracle.jdevimpl.vcs.cvs.error.CVSLoginException;
import oracle.jdevimpl.vcs.cvs.error.CVSServerException;
import oracle.jdevimpl.vcs.cvs.login.CVSAbstractMethod;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionDetailsKey;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodes;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.ui.CVSPasswordDialogUI;
import oracle.jdevimpl.vcs.cvs.util.CVSDialogRunner;
import oracle.jdevimpl.vcs.cvs.util.CVSVersionNumber;
import oracle.ocvs.OCVSCommand;
import oracle.ocvs.OCVSConnection;
import oracle.ocvs.OCVSException;
import oracle.ocvs.OCVSLogStream;
import oracle.ocvs.OCVSOption;
import oracle.ocvs.OCVSPServerConnection;
import oracle.ocvs.OCVSProcessIO;
import oracle.ocvs.OCVSRoot;
import oracle.ocvs.OCVSScramble;

final class CVSPServerMethod
extends CVSAbstractMethod {
    private CVSAccessPServer _access;

    CVSPServerMethod() {
        if (Boolean.getBoolean("jdev.cvs.debugconnectiontest")) {
            OCVSLogStream._clientStream = System.out;
            OCVSLogStream._serverStream = System.err;
        }
    }

    @Override
    protected void doLoginSpi(CVSRootString root, Component parent, Map connectionModel, VCSExceptionHandler exceptionHandler) throws VCSException {
        this.doPServerLogin(root, parent, connectionModel, exceptionHandler);
    }

    @Override
    protected void doLogoutSpi(CVSRootString root) throws VCSException {
        if (this._access == null) {
            return;
        }
        this.doPServerLogout(root);
    }

    @Override
    protected void doLogoutAllSpi() {
        if (this._access == null) {
            return;
        }
        try {
            this.getPServerImplementation().deletePassFile();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    @Override
    protected boolean isLoggedInSpi(CVSRootString root) {
        try {
            return this.getPServerImplementation().searchPassFileRoot(root.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    protected char[] getLoginPasswordSpi(CVSRootString root) throws Exception {
        return this.getPServerImplementation().readPassFileRoot(root.toString());
    }

    @Override
    protected void clearCachedObjectsSpi() {
        this._access = null;
    }

    protected final CVSAccessPServer getPServerImplementation() {
        if (this._access != null) {
            return this._access;
        }
        CVSClient client = CVSClient.getInstance();
        client.verifyClientState();
        this._access = CVSAccessPServer.getGenericInstance();
        if (!CVSActiveClient.isClientCVSNT()) {
            return this._access;
        }
        if (VCSOperatingSystem.isWindows()) {
            CVSVersionNumber versionOfCvsntUsingWindowsRegistry = CVSVersionNumber.createVersionNumber("1.11.1.3", ".");
            CVSClientInfo clientInfo = CVSActiveClient.getClientInformation();
            if (clientInfo.getVersion() != null && clientInfo.getVersion().compareTo(versionOfCvsntUsingWindowsRegistry) >= 0) {
                this._access = CVSAccessPServer.getNTInstance();
            }
            return this._access;
        }
        if (VCSOperatingSystem.isOSX()) {
            this._access = CVSAccessPServer.getOSXInstance();
            return this._access;
        }
        return this._access;
    }

    private void doPServerLogin(CVSRootString root, Component parent, Map connectionModel, VCSExceptionHandler exceptionHandler) throws VCSException {
        try {
            if (this.getPServerImplementation().searchPassFileRoot(root.toString())) {
                this.doPServerLoginFinalization(root, true);
                return;
            }
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
        PServerPasswordDialog dialog = new PServerPasswordDialog(root, parent, connectionModel){

            @Override
            protected void validatePServerPassword(CVSRootString root, char[] password) throws Exception {
                CVSPServerMethod.this._validatePServerPassword(root, password);
            }
        };
        dialog.setExceptionHandler(exceptionHandler);
        if (!dialog.runDialog()) {
            throw new VCSCancelException();
        }
    }

    private void _validatePServerPassword(CVSRootString root, char[] password) throws Exception {
        boolean success = false;
        try {
            PServerLoginWorker worker = new PServerLoginWorker(root, password);
            worker.run();
            worker.forceException();
            success = true;
        }
        catch (UnknownHostException uhe) {
            throw new CVSAccessException(CVSArb.get("ERROR_LOGIN_HOST_UNKNOWN"));
        }
        catch (InterruptedIOException iioe) {
            iioe.printStackTrace();
            throw new CVSAccessException(CVSArb.get("ERROR_LOGIN_SOCKET_TIMEOUT"));
        }
        catch (SocketException se) {
            Assert.printStackTrace((Throwable)se);
            throw new CVSAccessException(CVSArb.get("ERROR_LOGIN_SOCKET_FAILED"), se.toString());
        }
        catch (CVSLoginException le) {
            throw new CVSAccessException(CVSArb.get("ERROR_LOGIN_PSERVER_FAILED"));
        }
        catch (CVSServerException se) {
            throw new CVSAccessException(CVSArb.get("ERROR_LOGIN_PSERVER_FAILED"), se.getMessage());
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.doPServerLoginFinalization(root, success);
        }
    }

    private final void doPServerLoginFinalization(CVSRootString root, boolean success) {
        this.indicateLoginSuccess(root, success);
        CVSUtil.clearPerformanceCaches();
        CVSConnectionNodes.updateOverlays();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doPServerLogout(CVSRootString root) throws VCSException {
        boolean success = false;
        try {
            this.getPServerImplementation().deletePassFileRoot(root.toString());
            success = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        finally {
            this.doPServerLogoutFinalization(root, success);
        }
    }

    private final void doPServerLogoutFinalization(CVSRootString root, boolean success) {
        this.indicateLogoutSuccess(root, success);
        CVSUtil.clearPerformanceCaches();
        CVSConnectionNodes.updateOverlays();
    }

    private void indicateLoginSuccess(CVSRootString root, boolean success) {
        if (!success) {
            return;
        }
        String connection = CVSConnectionNodes.getConnectionListAPI().getRootConnection(root.toString());
        if (connection == null) {
            return;
        }
        Ide.getStatusBar().setText(CVSArb.format("STATUS_PSERVER_LOGIN_SUCCESSFUL", connection));
    }

    private void indicateLogoutSuccess(CVSRootString root, boolean success) {
        if (!success) {
            return;
        }
        String connection = CVSConnectionNodes.getConnectionListAPI().getRootConnection(root.toString());
        if (connection == null) {
            return;
        }
        Ide.getStatusBar().setText(CVSArb.format("STATUS_PSERVER_LOGOUT_SUCCESSFUL", connection));
    }

    private class PServerLoginWorker
    implements Runnable {
        private CVSRootString _root;
        private char[] _password;
        private Exception _exception;

        private PServerLoginWorker(CVSRootString root, char[] password) {
            this._root = root;
            this._password = password;
            this._exception = null;
        }

        @Override
        public final void run() {
            try {
                this.connectAndAuthorize(this._root, this._password);
            }
            catch (Exception e) {
                this._exception = e.getMessage() != null && e.getMessage().indexOf("unknown host") >= 0 ? new UnknownHostException(e.getMessage()) : e;
            }
        }

        private void connectAndAuthorize(CVSRootString rootString, char[] password) throws Exception {
            char[] c = password;
            final char[] spw = OCVSScramble.scramble((char[])password);
            OCVSRoot clientRoot = CVSRootConversion.convertExtensionToClientRootPServer(rootString);
            OCVSCommand command = new OCVSCommand(null){

                public String getCommandId() {
                    return null;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public int executeCommand(OCVSProcessIO io, File dir, Map options, String[] arguments) throws Exception {
                    OCVSRoot root = this.constructRoot(dir, options);
                    if (!root.isAccessPServer()) {
                        throw new IllegalStateException();
                    }
                    OCVSPServerConnection connection = (OCVSPServerConnection)this.createRootConnection(root, null);
                    this.openConnection((OCVSConnection)connection, root);
                    if (Boolean.getBoolean("jdev.cvs.debugconnectiontest")) {
                        connection.startLogging();
                    }
                    try {
                        this.authenticateUserForPServer(connection, root, true, spw);
                        int n = 0;
                        return n;
                    }
                    finally {
                        connection.close();
                    }
                }
            };
            HashMap<OCVSOption, String> options = new HashMap<OCVSOption, String>();
            options.put(OCVSCommand.OPTION_OVERRIDE_CVSROOT, clientRoot.toString());
            options.put(OCVSCommand.OPTION_DO_NOT_EXEC_DISK, null);
            OCVSProcessIO io = new OCVSProcessIO(null, new PrintStream(new PipedOutputStream()), new PrintStream(new PipedOutputStream()));
            try {
                command.executeCommand(io, null, options, new String[0]);
            }
            catch (ProtocolException pe) {
                throw new CVSServerException(pe.getMessage());
            }
            catch (OCVSException ocvse) {
                throw new CVSServerException(ocvse.getMessage());
            }
            CVSPServerMethod.this.getPServerImplementation().writePassFileRoot(rootString.toString(), spw);
        }

        private void forceException() throws Exception {
            if (this._exception != null) {
                throw this._exception;
            }
        }
    }

    private abstract class PServerPasswordDialog {
        private final CVSConnectionData _connection;
        private final CVSRootString _root;
        private final Component _parent;
        private final Map _connectionModel;
        private VCSExceptionHandler _exceptionHandler;

        private PServerPasswordDialog(CVSRootString root, Component parent, Map connectionModel) {
            this._connection = CVSUtil.getRootConnection(root);
            this._root = root;
            this._parent = parent;
            this._connectionModel = connectionModel;
        }

        void setExceptionHandler(VCSExceptionHandler exceptionHandler) {
            this._exceptionHandler = exceptionHandler;
        }

        boolean runDialog() {
            char[] password = this.getRootPassword();
            if (password != null) {
                try {
                    if (this.isEmpty(this._root.getUserName()) || this.isEmpty(this._root.getRepository()) || this.isEmpty(this._root.getServerLocation())) {
                        throw new CVSAccessException(CVSArb.get("ERROR_LOGIN_MALFORMED_CVSROOT"));
                    }
                    this.validatePServerPassword(this._root, password);
                    return true;
                }
                catch (Exception e) {
                    VCSExceptionHandler exceptionHandler = this._exceptionHandler != null ? this._exceptionHandler : new VCSExceptionHandler();
                    exceptionHandler.handleException(e, this._parent);
                }
            }
            final CVSPasswordDialogUI ui = new CVSPasswordDialogUI();
            CVSResourcePicker.getPicker(this).start((Container)ui);
            MessageFormat formatter = new MessageFormat(CVSArb.get("LOGIN_PSERVER_PASSWORD_PROMPT"));
            ui.getPromptLabel().setText(formatter.format(new Object[]{this._root.getServerLocation()}));
            ui.getUserNameField().setText(this._root.getUserName());
            ui.getUserNameField().setEditable(false);
            ui.getRepositoryField().setText(this._root.getRepository());
            ui.getRepositoryField().setEditable(false);
            ui.getUserNameLabel().setLabelFor(ui.getUserNameField());
            ui.getRepositoryLabel().setLabelFor(ui.getRepositoryField());
            ui.getPasswordLabel().setLabelFor(ui.getPasswordField());
            ui.getAutoConnectCheckBox().setSelected(this.isConnectionAutoConnect());
            HelpSystem.getHelpSystem().registerTopic((JComponent)ui, "f1_cvslogin_html");
            JEWTDialog dialog = CVSUtil.createJEWTDialog(this._parent, ui, CVSArb.get("LOGIN_PSERVER_DIALOG_TITLE"), 7);
            dialog.setInitialFocus((Component)ui.getPasswordField());
            dialog.setResizable(false);
            dialog.addVetoableChangeListener((VetoableChangeListener)new VCSDialogCommitter(){

                protected boolean doCommitOperation() throws Exception {
                    return PServerPasswordDialog.this._doCommitOperation(ui);
                }

                protected VCSExceptionHandler getExceptionHandler() {
                    return PServerPasswordDialog.this._exceptionHandler != null ? PServerPasswordDialog.this._exceptionHandler : super.getExceptionHandler();
                }
            });
            return CVSDialogRunner.runDialog((JDialog)dialog);
        }

        protected abstract void validatePServerPassword(CVSRootString var1, char[] var2) throws Exception;

        private boolean isEmpty(String s) {
            return s == null || s.equals("");
        }

        private boolean isConnectionAutoConnect() {
            boolean autoConnect = false;
            if (this._connectionModel != null) {
                Object value = this._connectionModel.get(CVSConnectionDetailsKey.KEY_CONNECTION_AUTO_CONNECT);
                boolean bl = autoConnect = value != null && (Boolean)value != false;
            }
            if (this._connectionModel == null && this._connection != null) {
                autoConnect = this._connection.getAutoConnect();
            }
            return autoConnect;
        }

        private void setConnectionAutoConnect(boolean autoConnect) {
            if (this._connectionModel != null) {
                this._connectionModel.put(CVSConnectionDetailsKey.KEY_CONNECTION_AUTO_CONNECT, autoConnect);
            }
            if (this._connectionModel == null && this._connection != null) {
                this._connection.setAutoConnect(autoConnect);
                CVSConnectionNodes.saveConnectionList();
            }
        }

        private char[] getRootPassword() {
            if (this._connection != null && this._connection.getPassword() != null) {
                return this._connection.getPassword();
            }
            if (this._root.getPassword() != null) {
                return this._root.getPassword();
            }
            return null;
        }

        private boolean _doCommitOperation(final CVSPasswordDialogUI ui) throws Exception {
            this.setConnectionAutoConnect(ui.getAutoConnectCheckBox().isSelected());
            try {
                this.validatePServerPassword(this._root, ui.getPasswordField().getPassword());
            }
            catch (Exception e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ui.getPasswordField().setText("");
                    }
                });
                throw e;
            }
            return true;
        }
    }
}

