/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.control.tagchooser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.SwingUtils;
import oracle.jdevimpl.vcs.cvs.control.tagchooser.CVSTagChooser;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;

public class CVSTagField
extends Box {
    private final JTextField _textField = new JTextField();
    private final JButton _popupButton;
    private CVSTagChooser _chooser;
    private Window _popup;

    public CVSTagField() {
        super(0);
        this._textField.setColumns(15);
        this._popupButton = new JButton(OracleIcons.getIcon((String)"find.png"));
        this._popupButton.getAccessibleContext().setAccessibleName(CVSArb.get("FIND_TAGS_ACCESSIBLE_TEXT"));
        this._popupButton.setToolTipText(CVSArb.get("FIND_TAGS_ACCESSIBLE_TEXT"));
        this._popupButton.setPreferredSize(new Dimension(this._textField.getPreferredSize().height, this._textField.getPreferredSize().height));
        this._popupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (CVSTagField.this._chooser == null) {
                    return;
                }
                final JEWTDialog dialog = new JEWTDialog(SwingUtils.getAncestorDialog((Component)CVSTagField.this), CVSArb.get("TAGS_CHOOSER_TITLE"));
                dialog.setButtonMask(3);
                dialog.setContent(CVSTagField.this._chooser.getGUI());
                dialog.setResizable(true);
                CVSTagField.this._chooser.addBusyStateListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent ce) {
                        this.updateDialogOKEnabled(dialog, CVSTagField.this._chooser);
                    }
                });
                CVSTagField.this._chooser.addSelectionListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent ce) {
                        this.updateDialogOKEnabled(dialog, CVSTagField.this._chooser);
                    }
                });
                if (!dialog.runDialog()) {
                    return;
                }
                String tag = CVSTagField.this._chooser.getTagValue();
                String internalDate = CVSTagField.this._chooser.getDateValueISO8601();
                if (tag != null) {
                    CVSTagField.this._textField.setText(tag);
                }
                if (tag == null && internalDate != null) {
                    CVSTagField.this._textField.setText(CVSTagChooser.internalToExternalDate(internalDate));
                }
            }

            protected void updateDialogOKEnabled(JEWTDialog dialog, CVSTagChooser branchChooser) {
                dialog.setOKButtonEnabled(!branchChooser.isBusy() && (branchChooser.getTagValue() != null || branchChooser.getDateValueISO8601() != null));
            }
        });
        DocumentAdapter documentListener = new DocumentAdapter(){

            private void addDocumentListener() {
                CVSTagField.this._textField.getDocument().addDocumentListener(this);
            }

            private void removeDocumentListener() {
                CVSTagField.this._textField.getDocument().removeDocumentListener(this);
            }

            @Override
            protected void update(final DocumentEvent de) {
                EventQueue.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        this.removeDocumentListener();
                        Document document = de.getDocument();
                        int pos = CVSTagField.this._textField.getCaretPosition();
                        try {
                            if (pos < 0) {
                                return;
                            }
                            String text = CVSTagField.this._textField.getText(0, pos);
                            String match = this.match(text);
                            document.remove(pos, document.getLength() - pos);
                            if (match != null) {
                                document.insertString(pos, match.substring(pos), null);
                            }
                        }
                        catch (BadLocationException ble) {
                            ble.printStackTrace();
                        }
                        finally {
                            CVSTagField.this._textField.setCaretPosition(document.getLength());
                            CVSTagField.this._textField.moveCaretPosition(pos);
                            this.addDocumentListener();
                        }
                    }

                    private String match(String text) {
                        if (text.equals("")) {
                            return null;
                        }
                        for (String tag : CVSTagField.this._chooser.getAvailableTags()) {
                            if (!tag.startsWith(text)) continue;
                            return tag;
                        }
                        for (String internalDate : CVSTagField.this._chooser.getAvailableDatesISO8601()) {
                            String externalDate = CVSTagChooser.internalToExternalDate(internalDate);
                            if (!externalDate.startsWith(text)) continue;
                            return externalDate;
                        }
                        return null;
                    }
                });
            }
        };
        this._textField.getDocument().addDocumentListener(documentListener);
        this.add(this._textField);
        this.add(Box.createHorizontalStrut(2));
        this.add(this._popupButton);
        this.setFocusable(false);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._textField.setEnabled(enabled);
        this._popupButton.setEnabled(enabled);
        if (!enabled) {
            this.hidePopup();
        }
    }

    public JTextField getTextField() {
        return this._textField;
    }

    private void hidePopup() {
        if (this._popup == null) {
            return;
        }
        this._popup.setVisible(false);
        this._popup = null;
    }

    public void start(CVSTagChooser chooser) {
        if (this._chooser != null) {
            this.stop();
        }
        this._chooser = chooser;
        this._chooser.start();
    }

    public void stop() {
        if (this._chooser.isStarted()) {
            this._chooser.stop();
        }
    }

    public String getNameOrTagValue() {
        String date = this.getDateValueISO8601();
        return date != null ? null : this._textField.getText();
    }

    public String getDateValueISO8601() {
        String text = this._textField.getText();
        for (String internalDate : this._chooser.getAvailableDatesISO8601()) {
            if (!CVSTagChooser.internalToExternalDate(internalDate).equals(text)) continue;
            return internalDate;
        }
        return null;
    }

    private static abstract class DocumentAdapter
    implements DocumentListener {
        private DocumentAdapter() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update(e);
        }

        protected abstract void update(DocumentEvent var1);
    }
}

