/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.control.tagchooser;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.dateEditor.DateEditor;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.Assert;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.SearchMatcher;
import oracle.javatools.util.SwingUtils;
import oracle.javatools.util.Version;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSURLFilters;
import oracle.jdevimpl.vcs.cvs.CVSEntriesCache;
import oracle.jdevimpl.vcs.cvs.client.CVSEntry;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.control.tagchooser.CVSBaseTagView;
import oracle.jdevimpl.vcs.cvs.control.tagchooser.CVSTagActions;
import oracle.jdevimpl.vcs.cvs.control.tagchooser.CVSTagCache;
import oracle.jdevimpl.vcs.cvs.control.tagchooser.CVSTagCategory;
import oracle.jdevimpl.vcs.cvs.control.tagchooser.CVSTagListView;
import oracle.jdevimpl.vcs.cvs.control.tagchooser.CVSTagNode;
import oracle.jdevimpl.vcs.cvs.control.tagchooser.CVSTagTreeView;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.runner.CVSInternalClientRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcess;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcessStreamMonitor;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerFactory;
import oracle.jdevimpl.vcs.cvs.util.date.CVSISODateFormat;
import oracle.ocvs.OCVSPrompter;
import oracle.ocvs.OCVSRoot;

public class CVSTagChooser {
    private static final String GUI_BUSY = "busy";
    private static final String GUI_TAGS = "tags";
    private static final String DATE_DTCACHE_KEY = "CVS.DateCache";
    private final URL[] _urls;
    private SearchField _tagSearchField;
    private JButton _refreshTagsButton;
    private JButton _findMoreTagsButton;
    private JButton _addDateButton;
    private Collection<URL> _coalesceUrls;
    private Collection<URL> _currentQueryUrls;
    private CVSBaseTagView _view;
    private Collection<CVSTagCategory> _categories;
    private final CVSTagActions _actions = new CVSTagActions(this);
    private JPanel _panel;
    private Collection<CVSTagNode> _model;
    private boolean _busy;
    private Collection<ChangeListener> _busyStateListeners = new ArrayList<ChangeListener>();
    private Collection<ChangeListener> _selectionListeners = new ArrayList<ChangeListener>();
    private Collection<ActionListener> _closeActionListeners = new ArrayList<ActionListener>();
    private CardLayout _cardLayout;
    private JPanel _cardLayoutPanel;
    private String _initialTagValue;
    private Boolean _started;
    private CVSRootString _contextRoot;
    private String _moduleName;
    private String _rcsPath;
    private boolean _recursive;

    static final String internalToExternalDate(String internalDate) {
        try {
            Date date = new CVSISODateFormat().parse(internalDate);
            String externalDate = new ExternalDateFormat().format(date);
            externalDate = externalDate + CVSTagChooser.extractTimeZone(internalDate);
            return externalDate;
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            return "";
        }
    }

    static final String externalToInternalDate(String externalDate) {
        try {
            Date date = new ExternalDateFormat().parse(externalDate);
            String internalDate = new CVSISODateFormat().format(date);
            internalDate = internalDate + CVSTagChooser.extractTimeZone(externalDate);
            return internalDate;
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            return "";
        }
    }

    private static final String extractTimeZone(String date) {
        return date.substring(date.lastIndexOf(32));
    }

    public CVSTagChooser(CVSTagCategory[] categories, ViewMode viewMode) {
        this(categories, null, null, null, viewMode);
    }

    public CVSTagChooser(CVSTagCategory[] categories, URL[] urls, ViewMode viewMode) {
        this(categories, urls, null, null, viewMode);
    }

    public CVSTagChooser(CVSTagCategory[] categories, CVSRootString contextRoot, String moduleName, ViewMode viewMode) {
        this(categories, null, contextRoot, moduleName, viewMode);
    }

    private CVSTagChooser(CVSTagCategory[] categories, URL[] urls, CVSRootString contextRoot, String moduleName, ViewMode viewMode) {
        this._categories = Arrays.asList(categories);
        this._urls = urls;
        this._contextRoot = contextRoot;
        this._moduleName = moduleName;
        if (contextRoot != null && moduleName != null) {
            String rootRepository = contextRoot.getRepository() != null ? contextRoot.getRepository() : contextRoot.toString();
            this._rcsPath = rootRepository + '/' + moduleName;
            if (!this._rcsPath.endsWith("/")) {
                this._rcsPath = this._rcsPath + '/';
            }
        }
        this._view = viewMode == ViewMode.TREE ? new CVSTagTreeView() : new CVSTagListView();
        this._view.setCategories(this._categories);
        this._view.setActions(this._actions);
        this._view.initializeView();
        this._view.setSelectionListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                ChangeListener[] l = CVSTagChooser.this._selectionListeners.toArray(new ChangeListener[0]);
                for (int i = l.length - 1; i >= 0; --i) {
                    l[i].stateChanged(new ChangeEvent(this));
                }
            }
        });
        this.setBusy(true);
    }

    private List<String> getDateCache() {
        ArrayList cache = (ArrayList)Ide.getDTCache().getData(DATE_DTCACHE_KEY);
        if (cache == null) {
            cache = new ArrayList();
            Ide.getDTCache().putData(DATE_DTCACHE_KEY, cache);
        }
        return cache;
    }

    public Component getGUI() {
        if (this._panel != null) {
            return this._panel;
        }
        this._panel = new JPanel(new BorderLayout(4, 4));
        this._tagSearchField = new SearchField();
        this._tagSearchField.setStyle(SearchField.Style.FILTER);
        this._tagSearchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent event) {
                if (CVSTagChooser.this._model == null) {
                    return;
                }
                String searchText = event.getSearchText();
                if (searchText.equals("")) {
                    CVSTagChooser.this._view.setModel(CVSTagChooser.this._model);
                    CVSTagChooser.this._view.selectFirstNode();
                    return;
                }
                SearchMatcher matcher = SearchMatcher.getPrefixMatcher((CharSequence)searchText, (boolean)true, (boolean)true);
                ArrayList<CVSTagNode> model = new ArrayList<CVSTagNode>(CVSTagChooser.this._model);
                Iterator itr = model.iterator();
                while (itr.hasNext()) {
                    CVSTagNode node = (CVSTagNode)itr.next();
                    String tagName = node.getTag() != null ? node.getTag().getName() : CVSTagChooser.internalToExternalDate(node.getDate());
                    if (matcher.matches((CharSequence)tagName)) continue;
                    itr.remove();
                }
                CVSTagChooser.this._view.setModel(model);
                CVSTagChooser.this._view.selectFirstNode();
            }

            public void searchCategoryChanged(SearchEvent se) {
            }
        });
        this._tagSearchField.getTextField().setColumns(15);
        if (this._urls != null || this._rcsPath != null) {
            this._refreshTagsButton = new JButton();
            this._findMoreTagsButton = new JButton();
        }
        if (this._categories.contains((Object)CVSTagCategory.DATE)) {
            this._addDateButton = new JButton();
        }
        if (this._refreshTagsButton != null) {
            this._refreshTagsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    CVSTagChooser.this.refreshTags();
                }
            });
        }
        if (this._findMoreTagsButton != null) {
            this._findMoreTagsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    CVSTagChooser.this.findMoreTags();
                }
            });
        }
        if (this._categories.contains((Object)CVSTagCategory.DATE)) {
            this._addDateButton.setAction(this._actions.getAddDateAction());
        }
        if (this._refreshTagsButton != null) {
            ResourceUtils.resButton((AbstractButton)this._refreshTagsButton, (String)CVSArb.get("REFRESH_TAGS"));
        }
        if (this._findMoreTagsButton != null) {
            ResourceUtils.resButton((AbstractButton)this._findMoreTagsButton, (String)CVSArb.get("FIND_MORE_TAGS"));
        }
        if (this._categories.contains((Object)CVSTagCategory.DATE)) {
            ResourceUtils.resButton((AbstractButton)this._addDateButton, (String)CVSArb.get("ADD_DATE"));
        }
        Box buttonPanel = Box.createHorizontalBox();
        if (this._refreshTagsButton != null) {
            buttonPanel.add(this._refreshTagsButton);
        }
        if (this._findMoreTagsButton != null) {
            buttonPanel.add(Box.createHorizontalStrut(4));
            buttonPanel.add(this._findMoreTagsButton);
        }
        if (this._categories.contains((Object)CVSTagCategory.DATE)) {
            buttonPanel.add(Box.createHorizontalStrut(4));
            buttonPanel.add(this._addDateButton);
        }
        JLabel busyLabel = new JLabel(CVSArb.get("LOADING"), OracleIcons.getIcon((String)"throbber.gif"), 0);
        busyLabel.setBackground(UIManager.getColor("window"));
        busyLabel.setForeground(UIManager.getColor("textText"));
        busyLabel.setBorder(UIManager.getBorder("ScrollPane.border"));
        busyLabel.setOpaque(true);
        this._cardLayout = new CardLayout();
        this._cardLayoutPanel = new JPanel(this._cardLayout);
        this._cardLayoutPanel.add((Component)busyLabel, GUI_BUSY);
        this._cardLayoutPanel.add(this._view.getGUI(), GUI_TAGS);
        Box north = Box.createHorizontalBox();
        north.add((Component)this._tagSearchField);
        if (buttonPanel.getComponentCount() > 0) {
            north.add(Box.createHorizontalStrut(4));
            north.add(buttonPanel);
        }
        this._panel.add((Component)north, "North");
        this._panel.add((Component)this._cardLayoutPanel, "Center");
        busyLabel.setMinimumSize(this._view.getGUI().getPreferredSize());
        this._setBusy(this._busy);
        this._panel.setAlignmentX(0.0f);
        this._panel.setAlignmentY(0.0f);
        return this._panel;
    }

    public Component getInitialFocusComponent() {
        this.getGUI();
        return this._tagSearchField;
    }

    public void setInitialTagValue(String initialTagValue) {
        this._initialTagValue = initialTagValue;
    }

    public void start() {
        this._started = true;
        this.findTags();
    }

    public boolean isStarted() {
        return this._started != null && this._started != false;
    }

    public void stop() {
        this._started = false;
    }

    public String getTagValue() {
        CVSTagNode node = this.getSelectedNode();
        return node != null && node.getTag() != null ? node.getTag().getName() : null;
    }

    public String getDateValueISO8601() {
        CVSTagNode node = this.getSelectedNode();
        return node != null ? node.getDate() : null;
    }

    private void findTags() {
        if (this._urls != null || this._rcsPath == null) {
            // empty if block
        }
        if (this._urls != null && this._rcsPath != null) {
            this._rcsPath = null;
        }
        if (this._urls == null && this._rcsPath != null) {
            this._currentQueryUrls = Collections.singleton(this.createRemoteURL(this._rcsPath));
        }
        if (this._urls != null && this._rcsPath == null) {
            this._coalesceUrls = Arrays.asList(VCSFileSystemUtils.coalesceURLs((URL[])this._urls));
            ArrayList<URL> urlsToQuery = new ArrayList<URL>();
            block0: for (URL url : this._coalesceUrls) {
                class EntryIterator
                implements Iterator<URL> {
                    private URL _next;
                    private LinkedList<URL> _entries = new LinkedList();
                    private LinkedList<URL> _directoryStack = new LinkedList();

                    EntryIterator(URL url) {
                        if (URLFileSystem.isDirectoryPath((URL)url)) {
                            this._directoryStack.add(url);
                        } else {
                            try {
                                CVSEntry entry = CVSEntriesCache.findEntry(CVSEntriesCache.getInstance().getEntriesMap(URLFileSystem.getParent((URL)url)), url);
                                if (entry != null && this.isReturnableEntry(entry, url)) {
                                    this._entries.addFirst(url);
                                }
                            }
                            catch (IOException ioe) {
                                ioe.printStackTrace();
                            }
                        }
                        this._next();
                    }

                    private boolean isReturnableEntry(CVSEntry entry, URL entryUrl) {
                        if (entry.getName().startsWith(".")) {
                            return false;
                        }
                        return !entry.isDirectory() && !entry.isRemoved() && URLFileSystem.exists((URL)entryUrl) && !URLFileSystem.isDirectory((URL)entryUrl);
                    }

                    @Override
                    public boolean hasNext() {
                        return this._next != null;
                    }

                    @Override
                    public URL next() {
                        URL next = this._next;
                        this._next();
                        return next;
                    }

                    private void _next() {
                        if (!this._entries.isEmpty()) {
                            this._next = this._entries.removeFirst();
                            return;
                        }
                        if (this._directoryStack.isEmpty()) {
                            this._next = null;
                            return;
                        }
                        URL directoryUrl = this._directoryStack.removeFirst();
                        try {
                            ArrayList<CVSEntry> entries = new ArrayList<CVSEntry>(CVSEntriesCache.getInstance().getEntriesMap(directoryUrl).values());
                            Collections.sort(entries, new Comparator<CVSEntry>(){

                                @Override
                                public int compare(CVSEntry entry1, CVSEntry entry2) {
                                    return -entry1.getName().compareTo(entry2.getName());
                                }
                            });
                            for (CVSEntry entry : entries) {
                                if (entry.getName().startsWith(".")) continue;
                                URL entryUrl = URLFactory.newURL((URL)directoryUrl, (String)entry.getName());
                                if (entry.isDirectory() && URLFileSystem.isDirectory((URL)entryUrl)) {
                                    this._directoryStack.addFirst(entryUrl);
                                }
                                if (!this.isReturnableEntry(entry, entryUrl)) continue;
                                this._entries.addFirst(entryUrl);
                            }
                            this._next();
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                }
                EntryIterator itr = new EntryIterator(url);
                while (itr.hasNext()) {
                    urlsToQuery.add((URL)itr.next());
                    if (urlsToQuery.size() < 3) continue;
                    break block0;
                }
            }
            this._currentQueryUrls = urlsToQuery;
            if (this.isQueryURLsSameAsCoalesceURLs(this._currentQueryUrls, this._coalesceUrls)) {
                this._currentQueryUrls = this._coalesceUrls;
            }
        }
        this.query();
    }

    private boolean isQueryURLsSameAsCoalesceURLs(Collection<URL> c1, Collection<URL> c2) {
        if (c1.size() != c2.size()) {
            return false;
        }
        Iterator<URL> itr1 = c1.iterator();
        Iterator<URL> itr2 = c2.iterator();
        while (itr1.hasNext()) {
            URL url1 = itr1.next();
            URL url2 = itr2.next();
            if (url1.toExternalForm().equals(url2.toExternalForm())) continue;
            return false;
        }
        return true;
    }

    private void query() {
        this.setBusy(true);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    CVSTagChooser.this._query();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        new Thread(r, "CVSTagChooser").start();
    }

    private void _query() throws Exception {
        CVSTagNode item;
        final HashSet<CVSTagCache.Tag> resultTags = new HashSet<CVSTagCache.Tag>();
        if (this._urls != null || this._rcsPath == null) {
            // empty if block
        }
        if (this._urls != null && this._rcsPath != null) {
            this._rcsPath = null;
        }
        if (this._urls == null && this._rcsPath != null) {
            final URL urlToQuery = this._currentQueryUrls.iterator().next();
            Collection<CVSTagCache.Tag> tags = CVSTagCache.getInstance().get(new URLFilter(){

                public boolean accept(URL url) {
                    return url.getProtocol().equals(urlToQuery.getProtocol()) && url.getPath().startsWith(urlToQuery.getPath());
                }
            });
            if (tags != null && !tags.isEmpty()) {
                resultTags.addAll(tags);
            } else {
                CVSRunner cVSRunner = this.createRunner(null, this._contextRoot);
                ArrayList<String> cmd = new ArrayList<String>();
                cmd.add("rlog");
                cmd.add("-h");
                if (!this._recursive) {
                    cmd.add("-l");
                }
                cmd.add(this._moduleName);
                cVSRunner.setCmdList_(cmd);
                cVSRunner.addOutputMonitor(new CVSProcessStreamMonitor(){
                    private final Pattern _pattern1 = Pattern.compile("RCS file: (.*)");
                    private final Pattern _pattern2 = Pattern.compile("\\t(.+?): (.*)");
                    private String _currentRcsFile;

                    @Override
                    protected void streamLine(String line, CVSProcess process) throws Exception {
                        Matcher matcher = this._pattern1.matcher(line);
                        if (matcher.matches()) {
                            this._currentRcsFile = matcher.group(1);
                        }
                        if (!(matcher = this._pattern2.matcher(line)).matches()) {
                            return;
                        }
                        if (this._currentRcsFile == null) {
                            Assert.fail();
                            return;
                        }
                        CVSTagCache.Tag tag = CVSTagChooser.this.createTag(matcher.group(1), matcher.group(2));
                        resultTags.add(tag);
                        CVSTagCache.getInstance().cache(CVSTagChooser.this.createRemoteURL(this._currentRcsFile), tag);
                    }
                });
                cVSRunner.exec_();
            }
        }
        if (this._urls != null && this._rcsPath == null) {
            for (URL urlToQuery : this._currentQueryUrls) {
                if (this._started != null && !this._started.booleanValue()) {
                    return;
                }
                if (this._currentQueryUrls != this._coalesceUrls && URLFileSystem.isDirectoryPath((URL)urlToQuery)) {
                    resultTags.addAll(CVSTagCache.getInstance().get(VCSURLFilters.createBaseURLContentsFilter((URL[])new URL[]{urlToQuery})));
                    continue;
                }
                final URL uRL = URLFileSystem.isDirectoryPath((URL)urlToQuery) ? urlToQuery : URLFileSystem.getParent((URL)urlToQuery);
                CVSRunner runner = this.createRunner(uRL, null);
                ArrayList<String> cmd = new ArrayList<String>();
                cmd.add("log");
                cmd.add("-h");
                if (!URLFileSystem.isDirectoryPath((URL)urlToQuery)) {
                    cmd.add(URLFileSystem.getFileName((URL)urlToQuery));
                }
                runner.setCmdList_(cmd);
                runner.addOutputMonitor(new CVSProcessStreamMonitor(){
                    private final Pattern _pattern1 = Pattern.compile("Working file: (.*)");
                    private final Pattern _pattern2 = Pattern.compile("\\t(.+?): (.*)");
                    private URL _currentUrl;

                    @Override
                    protected void streamLine(String line, CVSProcess process) throws Exception {
                        Matcher matcher = this._pattern1.matcher(line);
                        if (matcher.matches()) {
                            this._currentUrl = URLFactory.newURL((URL)uRL, (String)matcher.group(1));
                        }
                        if (!(matcher = this._pattern2.matcher(line)).matches()) {
                            return;
                        }
                        if (this._currentUrl == null) {
                            Assert.fail();
                            return;
                        }
                        CVSTagCache.Tag tag = CVSTagChooser.this.createTag(matcher.group(1), matcher.group(2));
                        resultTags.add(tag);
                        CVSTagCache.getInstance().cache(this._currentUrl, tag);
                    }
                });
                runner.exec_();
            }
        }
        final ArrayList<Object> model = new ArrayList<Object>();
        if (this._categories.contains((Object)CVSTagCategory.HEAD)) {
            Iterator item2 = new CVSTagNode(CVSTagCategory.HEAD);
            CVSTagCache.Tag tag = new CVSTagCache.Tag("HEAD");
            ((CVSTagNode)((Object)item2)).setTag(tag);
            ((CVSTagNode)((Object)item2)).setIcon(OracleIcons.getIcon((String)"branch.png"));
            model.add(item2);
        }
        if (this._categories.contains((Object)CVSTagCategory.BRANCH)) {
            for (CVSTagCache.Tag tag : resultTags) {
                if (!tag.isBranch()) continue;
                item = new CVSTagNode(CVSTagCategory.BRANCH);
                item.setTag(tag);
                item.setIcon(OracleIcons.getIcon((String)"branch.png"));
                model.add(item);
            }
        }
        if (this._categories.contains((Object)CVSTagCategory.VERSION)) {
            for (CVSTagCache.Tag tag : resultTags) {
                if (tag.isBranch()) continue;
                item = new CVSTagNode(CVSTagCategory.VERSION);
                item.setTag(tag);
                item.setIcon(OracleIcons.getIcon((String)"label.png"));
                model.add(item);
            }
        }
        if (this._categories.contains((Object)CVSTagCategory.DATE)) {
            ArrayList<String> dateCache = new ArrayList<String>(this.getDateCache());
            Collections.sort(dateCache);
            for (String date : dateCache) {
                CVSTagNode item3 = new CVSTagNode(CVSTagCategory.DATE);
                item3.setIcon(OracleIcons.getIcon((String)"history.png"));
                item3.setDate(date);
                model.add(item3);
            }
        }
        if (this._categories.contains((Object)CVSTagCategory.BASE)) {
            CVSTagNode item2 = new CVSTagNode(CVSTagCategory.BASE);
            CVSTagCache.Tag tag = new CVSTagCache.Tag("BASE");
            item2.setTag(tag);
            item2.setIcon(OracleIcons.getIcon((String)"label.png"));
            model.add(item2);
        }
        Collections.sort((List)model, new NodeComparator());
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CVSTagChooser.this._tagSearchField != null) {
                    CVSTagChooser.this._tagSearchField.clear();
                }
                CVSTagChooser.this._model = model;
                CVSTagChooser.this._view.setModel(CVSTagChooser.this._model);
                if (CVSTagChooser.this._initialTagValue != null) {
                    CVSTagCache.Tag tagObject = new CVSTagCache.Tag(CVSTagChooser.this._initialTagValue);
                    for (CVSTagNode node : CVSTagChooser.this._model) {
                        if (node.getTag() == null || !tagObject.equals(node.getTag())) continue;
                        CVSTagChooser.this._view.selectNode(node);
                        break;
                    }
                } else {
                    CVSTagChooser.this._view.selectFirstNode();
                }
                CVSTagChooser.this.setBusy(false);
                if (CVSTagChooser.this._tagSearchField != null) {
                    CVSTagChooser.this._tagSearchField.requestFocus();
                }
                if (CVSTagChooser.this._tagSearchField == null && CVSTagChooser.this._view != null) {
                    CVSTagChooser.this._view.requestFocus();
                }
            }
        });
    }

    private URL createRemoteURL(String rcsPath) {
        return URLFactory.newURL((String)"ide.scm.cvs.,v", (String)rcsPath);
    }

    private CVSRunner createRunner(URL directoryUrl, CVSRootString contextRoot) {
        CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        runner.getParameters().setQuiet(true);
        if (runner instanceof CVSInternalClientRunner) {
            ((CVSInternalClientRunner)runner).setPrompter(new CancelPrompter());
        }
        runner.getParameters().setKeepCachedFiles(true);
        if (directoryUrl != null) {
            runner.setDirURL_(directoryUrl);
        }
        if (contextRoot != null) {
            runner.getParameters().setRoot(contextRoot.toString());
        }
        return runner;
    }

    private CVSTagCache.Tag createTag(String name, String revision) throws NumberFormatException {
        Version version = new Version(revision);
        int[] parts = version.toIntArray();
        int n = parts.length;
        for (int i : parts) {
            if (i != 0) continue;
            --n;
        }
        CVSTagCache.Tag tag = new CVSTagCache.Tag();
        tag.setName(name);
        tag.setBranch(n % 2 != 0);
        return tag;
    }

    private void findMoreTags() {
        if (this._rcsPath != null) {
            this._recursive = true;
            this.refreshTags();
        } else {
            this._currentQueryUrls = this._coalesceUrls;
        }
        this.query();
    }

    private void refreshTags() {
        if (this._rcsPath != null) {
            CVSTagCache.getInstance().clear(new URLFilter(){

                public boolean accept(URL url) {
                    return url.getProtocol().equals("ide.scm.cvs.,v");
                }
            });
        } else {
            CVSTagCache.getInstance().clear(VCSURLFilters.createBaseURLContentsFilter((URL[])this._currentQueryUrls.toArray(new URL[0])));
        }
        this.query();
    }

    CVSTagNode getSelectedNode() {
        return this._view.getSelectedNode();
    }

    void requestFocusInView() {
        this._view.requestFocus();
    }

    void addDate() {
        JLabel dateLabel = new JLabel();
        JLabel timeZoneLabel = new JLabel();
        JRadioButton localRadioButton = new JRadioButton();
        JRadioButton utcRadioButton = new JRadioButton();
        DateEditor dateEditor = new DateEditor(new Date(), Calendar.getInstance(), (DateFormat)new ExternalDateFormat());
        Box panel = Box.createHorizontalBox();
        panel.add(dateLabel);
        panel.add(Box.createHorizontalStrut(4));
        panel.add((Component)dateEditor);
        panel.add(Box.createHorizontalStrut(4));
        panel.add(localRadioButton);
        panel.add(Box.createHorizontalStrut(4));
        panel.add(utcRadioButton);
        ResourceUtils.resLabel((JLabel)dateLabel, (Component)dateEditor, (String)CVSArb.get("DATE"));
        ResourceUtils.resLabel((JLabel)timeZoneLabel, (Component)timeZoneLabel, (String)CVSArb.get("TIME_ZONE"));
        ResourceUtils.resButton((AbstractButton)localRadioButton, (String)CVSArb.get("LOCAL"));
        ResourceUtils.resButton((AbstractButton)utcRadioButton, (String)CVSArb.get("UTC"));
        ButtonGroup bg = new ButtonGroup();
        bg.add(localRadioButton);
        bg.add(utcRadioButton);
        localRadioButton.setSelected(true);
        JEWTDialog dialog = new JEWTDialog(SwingUtils.getAncestorDialog((Component)this.getGUI()), CVSArb.get("ADD_DATE_TITLE"));
        dialog.setButtonMask(3);
        dialog.setContent((Component)panel);
        if (!dialog.runDialog()) {
            return;
        }
        String externalDate = dateEditor.getDateString();
        externalDate = utcRadioButton.isSelected() ? externalDate + " GMT" : externalDate + new SimpleDateFormat(" zzz").format(new Date());
        String internalDate = CVSTagChooser.externalToInternalDate(externalDate);
        CVSTagNode item = new CVSTagNode(CVSTagCategory.DATE);
        item.setIcon(OracleIcons.getIcon((String)"history.png"));
        item.setDate(internalDate);
        ArrayList<CVSTagNode> model = new ArrayList<CVSTagNode>(this._model);
        model.add(item);
        Collections.sort((List)model, new NodeComparator());
        if (this._tagSearchField != null) {
            this._tagSearchField.clear();
        }
        this._model = model;
        this._view.setModel(this._model);
        this._view.selectNode(item);
        this.getDateCache().add(internalDate);
        Ide.getDTCache().save();
    }

    void removeSelectedDate() {
        String internalDate;
        CVSTagNode node = this.getSelectedNode();
        String string = internalDate = node != null ? node.getDate() : null;
        assert (internalDate != null);
        this._model.remove(node);
        this._view.removeSelectedNode();
        this.getDateCache().remove(internalDate);
        Ide.getDTCache().save();
    }

    public void addBusyStateListener(ChangeListener l) {
        this._busyStateListeners.add(l);
    }

    public void removeBusyStateListener(ChangeListener l) {
        this._busyStateListeners.remove(l);
    }

    public void addSelectionListener(ChangeListener l) {
        this._selectionListeners.add(l);
    }

    public void removeSelectionListener(ChangeListener l) {
        this._selectionListeners.remove(l);
    }

    public void addCloseActionListener(ActionListener l) {
        this._closeActionListeners.add(l);
    }

    public void removeCloseActionListener(ActionListener l) {
        this._closeActionListeners.remove(l);
    }

    public boolean isBusy() {
        return this._busy;
    }

    private void setBusy(boolean busy) {
        if (busy == this._busy) {
            return;
        }
        this._busy = busy;
        this._setBusy(busy);
        ChangeListener[] l = this._busyStateListeners.toArray(new ChangeListener[0]);
        for (int i = l.length - 1; i >= 0; --i) {
            l[i].stateChanged(new ChangeEvent(this));
        }
    }

    private void _setBusy(boolean busy) {
        if (this._panel == null) {
            return;
        }
        this._cardLayout.show(this._cardLayoutPanel, busy ? GUI_BUSY : GUI_TAGS);
        this._view.setBusy(busy);
        this._tagSearchField.setEnabled(!busy);
        this._tagSearchField.getTextField().setEnabled(!busy);
        if (this._refreshTagsButton != null) {
            this._refreshTagsButton.setEnabled(!busy);
        }
        if (this._findMoreTagsButton != null) {
            if (this._rcsPath != null) {
                this._findMoreTagsButton.setEnabled(!this._recursive && !busy);
            } else {
                this._findMoreTagsButton.setEnabled(this._currentQueryUrls != this._coalesceUrls && !busy);
            }
        }
        if (this._categories.contains((Object)CVSTagCategory.DATE)) {
            this._addDateButton.setEnabled(!busy);
        }
    }

    Collection<CVSTagNode> getModel() {
        return this._model != null ? new ArrayList<CVSTagNode>(this._model) : new ArrayList();
    }

    Collection<String> getAvailableTags() {
        ArrayList<String> tags = new ArrayList<String>();
        if (this._model == null) {
            return tags;
        }
        for (CVSTagNode node : this._model) {
            if (node.getTag() == null) continue;
            tags.add(node.getTag().getName());
        }
        return tags;
    }

    Collection<String> getAvailableDatesISO8601() {
        ArrayList<String> tags = new ArrayList<String>();
        if (this._model == null) {
            return tags;
        }
        for (CVSTagNode node : this._model) {
            if (node.getDate() == null) continue;
            tags.add(node.getDate());
        }
        return tags;
    }

    private class CancelPrompter
    extends OCVSPrompter {
        private CancelPrompter() {
        }

        public char[] promptPassword(OCVSRoot root, String message) {
            return null;
        }

        public boolean promptSsh2YesNo(String message) {
            return false;
        }

        public char[] promptSsh2Passphrase(String message) {
            return null;
        }

        public char[] promptSsh2Password(String message) {
            return null;
        }
    }

    private class NodeComparator
    implements Comparator<CVSTagNode> {
        private NodeComparator() {
        }

        @Override
        public int compare(CVSTagNode node1, CVSTagNode node2) {
            int weight2;
            int weight1 = this.getCategoryWeight(node1.getCategory());
            if (weight1 != (weight2 = this.getCategoryWeight(node2.getCategory()))) {
                return weight1 - weight2;
            }
            if (node1.getTag() != null) {
                return node1.getTag().compareTo(node2.getTag());
            }
            if (node1.getDate() != null) {
                return node1.getDate().compareTo(node2.getDate());
            }
            return 0;
        }

        private int getCategoryWeight(CVSTagCategory category) {
            if (category.equals((Object)CVSTagCategory.HEAD)) {
                return 1;
            }
            if (category.equals((Object)CVSTagCategory.BRANCH)) {
                return 2;
            }
            if (category.equals((Object)CVSTagCategory.VERSION)) {
                return 3;
            }
            if (category.equals((Object)CVSTagCategory.DATE)) {
                return 4;
            }
            if (category.equals((Object)CVSTagCategory.BASE)) {
                return 5;
            }
            return -1;
        }
    }

    private static class ExternalDateFormat
    extends SimpleDateFormat {
        ExternalDateFormat() {
            super("dd MMM yyyy kk:mm");
        }
    }

    public static enum ViewMode {
        TREE,
        LIST;

    }
}

