/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.control;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.controls.FocusableLabel;
import oracle.ide.controls.SortedListModel;
import oracle.ide.controls.WaitCursor;
import oracle.ide.util.Assert;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.SwingWorker;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.SearchMatcher;
import oracle.jdeveloper.vcs.spi.VCSCancelException;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.error.CVSNavServicesException;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionElement;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionFileData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodeUtils;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodes;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;

public class CVSModuleSelectionPanel
extends JPanel {
    private static final String GUI_LIST = "list";
    private static final String GUI_MESSAGE = "message";
    private static final String GUI_BUSY = "busy";
    private final Collection _connectionsWithRecentModuleLists = new ArrayList();
    private final ArrayList _moduleNameChangeListeners = new ArrayList();
    private final JTextField _moduleNameTextField = new JTextField();
    private final JList _moduleNameList = new JList();
    private final JButton _refreshModuleListButton = new JButton();
    private final Map _moduleFileDataCache = new WeakHashMap();
    private final ListSelectionListener _listSelectionListener;
    private final FocusableLabel _moduleMessageLabel = new FocusableLabel(" ");
    private final JPanel _moduleNameGui = new JPanel();
    private final CardLayout _moduleNameListLayout = new CardLayout();
    private Component _parent;
    private String _connectionName = "";
    private SortedListModel _moduleNameListModel;
    private SearchField _moduleSearchField = new SearchField();

    public CVSModuleSelectionPanel() {
        this((Component)null);
    }

    public CVSModuleSelectionPanel(Component parent) {
        this._moduleSearchField.setStyle(SearchField.Style.FILTER);
        this._moduleSearchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent event) {
                if (CVSModuleSelectionPanel.this._moduleNameListModel == null) {
                    return;
                }
                String searchText = event.getSearchText();
                if (searchText.equals("")) {
                    CVSModuleSelectionPanel.this._moduleNameList.setModel(CVSModuleSelectionPanel.this._moduleNameListModel);
                    return;
                }
                SearchMatcher matcher = SearchMatcher.getPrefixMatcher((CharSequence)searchText, (boolean)true, (boolean)true);
                DefaultListModel<Object> model = new DefaultListModel<Object>();
                for (int i = 0; i < CVSModuleSelectionPanel.this._moduleNameListModel.getSize(); ++i) {
                    if (!matcher.matches((CharSequence)((String)CVSModuleSelectionPanel.this._moduleNameListModel.getElementAt(i)))) continue;
                    model.addElement(CVSModuleSelectionPanel.this._moduleNameListModel.getElementAt(i));
                }
                CVSModuleSelectionPanel.this._moduleNameList.setModel(model);
                if (CVSModuleSelectionPanel.this._moduleNameListModel.size() > 0) {
                    CVSModuleSelectionPanel.this._moduleNameList.setSelectedIndex(0);
                }
            }

            public void searchCategoryChanged(SearchEvent se) {
            }
        });
        this._moduleSearchField.getTextField().setColumns(15);
        JLabel busyLabel = new JLabel(CVSArb.get("LOADING"), OracleIcons.getIcon((String)"throbber.gif"), 0);
        busyLabel.setBackground(UIManager.getColor("window"));
        busyLabel.setForeground(UIManager.getColor("textText"));
        busyLabel.setBorder(UIManager.getBorder("ScrollPane.border"));
        busyLabel.setOpaque(true);
        this._moduleMessageLabel.setBackground(UIManager.getColor("window"));
        this._moduleMessageLabel.setForeground(UIManager.getColor("textText"));
        this._moduleMessageLabel.setBorder(UIManager.getBorder("ScrollPane.border"));
        this._moduleMessageLabel.setOpaque(true);
        this._moduleNameGui.setLayout(this._moduleNameListLayout);
        this._moduleNameGui.add((Component)new JScrollPane(this._moduleNameList), GUI_LIST);
        this._moduleNameGui.add((Component)busyLabel, GUI_BUSY);
        this._moduleNameGui.add((Component)this._moduleMessageLabel, GUI_MESSAGE);
        this._moduleNameListLayout.show(this._moduleNameGui, GUI_LIST);
        Box box = Box.createHorizontalBox();
        JLabel pathLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)pathLabel, (Component)this._moduleNameTextField, (String)CVSArb.get("MODULE_PATH"));
        box.add(pathLabel);
        box.add(Box.createHorizontalStrut(4));
        box.add(this._moduleNameTextField);
        JPanel center = new JPanel(new BorderLayout(4, 4));
        center.add((Component)this._moduleSearchField, "North");
        center.add((Component)this._moduleNameGui, "Center");
        JPanel center2 = new JPanel(new BorderLayout(4, 4));
        center2.add((Component)center, "Center");
        center2.add((Component)box, "South");
        this.setLayout(new BorderLayout(4, 4));
        box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(this._refreshModuleListButton);
        this.add((Component)center2, "Center");
        this.add((Component)box, "South");
        ResourceUtils.resButton((AbstractButton)this._refreshModuleListButton, (String)CVSArb.get("GET_MODULE_LIST"));
        this._parent = parent;
        this._moduleNameListModel = new SortedListModel();
        this._moduleNameList.setModel(this._moduleNameListModel);
        this._moduleNameList.setPrototypeCellValue("just_a_dummy_module_name");
        this._moduleNameList.setCellRenderer(new ModuleNameListCellRenderer());
        this._moduleNameList.setSelectionMode(0);
        this._moduleNameList.setVisibleRowCount(5);
        this._moduleNameListModel.setComparator((Comparator)new ModuleNameComparator());
        this._listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Object value = CVSModuleSelectionPanel.this._moduleNameList.getSelectedValue();
                CVSModuleSelectionPanel.this._moduleNameTextField.setText(value != null ? value.toString() : "");
            }
        };
        this._refreshModuleListButton.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                CVSModuleSelectionPanel.this._refreshModuleListButton_actionPerformed(e);
            }
        });
        this._moduleNameList.addListSelectionListener(this._listSelectionListener);
        this._moduleNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.documentUpdate(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.documentUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.documentUpdate(e);
            }

            private void documentUpdate(DocumentEvent e) {
                CVSModuleSelectionPanel.this.fireModuleNameChanged();
            }
        });
    }

    public void setVisibleRowCount(int rowCount) {
        this._moduleNameList.setVisibleRowCount(rowCount);
    }

    public void setParentComponent(Component parent) {
        this._parent = parent;
    }

    public void connectionNameChanged(String connectionName) {
        this._connectionName = connectionName;
        this.updateModuleComponents();
    }

    public Component getModuleNameComponent() {
        return this._moduleNameTextField;
    }

    public void addModuleNameChangeListener(ChangeListener l) {
        this._moduleNameChangeListeners.add(l);
    }

    public void removeModuleNameChangeListener(ChangeListener l) {
        this._moduleNameChangeListeners.remove(l);
    }

    private void fireModuleNameChanged() {
        ChangeEvent ce = new ChangeEvent(this);
        for (int i = this._moduleNameChangeListeners.size() - 1; i >= 0; --i) {
            ((ChangeListener)this._moduleNameChangeListeners.get(i)).stateChanged(ce);
        }
    }

    public void setModuleName(String moduleName) {
        this._moduleNameTextField.setText(moduleName);
    }

    public String getModuleName() {
        return this._moduleNameTextField.getText();
    }

    @Override
    public void requestFocus() {
        this._moduleNameTextField.requestFocus();
    }

    private void _refreshModuleListButton_actionPerformed(ActionEvent e) {
        WaitCursor waitCursor = new WaitCursor(this._parent);
        this._moduleSearchField.setEnabled(false);
        this._moduleSearchField.getTextField().setEnabled(false);
        this._refreshModuleListButton.setEnabled(false);
        waitCursor.show();
        this._moduleNameListLayout.show(this._moduleNameGui, GUI_BUSY);
        try {
            CVSConnectionNodes.getConnectionListNode().open();
        }
        catch (IOException ioe) {
            Assert.printStackTrace((Throwable)ioe);
        }
        new GetModuleListWorker(waitCursor).start();
    }

    private void updateModuleComponents() {
        this.updateModuleListComponents();
        this.updateGetModuleListButton();
    }

    private void updateModuleListComponents() {
        int i;
        this._moduleNameList.removeListSelectionListener(this._listSelectionListener);
        CVSConnectionData connection = CVSConnectionNodes.getConnectionListAPI().getConnectionAPI(this._connectionName);
        DefaultListModel moduleNameListModel = (DefaultListModel)this._moduleNameList.getModel();
        moduleNameListModel.removeAllElements();
        CVSConnectionFileData[] moduleFileData = null;
        if (connection != null) {
            moduleFileData = connection.getModuleFileData();
        }
        if (moduleFileData == null) {
            moduleFileData = new CVSConnectionFileData[]{};
        }
        for (i = 0; i < moduleFileData.length; ++i) {
            this._moduleFileDataCache.put(moduleFileData[i].getFileName(), moduleFileData[i]);
        }
        for (i = 0; i < moduleFileData.length; ++i) {
            moduleNameListModel.addElement(moduleFileData[i].getFileName());
        }
        this._moduleNameList.setModel(this._moduleNameListModel);
        if (moduleFileData.length > 0) {
            this._moduleNameListLayout.show(this._moduleNameGui, GUI_LIST);
            this._moduleSearchField.setEnabled(true);
            this._moduleSearchField.getTextField().setEnabled(true);
        } else {
            this._moduleMessageLabel.setText(this.isGetModuleListRequired() ? CVSArb.get("MODULE_LIST_HINT") : CVSArb.get("MODULE_LIST_UNAVAILABLE"));
            this._moduleNameListLayout.show(this._moduleNameGui, GUI_MESSAGE);
            this._moduleSearchField.setEnabled(false);
            this._moduleSearchField.getTextField().setEnabled(false);
        }
        this._moduleNameList.setSelectedIndices(new int[0]);
        this._moduleSearchField.clear();
        this._moduleNameList.addListSelectionListener(this._listSelectionListener);
        this._moduleNameList.validate();
        this._moduleNameList.repaint();
    }

    public void setModuleNameFromFirstItem() {
        if (this._moduleNameList.getModel().getSize() > 0) {
            this._moduleNameTextField.setText(this._moduleNameList.getModel().getElementAt(0).toString());
            this._moduleNameList.setSelectedIndex(0);
        }
    }

    private void updateGetModuleListButton() {
        this._refreshModuleListButton.setEnabled(true);
    }

    private boolean isGetModuleListRequired() {
        if (!this._connectionsWithRecentModuleLists.contains(this._connectionName)) {
            return this._moduleNameTextField.isEnabled();
        }
        if (!CVSConnectionNodes.isConnectionListOpen()) {
            return this._moduleNameTextField.isEnabled();
        }
        CVSConnectionData connectionData = CVSConnectionNodes.getConnectionListAPI().getConnectionAPI(this._connectionName);
        return connectionData != null && connectionData.getModuleFileData() == null;
    }

    private class GetModuleListWorker
    extends SwingWorker {
        private final WaitCursor _waitCursor;

        GetModuleListWorker(WaitCursor waitCursor) {
            this._waitCursor = waitCursor;
        }

        public Object construct() {
            CVSConnectionFileData[] fileData;
            if (!this.ensureConnectionLogin(CVSModuleSelectionPanel.this._connectionName)) {
                return null;
            }
            String connectionRoot = CVSConnectionNodes.getConnectionListAPI().getConnectionRoot(CVSModuleSelectionPanel.this._connectionName);
            if (connectionRoot == null) {
                return null;
            }
            try {
                CVSModuleSelectionPanel.this._connectionsWithRecentModuleLists.add(CVSModuleSelectionPanel.this._connectionName);
                fileData = CVSConnectionNodeUtils.getRootFileList(connectionRoot);
            }
            catch (CVSNavServicesException nse) {
                CVSClient.getInstance().getExceptionHandler().handleException((Exception)((Object)nse), CVSModuleSelectionPanel.this._parent);
                return null;
            }
            catch (VCSCancelException e) {
                CVSModuleSelectionPanel.this._connectionsWithRecentModuleLists.remove(CVSModuleSelectionPanel.this._connectionName);
                return null;
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
                return null;
            }
            if (!CVSConnectionNodes.isConnectionListOpen()) {
                CVSConnectionNodes.openConnectionList();
            }
            CVSConnectionData connection = CVSConnectionNodes.getConnectionListAPI().getConnectionAPI(CVSModuleSelectionPanel.this._connectionName);
            connection.setModuleFileData(fileData);
            return connection;
        }

        public void finished() {
            try {
                CVSModuleSelectionPanel.this.updateModuleComponents();
                if (this.getValue() == null) {
                    return;
                }
                CVSModuleSelectionPanel.this.setModuleNameFromFirstItem();
                CVSModuleSelectionPanel.this._moduleNameTextField.requestFocus();
            }
            finally {
                this._waitCursor.hide();
                CVSModuleSelectionPanel.this._moduleSearchField.setEnabled(true);
                CVSModuleSelectionPanel.this._moduleSearchField.getTextField().setEnabled(true);
                CVSModuleSelectionPanel.this._refreshModuleListButton.setEnabled(true);
            }
        }

        private boolean ensureConnectionLogin(String connectionName) {
            try {
                CVSConnectionNodeUtils.ensureLogin(connectionName, CVSModuleSelectionPanel.this._parent);
                return true;
            }
            catch (VCSException vcse) {
                CVSClient.getInstance().getExceptionHandler().handleException((Exception)((Object)vcse), CVSModuleSelectionPanel.this._parent);
                return false;
            }
        }
    }

    private class ModuleNameListCellRenderer
    extends DefaultListCellRenderer {
        private ModuleNameListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setEnabled(list.isEnabled());
            this.setText("");
            this.setIcon(null);
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                return this;
            }
            CVSConnectionFileData fileData = (CVSConnectionFileData)CVSModuleSelectionPanel.this._moduleFileDataCache.get(value);
            this.setText(fileData != null ? fileData.getFileName() : value.toString());
            if (fileData != null && fileData.isModulesEntry()) {
                this.setIcon(CVSConnectionElement.MODULE_ICON);
            } else {
                this.setIcon(CVSConnectionElement.DIRECTORY_ICON);
            }
            return this;
        }
    }

    private class ModuleNameComparator
    implements Comparator {
        private final Collator _stringCollator = (Collator)Collator.getInstance().clone();

        private ModuleNameComparator() {
            this._stringCollator.setStrength(0);
        }

        public int compare(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null && o2 != null) {
                return 1;
            }
            if (o1 != null && o2 == null) {
                return -1;
            }
            return this.compareImpl(o1, o2);
        }

        protected int compareImpl(Object o1, Object o2) {
            CVSConnectionFileData fileData1 = (CVSConnectionFileData)CVSModuleSelectionPanel.this._moduleFileDataCache.get(o1);
            CVSConnectionFileData fileData2 = (CVSConnectionFileData)CVSModuleSelectionPanel.this._moduleFileDataCache.get(o2);
            if (fileData1 == null || fileData2 == null) {
                return 0;
            }
            if (!fileData1.isModulesEntry() && fileData2.isModulesEntry()) {
                return -1;
            }
            if (fileData1.isModulesEntry() && !fileData2.isModulesEntry()) {
                return 1;
            }
            return this.getStringCollator().compare(fileData1.getFileName(), fileData2.getFileName());
        }

        protected Collator getStringCollator() {
            return this._stringCollator;
        }
    }
}

