/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.control;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import oracle.bali.ewt.text.NumberTextField;

public final class CVSIntegerTextField
extends NumberTextField {
    private int m_min = Integer.MIN_VALUE;
    private int m_max = Integer.MAX_VALUE;

    public CVSIntegerTextField() {
        this.addValidationFocusListener();
    }

    public CVSIntegerTextField(int min, int max) {
        this.setMinimum(min);
        this.setMaximum(max);
        this.addValidationFocusListener();
    }

    public final void setMinimum(int min) {
        this.m_min = min;
    }

    public final void setMaximum(int max) {
        this.m_max = max;
    }

    public final int getMinimum() {
        return this.m_min;
    }

    public final int getMaximum() {
        return this.m_max;
    }

    public final void validateInternalValue() {
        int min = this.getMinimum();
        int max = this.getMaximum();
        int val = this.getInternalValue();
        this.setInternalValue(Math.max(min, Math.min(max, val)));
    }

    private final void addValidationFocusListener() {
        this.addFocusListener(new FocusAdapter(){

            @Override
            public final void focusLost(FocusEvent e) {
                CVSIntegerTextField.this.validateInternalValue();
            }
        });
    }

    private final int getInternalValue() {
        Number n = this.getNumber();
        return n != null ? n.intValue() : 0;
    }

    private final void setInternalValue(int val) {
        this.setNumber(new Integer(val));
    }
}

