/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.client;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.Log;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.util.CVSFileConstants;

public final class CVSRootFile {
    private static final String ROOT_RELATIVE_PATH = "CVS" + CVSFileConstants.separatorChar + "Root";
    private final URL _root;
    private static final Log LOG = new Log("vcs-cvs");

    public CVSRootFile(URL dir) {
        this._root = URLFactory.newURL((URL)dir, (String)ROOT_RELATIVE_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CVSRootString getRoot() throws IOException {
        if (Boolean.getBoolean("jdev.cvs.debugcachedfiles")) {
            LOG.trace("CVS: reading file " + this._root);
        }
        if (!URLFileSystem.exists((URL)this._root)) {
            return null;
        }
        String path = URLFileSystem.getPlatformPathName((URL)this._root);
        try (BufferedReader in = new BufferedReader(new FileReader(path));){
            String line;
            while ((line = in.readLine()) != null) {
                if (line.equals("")) continue;
                CVSRootString cVSRootString = new CVSRootString(line.trim());
                return cVSRootString;
            }
            CVSRootString cVSRootString = null;
            return cVSRootString;
        }
    }
}

