/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.client;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdevimpl.vcs.cvs.client.CVSAccessPServer;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.util.CVSEnvironmentVars;

class CVSAccessPServerGeneric
extends CVSAccessPServer {
    private static final Object _passlock = new Object();

    protected CVSAccessPServerGeneric() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deletePassFileRoot(String root) throws Exception {
        CVSRootString rootstr = new CVSRootString(root);
        Object object = _passlock;
        synchronized (object) {
            URL pass_url = URLFactory.newFileURL((String)this.getPassfilePath());
            if (!URLFileSystem.exists((URL)pass_url)) {
                return;
            }
            BufferedReader in = null;
            ArrayList<String> lines = new ArrayList<String>();
            try {
                String s;
                in = new BufferedReader(new FileReader(URLFileSystem.getPlatformPathName((URL)pass_url)));
                while ((s = in.readLine()) != null) {
                    lines.add(s);
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException s) {}
                }
            }
            BufferedWriter out = null;
            try {
                out = new BufferedWriter(new FileWriter(URLFileSystem.getPlatformPathName((URL)pass_url)));
                Iterator itr = lines.iterator();
                while (itr.hasNext()) {
                    String entry = itr.next().toString();
                    if (new CVSRootString(this.parseEntryRoot(entry)).equals(rootstr)) continue;
                    out.write(entry);
                    out.newLine();
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    @Override
    public boolean searchPassFileRoot(String root) throws Exception {
        return this.readPassFileRoot(root) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writePassFileRoot(String root, char[] spw) throws Exception {
        CVSRootString rootstr = new CVSRootString(root);
        Object object = _passlock;
        synchronized (object) {
            RandomAccessFile pass = null;
            try {
                pass = new RandomAccessFile(this.getPassfilePath(), "rw");
                if (this.findPassFilePassword(root, pass) == null) {
                    pass.seek(pass.length());
                    pass.writeBytes(rootstr.canonicalize().toString() + this.getFieldDelimiter() + new String(spw) + '\n');
                }
            }
            finally {
                if (pass != null) {
                    try {
                        pass.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char[] readPassFileRoot(String root) throws Exception {
        Object object = _passlock;
        synchronized (object) {
            URL pass_url = URLFactory.newFileURL((String)this.getPassfilePath());
            if (!URLFileSystem.exists((URL)pass_url)) {
                return null;
            }
            RandomAccessFile pass = new RandomAccessFile(this.getPassfilePath(), "r");
            char[] spw = this.findPassFilePassword(root, pass);
            pass.close();
            return spw;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deletePassFile() throws Exception {
        Object object = _passlock;
        synchronized (object) {
            URL pass_url = URLFactory.newFileURL((String)this.getPassfilePath());
            if (URLFileSystem.isDirectory((URL)pass_url)) {
                return;
            }
            URLFileSystem.delete((URL)pass_url);
        }
    }

    protected String getPassfilePath() {
        String passfile = CVSEnvironmentVars.getInstance().getVariable("CVS_PASSFILE");
        if (passfile != null) {
            return passfile;
        }
        StringBuilder sb = new StringBuilder();
        String home = URLFileSystem.getPlatformPathName((URL)URLFactory.newDirURL((String)System.getProperty("user.home")));
        sb.append(home);
        if (!home.endsWith(File.separator)) {
            sb.append(File.separator);
        }
        sb.append(".cvspass");
        return sb.toString();
    }

    protected char getFieldDelimiter() {
        return ' ';
    }

    private char[] findPassFilePassword(String root, RandomAccessFile pass) {
        CVSRootString rootstr = new CVSRootString(root);
        try {
            String s;
            do {
                if ((s = pass.readLine()) != null) continue;
                return null;
            } while (!new CVSRootString(this.parseEntryRoot(s)).equals(rootstr));
            int n = root.length() + 1;
            return s.length() <= n ? "".toCharArray() : s.substring(n).toCharArray();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    private String parseEntryRoot(String entry) {
        int i = entry.indexOf(this.getFieldDelimiter());
        if (i == 0) {
            return "";
        }
        return i > 0 ? entry.substring(0, i) : entry;
    }
}

