/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import oracle.ide.net.URLFileSystem;
import oracle.ide.vhv.VHVCheckoutResource;
import oracle.ide.vhv.VHVQuery;
import oracle.ide.vhv.VHVResourceException;
import oracle.ide.vhv.VHVVersionTree;
import oracle.ide.vhv.VHVVersionableResource;
import oracle.ide.vhv.rlog.RlogFormat;
import oracle.ide.vhv.rlog.RlogModel;
import oracle.ide.vhv.rlog.RlogVersionTree;
import oracle.javatools.util.Version;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSStatusCache;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.client.CVSEntry;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.util.CVSUniversalTimestamp;
import oracle.jdevimpl.vcs.cvs.util.log.CVSLogReadWorker;

public class CVSVHVQuery
extends VHVQuery {
    protected VHVVersionTree getVersionTree(URL url) throws VHVResourceException {
        try {
            if (!CVSUtil.isOpenSessionFile(url)) {
                CVSClient.getInstance();
                if (((VCSStatus)CVSClient.getStatusCache().get(url)).isVersioned()) {
                    return new VHVVersionTree(new VHVVersionableResource[0], null, null);
                }
            }
            CVSRunner runner = CVSLogReadWorker.createLogRunner(url);
            runner.exec_();
            RlogModel rlogModel = new RlogFormat().parse((Reader)new StringReader(runner.getOutputText_()));
            CVSEntry entry = CVSStatusCache.locateEntry(url);
            URL parentUrl = URLFileSystem.getParent((URL)url);
            CVSRootString root = CVSUtil.readAdminRoot(parentUrl);
            VHVCheckoutResource checkoutResource = new VHVCheckoutResource();
            checkoutResource.setVersionNumber((Comparable)new Version(entry.getRevision()));
            checkoutResource.setUser(root != null && root.getUserName() != null ? root.getUserName() : System.getProperty("user.name"));
            checkoutResource.setDate(entry != null ? new CVSUniversalTimestamp(entry.getTimestamp()).getDate() : null);
            return RlogVersionTree.createVersionTree((URL)url, (String)CVSUtil.readRepository(parentUrl), (RlogModel)rlogModel, (String)entry.getRevision(), (VHVCheckoutResource)checkoutResource);
        }
        catch (VHVResourceException vhvre) {
            throw vhvre;
        }
        catch (Exception e) {
            throw new VHVResourceException((Throwable)e);
        }
    }
}

