/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.text.Collator;
import java.util.Comparator;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.ide.ProductInformation;
import oracle.ide.controls.SortedComboBoxModel;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.ui.table.GenericTable;
import oracle.jdeveloper.vcs.spi.VCSPreferencesTraversable;
import oracle.jdevimpl.vcs.cvs.CVSClientInfo;
import oracle.jdevimpl.vcs.cvs.CVSClientVerification;
import oracle.jdevimpl.vcs.cvs.CVSFileStatus;
import oracle.jdevimpl.vcs.cvs.CVSGlobalOptionId;
import oracle.jdevimpl.vcs.cvs.CVSInternalClientSupport;
import oracle.jdevimpl.vcs.cvs.CVSPrefs;
import oracle.jdevimpl.vcs.cvs.control.CVSFilePanel;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;

public class CVSTraversable
extends VCSPreferencesTraversable<CVSPrefs> {
    private Component _ui;
    private JLabel _clientLabel;
    private JRadioButton _integralClientRadioButton;
    private JRadioButton _externalClientRadioButton;
    private JLabel _pathDirectionsLabel;
    private JRadioButton _nameOnSystemPathRadioButton;
    private JTextField _nameTextField;
    private JRadioButton _environmentPathRadioButton;
    private EnvironmentPathTable _environmentPathTable;
    private JRadioButton _otherPathRadioButton;
    private CVSFilePanel _otherPathFilePanel;
    private JLabel _overlaySchemeLabel;
    private JComboBox _overlaySchemeComboBox;
    private JCheckBox _runInEditModeCheckBox;

    public CVSTraversable() {
        this.setHelpID("f1_cvspreferencesmain_html");
    }

    protected CVSPrefs getPreferences(PropertyStorage prefs) {
        return CVSPrefs.getInstance(prefs);
    }

    public Component getComponent() {
        return this.getPage();
    }

    protected Component getPage() {
        if (this._ui == null) {
            this._ui = this.createComponent();
        }
        return this._ui;
    }

    protected void loadPreferences(CVSPrefs prefs) {
        Boolean runInEditMode;
        Boolean externalClient = prefs.getCVSExternalClient();
        String executablePath = prefs.getCVSPath();
        this._integralClientRadioButton.setSelected(externalClient == false);
        this._externalClientRadioButton.setSelected(externalClient);
        this.setExecutablePath(new File(executablePath));
        String overlayScheme = prefs.getOverlayScheme();
        CVSFileStatus.Scheme overlayScheme0 = CVSFileStatus.Scheme.valueOf(overlayScheme != null ? overlayScheme : null);
        if (overlayScheme0 != null) {
            this._overlaySchemeComboBox.setSelectedItem((Object)overlayScheme0);
        }
        this._runInEditModeCheckBox.setSelected((runInEditMode = Boolean.valueOf(prefs.getRunInEditMode())) != null && runInEditMode != false);
        this.updateSlaveComponentsEnabled();
    }

    private void setExecutablePath(File executableFile) {
        if (!executableFile.isAbsolute()) {
            this._nameOnSystemPathRadioButton.setSelected(true);
            this._nameTextField.setText(executableFile.getName());
            return;
        }
        if (this._environmentPathTable.containsPath(executableFile.getPath())) {
            this._environmentPathRadioButton.setSelected(true);
            this._environmentPathTable.setSelectedPath(executableFile.getPath());
            return;
        }
        this._otherPathRadioButton.setSelected(true);
        this._otherPathFilePanel.setURL(URLFactory.newFileURL((String)executableFile.getPath()));
    }

    protected void savePreferences(CVSPrefs prefs) {
        prefs.setCVSExternalClient(this._externalClientRadioButton.isSelected());
        prefs.setCVSPath(this.getExecutablePath());
        CVSFileStatus.Scheme overlayScheme = (CVSFileStatus.Scheme)((Object)this._overlaySchemeComboBox.getSelectedItem());
        prefs.setOverlayScheme(overlayScheme.name());
        prefs.setRunInEditMode(this._runInEditModeCheckBox.isSelected());
    }

    private String getExecutablePath() {
        if (this._nameOnSystemPathRadioButton.isSelected()) {
            return this._nameTextField.getText();
        }
        if (this._environmentPathRadioButton.isSelected()) {
            return this._environmentPathTable.getSelectedPath();
        }
        return URLFileSystem.getPlatformPathName((URL)this._otherPathFilePanel.getURL());
    }

    protected void validatePreferences() throws TraversalException {
        if (this._integralClientRadioButton.isSelected() && !this.isForkEnabled()) {
            return;
        }
        if (this._nameOnSystemPathRadioButton.isSelected()) {
            String executablePath = this._nameTextField.getText();
            if (executablePath.equals("") || new File(executablePath).getParentFile() != null) {
                throw new TraversalException(CVSArb.get("CVS_NAME_ON_SYSTEM_PATH_INVALID"));
            }
            return;
        }
        if (this._environmentPathRadioButton.isSelected()) {
            String executablePath = this._environmentPathTable.getSelectedPath();
            if (executablePath == null || !new File(executablePath).isAbsolute()) {
                throw new TraversalException(CVSArb.get("CVS_ENVIRONMENT_PATH_INVALID"));
            }
            return;
        }
        String executablePath = this._otherPathFilePanel.getPath();
        File executableFile = new File(executablePath);
        if (executablePath.equals("") || !executableFile.isAbsolute() || executableFile.isDirectory()) {
            throw new TraversalException(CVSArb.get("CVS_OTHER_PATH_INVALID"));
        }
    }

    private Component createComponent() {
        this._clientLabel = new JLabel();
        this._integralClientRadioButton = new JRadioButton();
        this._externalClientRadioButton = new JRadioButton();
        this._pathDirectionsLabel = new JLabel();
        this._nameOnSystemPathRadioButton = new JRadioButton();
        this._nameTextField = new JTextField();
        this._environmentPathRadioButton = new JRadioButton();
        this._environmentPathTable = new EnvironmentPathTable();
        this._otherPathRadioButton = new JRadioButton();
        this._otherPathFilePanel = new CVSFilePanel();
        this._overlaySchemeLabel = new JLabel();
        this._overlaySchemeComboBox = new JComboBox();
        this._runInEditModeCheckBox = new JCheckBox();
        JPanel panel = new JPanel();
        LayoutBuilder layoutBuilder = new LayoutBuilder();
        Insets insets = new Insets(2, 2, 2, 2);
        layoutBuilder.add((Component)this._clientLabel, insets, 5, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._integralClientRadioButton, insets, 4, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._externalClientRadioButton, insets, 4, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._pathDirectionsLabel, insets, 3, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._nameOnSystemPathRadioButton, insets, 3, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.addHGap();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._nameTextField, insets, 1, false, false);
        layoutBuilder.addHFiller();
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._environmentPathRadioButton, insets, 3, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.addHGap();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)new JScrollPane((Component)((Object)this._environmentPathTable)), insets, 2, true, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._otherPathRadioButton, insets, 3, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.addHGap();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)((Object)this._otherPathFilePanel), insets, 2, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._runInEditModeCheckBox, insets, 4, false, true);
        layoutBuilder.nl();
        layoutBuilder.addVGap();
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._overlaySchemeLabel, insets, 5, false, true);
        layoutBuilder.nl();
        Box box = Box.createHorizontalBox();
        box.add(this._overlaySchemeComboBox);
        box.add(Box.createHorizontalGlue());
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)box, insets, 3, false, true);
        layoutBuilder.addHFiller();
        layoutBuilder.nl();
        layoutBuilder.addToPanel((Container)panel);
        ResourceUtils.resLabel((JLabel)this._clientLabel, (Component)this._clientLabel, (String)CVSArb.get("CVS_CLIENT"));
        ResourceUtils.resButton((AbstractButton)this._integralClientRadioButton, (String)CVSArb.format("CVS_INTEGRAL_CLIENT", IdeUtil.getProgramName()));
        ResourceUtils.resButton((AbstractButton)this._externalClientRadioButton, (String)CVSArb.get("CVS_EXTERNAL_CLIENT"));
        ResourceUtils.resLabel((JLabel)this._pathDirectionsLabel, (Component)this._pathDirectionsLabel, (String)CVSArb.format("CVS_EXECUTABLE_DIRECTIONS", ProductInformation.getProductInformation().getShortName()));
        ResourceUtils.resButton((AbstractButton)this._nameOnSystemPathRadioButton, (String)CVSArb.get("CVS_NAME_ON_SYSTEM_PATH"));
        ResourceUtils.resButton((AbstractButton)this._environmentPathRadioButton, (String)CVSArb.get("CVS_ENVIRONMENT_PATH"));
        ResourceUtils.resButton((AbstractButton)this._otherPathRadioButton, (String)CVSArb.get("CVS_OTHER_PATH"));
        ResourceUtils.resLabel((JLabel)this._overlaySchemeLabel, (Component)this._overlaySchemeComboBox, (String)CVSArb.get("CVS_OVERLAY_SCHEME"));
        ResourceUtils.resButton((AbstractButton)this._runInEditModeCheckBox, (String)CVSArb.get("CVS_RUN_IN_EDIT_MODE"));
        this._pathDirectionsLabel.setFont(new Font("Dialog", 0, 11));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this._integralClientRadioButton);
        bg.add(this._externalClientRadioButton);
        bg = new ButtonGroup();
        bg.add(this._nameOnSystemPathRadioButton);
        bg.add(this._environmentPathRadioButton);
        bg.add(this._otherPathRadioButton);
        bg = null;
        this._nameTextField.setColumns(20);
        this._otherPathFilePanel.setDialogType(1);
        this._otherPathFilePanel.setChooseFolders(false);
        this._otherPathFilePanel.setURLFilter(new URLFilter(){
            private final String WIN32_EXECUTABLE_SUFFIX = ".exe";

            public final String toString() {
                StringBuilder descriptionBuffer = new StringBuilder(CVSArb.get("CVS_FILTER_DESCRIPTION"));
                descriptionBuffer.append(" (*, *");
                descriptionBuffer.append(".exe");
                descriptionBuffer.append(")");
                return descriptionBuffer.toString();
            }

            public final boolean accept(URL url) {
                String suffix = URLFileSystem.getSuffix((URL)url);
                return suffix == null || suffix.equals("") || suffix.equals(".exe");
            }
        });
        EnvironmentPathTableModel model = new EnvironmentPathTableModel();
        model.addColumn(CVSArb.get("CVS_PATH_COLUMN"));
        model.addColumn(CVSArb.get("CVS_VERSION_COLUMN"));
        CVSClientInfo[] systemPathClientInfo = CVSClientVerification.searchSystemPath();
        for (int i = 0; i < systemPathClientInfo.length; ++i) {
            String versionInfoString = systemPathClientInfo[i].getVersionInfoString();
            model.addRow(new Object[]{systemPathClientInfo[i].getPath(), versionInfoString != null ? versionInfoString : "?"});
        }
        this._environmentPathTable.installModel((TableModel)((Object)model));
        ActionListener l = new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                CVSTraversable.this.updateSlaveComponentsEnabled();
            }
        };
        this._integralClientRadioButton.addActionListener(l);
        this._externalClientRadioButton.addActionListener(l);
        this._nameOnSystemPathRadioButton.addActionListener(l);
        this._environmentPathRadioButton.addActionListener(l);
        this._otherPathRadioButton.addActionListener(l);
        this._integralClientRadioButton.setSelected(true);
        this._nameOnSystemPathRadioButton.setSelected(true);
        this._nameTextField.setText(new File("cvs").getName());
        this._otherPathFilePanel.setURL(URLFactory.newFileURL((String)System.getProperty("user.home")));
        SortedComboBoxModel overlaySchemeComboBoxModel = new SortedComboBoxModel();
        CVSFileStatus.Scheme[] overlaySchemes = CVSFileStatus.Scheme.values();
        for (int i = 0; i < overlaySchemes.length; ++i) {
            overlaySchemeComboBoxModel.addElement((Object)overlaySchemes[i]);
        }
        this._overlaySchemeComboBox.setModel(overlaySchemeComboBoxModel);
        this._overlaySchemeComboBox.setRenderer(new BasicComboBoxRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value == CVSFileStatus.Scheme.JDEVELOPER) {
                    value = ProductInformation.getProductInformation().getShortName();
                }
                if (value == CVSFileStatus.Scheme.TORTOISE) {
                    value = CVSArb.get("CVS_OVERLAY_SCHEME_TORTOISE");
                }
                if (value == CVSFileStatus.Scheme.WINDOWS) {
                    value = CVSArb.get("CVS_OVERLAY_SCHEME_WINDOWS");
                }
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        });
        this.updateSlaveComponentsEnabled();
        return panel;
    }

    private void updateSlaveComponentsEnabled() {
        boolean externalClient = this._externalClientRadioButton.isSelected() || this.isForkEnabled();
        this._pathDirectionsLabel.setEnabled(externalClient);
        this._nameOnSystemPathRadioButton.setEnabled(externalClient);
        this._nameTextField.setEnabled(externalClient && this._nameOnSystemPathRadioButton.isSelected());
        this._environmentPathRadioButton.setEnabled(externalClient);
        this._environmentPathTable.setEnabled(externalClient && this._environmentPathRadioButton.isSelected());
        this._otherPathRadioButton.setEnabled(externalClient);
        this._otherPathFilePanel.setEnabled(externalClient && this._otherPathRadioButton.isSelected());
        this._runInEditModeCheckBox.setEnabled(externalClient || CVSInternalClientSupport.isSupportedGlobalOption(CVSGlobalOptionId.R_MAKE_NEW_FILES_READ_ONLY));
        if (!this._runInEditModeCheckBox.isEnabled()) {
            this._runInEditModeCheckBox.setSelected(false);
        }
    }

    private boolean isForkEnabled() {
        return Boolean.getBoolean("jdev.cvs.enablefork");
    }

    private class EnvironmentPathTableModel
    extends GenericBaseTableModel {
        private EnvironmentPathTableModel() {
        }

        public int getColumnAlignment(int column) {
            return 2;
        }

        public Comparator getColumnSortComparator(int column) {
            return Collator.getInstance();
        }
    }

    private class EnvironmentPathTable
    extends GenericTable {
        private EnvironmentPathTable() {
            this.setSelectionMode(0);
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public boolean containsPath(String path) {
            int i = this.rowIndexOfPath(path);
            return i >= 0 && i < this.getRowCount();
        }

        public void setSelectedPath(String path) {
            int i = this.rowIndexOfPath(path);
            if (i < 0 || i >= this.getRowCount()) {
                return;
            }
            this.setSelectedRow(i);
        }

        public String getSelectedPath() {
            int i = this.getSelectedRow();
            if (i < 0 || i >= this.getRowCount()) {
                return null;
            }
            return (String)this.getValueAt(i, 0);
        }

        public void setSelectedRow(int i) {
            if (i < 0 || i >= this.getRowCount()) {
                return;
            }
            this.setRowSelectionInterval(i, i);
            this.scrollToSelection();
        }

        public void installModel(TableModel model) {
            this.setModel(model);
            this.getTableHeader().setReorderingAllowed(false);
            for (int i = 0; i < this.getColumnCount(); ++i) {
                this.getColumnModel().getColumn(i).setHeaderRenderer(this.getTableHeader().getDefaultRenderer());
            }
            this.setAutoResizeMode(0);
            this.autoSizeColumnsToFit();
            ((DefaultTableModel)this.getModel()).fireTableDataChanged();
            if (model.getRowCount() > 0) {
                this.setRowSelectionInterval(0, 0);
            }
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.getTableHeader().validate();
            this.getTableHeader().repaint();
        }

        private int rowIndexOfPath(String path) {
            File searchPathFile = new File(path);
            for (int i = 0; i < this.getRowCount(); ++i) {
                File currentPathFile = new File((String)this.getValueAt(i, 0));
                if (!searchPathFile.equals(currentPathFile)) continue;
                return i;
            }
            return -1;
        }
    }
}

