/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.vcs.cache.TransactionalStatusCache;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSEntriesCache;
import oracle.jdevimpl.vcs.cvs.CVSFileStatus;
import oracle.jdevimpl.vcs.cvs.CVSRootCache;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.client.CVSEntry;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.login.CVSLogin;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodes;
import oracle.jdevimpl.vcs.cvs.util.CVSUniversalTimestamp;

public class CVSStatusCache
extends TransactionalStatusCache<VCSStatus> {
    public CVSStatusCache() {
        super(VCSStatus.class);
    }

    protected final void getNatively(URL[] urls, VCSStatus[] statuses) throws Exception {
        Map urlsByParent = VCSFileSystemUtils.mapURLsByParent((URL[])urls);
        HashMap<VCSHashURL, VCSStatus> statusesByUrl = new HashMap<VCSHashURL, VCSStatus>(urls.length);
        for (Map.Entry entry : urlsByParent.entrySet()) {
            if (entry.getKey() == null) continue;
            this._getImpl(((VCSHashURL)entry.getKey()).getURL(), (Collection)entry.getValue(), statusesByUrl);
        }
        for (int i = 0; i < urls.length; ++i) {
            VCSStatus status = (VCSStatus)statusesByUrl.get(new VCSHashURL(urls[i]));
            statuses[i] = status != null ? status : CVSFileStatus.STATUS_NOT_UNDER_CVS;
        }
    }

    private void _getImpl(URL parent, Collection<URL> urls, Map<VCSHashURL, VCSStatus> statusesByUrl) throws Exception {
        CVSClient client = CVSClient.getInstance();
        if (client == null) {
            return;
        }
        if (!client.isClientAvailable()) {
            return;
        }
        if (CVSConnectionNodes.getConnectionListAPI().getConnectionCount() <= 0) {
            return;
        }
        if (!client.getURLFilter().accept(parent)) {
            return;
        }
        if (URLFileSystem.getFileName((URL)parent).equals("CVS")) {
            for (URL url : urls) {
                statusesByUrl.put(new VCSHashURL(url), CVSFileStatus.STATUS_ADMINISTRATIVE);
            }
            return;
        }
        if (!URLFileSystem.exists((URL)parent)) {
            return;
        }
        URL parentSandbox = CVSUtil.locateParentSandbox(parent);
        for (URL url : urls) {
            boolean controlled;
            VCSHashURL hashUrl = new VCSHashURL(url);
            boolean isDirectory = URLFileSystem.isDirectoryPath((URL)url);
            URL sandbox = isDirectory && CVSUtil.isUnderCVS(url) ? url : parentSandbox;
            boolean bl = controlled = sandbox != null;
            if (!controlled) {
                statusesByUrl.put(hashUrl, CVSFileStatus.STATUS_NOT_UNDER_CVS);
                continue;
            }
            CVSRootString root = CVSRootCache.getInstance().getRoot(sandbox);
            if (root == null || !CVSUtil.hasRootConnection(root)) {
                statusesByUrl.put(hashUrl, CVSFileStatus.STATUS_NOT_UNDER_CVS);
                continue;
            }
            if (!CVSLogin.getMethod(root).isLoggedIn(root)) {
                statusesByUrl.put(hashUrl, CVSFileStatus.STATUS_NOT_UNDER_CVS);
                continue;
            }
            URL directoryUrl = isDirectory ? url : parent;
            boolean exists = URLFileSystem.exists((URL)url);
            if (isDirectory && !exists) {
                statusesByUrl.put(hashUrl, CVSFileStatus.STATUS_NOT_UNDER_CVS);
                continue;
            }
            if (!URLFileSystem.equals((URL)directoryUrl, (URL)sandbox)) {
                statusesByUrl.put(hashUrl, CVSFileStatus.STATUS_UNADDED);
                continue;
            }
            if (isDirectory) {
                statusesByUrl.put(hashUrl, CVSFileStatus.STATUS_SANDBOX);
                continue;
            }
            CVSEntry entry = CVSStatusCache.locateEntry(url);
            if (entry == null) {
                statusesByUrl.put(hashUrl, exists ? CVSFileStatus.STATUS_UNADDED : CVSFileStatus.STATUS_NOT_UNDER_CVS);
                continue;
            }
            if (entry.isDirectory() != isDirectory) {
                statusesByUrl.put(hashUrl, CVSFileStatus.STATUS_NOT_UNDER_CVS);
                continue;
            }
            if (entry.isRemoved()) {
                statusesByUrl.put(hashUrl, CVSFileStatus.STATUS_REMOVED);
                continue;
            }
            if (!exists) {
                statusesByUrl.put(hashUrl, CVSFileStatus.STATUS_NOT_UNDER_CVS);
                continue;
            }
            if (entry.hasConflicts()) {
                statusesByUrl.put(hashUrl, CVSFileStatus.STATUS_CONFLICTS);
                continue;
            }
            if (entry.isAdded()) {
                statusesByUrl.put(hashUrl, CVSFileStatus.STATUS_ADDED);
                continue;
            }
            if (!CVSUniversalTimestamp.createTimestamp(url).equals(new CVSUniversalTimestamp(entry.getTimestamp()))) {
                statusesByUrl.put(hashUrl, CVSFileStatus.STATUS_LOCALLY_CHANGED);
                continue;
            }
            statusesByUrl.put(hashUrl, URLFileSystem.isReadOnly((URL)url) ? CVSFileStatus.STATUS_UNMODIFIED_READONLY : CVSFileStatus.STATUS_UNMODIFIED_READWRITE);
        }
    }

    public static final CVSEntry locateEntry(URL url) throws IOException {
        return CVSEntriesCache.findEntry(CVSEntriesCache.getInstance().getEntriesMap(URLFileSystem.getParent((URL)url)), url);
    }
}

