/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdevimpl.vcs.cvs.client.CVSRootFile;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;

public class CVSRootCache {
    private static final CVSRootCache _inst = new CVSRootCache();
    private static final CVSRootString NULL_ROOT = new CVSRootString("");
    private final Map<VCSHashURL, CVSRootString> _cache = new HashMap<VCSHashURL, CVSRootString>();

    private CVSRootCache() {
    }

    public static final CVSRootCache getInstance() {
        return _inst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CVSRootString getRoot(URL dir) throws IOException {
        Map<VCSHashURL, CVSRootString> map;
        Map<VCSHashURL, CVSRootString> map2 = this._cache;
        synchronized (map2) {
            CVSRootString cachedRoot = this._cache.get(new VCSHashURL(dir));
            if (cachedRoot != null) {
                return cachedRoot != NULL_ROOT ? cachedRoot : null;
            }
        }
        CVSRootString root = null;
        try {
            root = new CVSRootFile(dir).getRoot();
            map = this._cache;
        }
        catch (Throwable throwable) {
            Map<VCSHashURL, CVSRootString> map3 = this._cache;
            synchronized (map3) {
                this._cache.put(new VCSHashURL(dir), root != null ? root : NULL_ROOT);
            }
            throw throwable;
        }
        synchronized (map) {
            this._cache.put(new VCSHashURL(dir), root != null ? root : NULL_ROOT);
        }
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<VCSHashURL, CVSRootString> map = this._cache;
        synchronized (map) {
            this._cache.clear();
        }
    }
}

