/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.awt.EventQueue;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.util.Assert;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.jdeveloper.vcs.util.VCSConfigUtils;
import oracle.jdevimpl.vcs.cvs.CVSActiveClient;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSCommandConstants;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.login.CVSLogin;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionLsSupportCache;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodeUtils;

class CVSPropertyChangeListener
extends StructureChangeListener {
    private Boolean _usingInternalClient = null;

    CVSPropertyChangeListener() {
    }

    public void structureValuesChanged(final StructureChangeEvent e) {
        if (!VCSConfigUtils.isSignificantStructureChange((StructureChangeEvent)e)) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CVSPropertyChangeListener.this._stateChanged(e);
            }
        });
        Controller controller = CVSClient.getInstance().getController();
        if (controller == null) {
            return;
        }
        Context context = Ide.getMainWindow().getLastActiveView().getContext();
        if (context == null) {
            context = new Context();
        }
        this.updateAction(controller, context, CVSCommandConstants.OPERATION_EDIT_CMD_ID);
        this.updateAction(controller, context, CVSCommandConstants.OPERATION_UNEDIT_CMD_ID);
        this.updateAction(controller, context, CVSCommandConstants.OPERATION_WATCH_CMD_ID);
    }

    private void _stateChanged(StructureChangeEvent ce) {
        if (this.eventForClientChange(ce)) {
            String oldExecutablePath = null;
            String newExecutablePath = CVSClient.getInstance().getExecutablePath();
            if (CVSActiveClient.getClientInformation() != null) {
                oldExecutablePath = CVSActiveClient.getClientInformation().getPath();
            }
            boolean clientChanged = false;
            Boolean usingInternalClient = CVSClient.getInstance().isUsingInternalClient();
            if (this._usingInternalClient == null) {
                this._usingInternalClient = usingInternalClient;
                clientChanged = true;
            }
            if (!this._usingInternalClient.equals(usingInternalClient)) {
                clientChanged = true;
            }
            this._usingInternalClient = usingInternalClient;
            if (oldExecutablePath == null || newExecutablePath == null || !oldExecutablePath.equals(newExecutablePath)) {
                CVSClient.getInstance().resetClientStateVerification();
                if (oldExecutablePath != null) {
                    CVSClient.getInstance().verifyClientState();
                }
                if (!this._usingInternalClient.booleanValue()) {
                    clientChanged = true;
                }
            }
            if (clientChanged) {
                CVSLogin.clearCachedObjects();
                try {
                    if (ce.getSource() == null || !ce.getSource().equals(CVSClient.getInstance())) {
                        CVSConnectionNodeUtils.closeAllConnections();
                    }
                }
                catch (Exception e) {
                    Assert.printStackTrace((Throwable)e);
                }
                CVSUtil.clearPerformanceCaches();
                CVSClient.getInstance().updateVersionComponents();
                CVSConnectionLsSupportCache.clear();
            }
        }
        if (CVSClient.getInstance().isUsingNavigatorOverlays()) {
            CVSClient.getInstance().updateOverlayScheme();
            CVSClient.getInstance();
            CVSClient.getStatusCache().clear();
        }
        CVSClient.getInstance().updateControlsForAdvancedMode();
    }

    private void updateAction(Controller controller, Context context, int id) {
        IdeAction action = IdeAction.find((int)id);
        if (action == null) {
            return;
        }
        controller.update(action, context);
    }

    private boolean eventForClientChange(StructureChangeEvent ce) {
        ChangeInfo[] infos;
        for (ChangeInfo info : infos = ce.getChangeDetails()) {
            if (!info.getPropertyName().equals("cvsExternalClient") && !info.getPropertyName().equals("cvsPath")) continue;
            return true;
        }
        return false;
    }
}

